/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.renderer;

import java.io.IOException;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;
import javax.faces.render.Renderer;
import org.omnifaces.resourcehandler.ResourceIdentifier;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Utils;

@FacesRenderer(componentFamily="org.omnifaces.component.script", rendererType="org.omnifaces.DeferredScript")
public class DeferredScriptRenderer
extends Renderer {
    public static final String RENDERER_TYPE = "org.omnifaces.DeferredScript";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        ResourceIdentifier id = new ResourceIdentifier(component);
        Resource resource = FacesLocal.createResource(context, id);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", "type");
        if (resource != null) {
            boolean hasOnerror;
            writer.write("OmniFaces.DeferredScript.add('");
            writer.write(resource.getRequestPath());
            writer.write("','anonymous','");
            writer.write(id.getIntegrity(context));
            writer.write("'");
            Map attributes = component.getAttributes();
            String onbegin = (String)attributes.get("onbegin");
            String onsuccess = (String)attributes.get("onsuccess");
            String onerror = (String)attributes.get("onerror");
            boolean hasOnbegin = !Utils.isEmpty(onbegin);
            boolean hasOnsuccess = !Utils.isEmpty(onsuccess);
            boolean bl = hasOnerror = !Utils.isEmpty(onerror);
            if (hasOnbegin || hasOnsuccess || hasOnerror) {
                this.encodeFunctionArgument(writer, onbegin, hasOnbegin);
            }
            if (hasOnsuccess || hasOnerror) {
                this.encodeFunctionArgument(writer, onsuccess, hasOnsuccess);
            }
            if (hasOnerror) {
                this.encodeFunctionArgument(writer, onerror, true);
            }
            writer.write(");");
        } else {
            writer.writeURIAttribute("src", (Object)"RES_NOT_FOUND", "src");
        }
    }

    private void encodeFunctionArgument(ResponseWriter writer, String function, boolean hasFunction) throws IOException {
        if (hasFunction) {
            writer.write(",function() {");
            writer.write(function);
            writer.write(125);
        } else {
            writer.write(",null");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("script");
    }
}

