/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.resourcehandler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.omnifaces.component.script.DeferredScript;
import org.omnifaces.resourcehandler.CDNResource;
import org.omnifaces.resourcehandler.CDNResourceHandler;
import org.omnifaces.resourcehandler.CombinedResource;
import org.omnifaces.resourcehandler.CombinedResourceInfo;
import org.omnifaces.resourcehandler.DefaultResourceHandler;
import org.omnifaces.resourcehandler.ResourceIdentifier;
import org.omnifaces.util.Events;
import org.omnifaces.util.Faces;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Hacks;
import org.omnifaces.util.Utils;

public class CombinedResourceHandler
extends DefaultResourceHandler
implements SystemEventListener {
    public static final String LIBRARY_NAME = "omnifaces.combined";
    public static final String PARAM_NAME_DISABLED = "org.omnifaces.COMBINED_RESOURCE_HANDLER_DISABLED";
    public static final String PARAM_NAME_EXCLUDED_RESOURCES = "org.omnifaces.COMBINED_RESOURCE_HANDLER_EXCLUDED_RESOURCES";
    public static final String PARAM_NAME_SUPPRESSED_RESOURCES = "org.omnifaces.COMBINED_RESOURCE_HANDLER_SUPPRESSED_RESOURCES";
    public static final String PARAM_NAME_INLINE_CSS = "org.omnifaces.COMBINED_RESOURCE_HANDLER_INLINE_CSS";
    public static final String PARAM_NAME_INLINE_JS = "org.omnifaces.COMBINED_RESOURCE_HANDLER_INLINE_JS";
    public static final String PARAM_NAME_CACHE_TTL = "org.omnifaces.COMBINED_RESOURCE_HANDLER_CACHE_TTL";
    public static final String PARAM_NAME_CROSSORIGIN = "org.omnifaces.COMBINED_RESOURCE_HANDLER_CROSSORIGIN";
    private static final String ERROR_INVALID_CACHE_TTL_PARAM = "Context parameter 'org.omnifaces.COMBINED_RESOURCE_HANDLER_CACHE_TTL' is in invalid syntax. It must represent a valid time in seconds between 0 and 2147483647. Encountered an invalid value of '%s'.";
    private static final String TARGET_HEAD = "head";
    private static final String TARGET_BODY = "body";
    private static final String COMPONENT_ADDED = "javax.faces.component.UIComponentBase.ADDED";
    private static final String DEFAULT_CROSSORIGIN = "anonymous";
    private String disabledParam = Faces.getInitParameter("org.omnifaces.COMBINED_RESOURCE_HANDLER_DISABLED");
    private Set<ResourceIdentifier> excludedResources = CombinedResourceHandler.initResources("org.omnifaces.COMBINED_RESOURCE_HANDLER_EXCLUDED_RESOURCES");
    private Set<ResourceIdentifier> suppressedResources;
    private boolean inlineCSS;
    private boolean inlineJS;
    private Integer cacheTTL;
    private String crossorigin;
    private boolean needsIntegrity;

    public CombinedResourceHandler(ResourceHandler wrapped) {
        super(wrapped);
        this.excludedResources.addAll(CombinedResourceHandler.initCDNResources());
        this.suppressedResources = CombinedResourceHandler.initResources(PARAM_NAME_SUPPRESSED_RESOURCES);
        this.excludedResources.addAll(this.suppressedResources);
        this.inlineCSS = Boolean.parseBoolean(Faces.getInitParameter(PARAM_NAME_INLINE_CSS));
        this.inlineJS = Boolean.parseBoolean(Faces.getInitParameter(PARAM_NAME_INLINE_JS));
        this.cacheTTL = CombinedResourceHandler.initCacheTTL(Faces.getInitParameter(PARAM_NAME_CACHE_TTL));
        this.crossorigin = Utils.coalesce(Faces.getInitParameter(PARAM_NAME_CROSSORIGIN), DEFAULT_CROSSORIGIN);
        this.needsIntegrity = DEFAULT_CROSSORIGIN.equals(this.crossorigin);
        Events.subscribeToApplicationEvent(PreRenderViewEvent.class, this);
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof UIViewRoot;
    }

    public void processEvent(SystemEvent event) {
        Object disabled = Faces.evaluateExpressionGet(this.disabledParam);
        if (this.disabledParam != null && Boolean.parseBoolean(String.valueOf(disabled))) {
            return;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        UIViewRoot view = context.getViewRoot();
        CombinedResourceBuilder builder = new CombinedResourceBuilder();
        for (UIComponent component : view.getComponentResources(context, TARGET_HEAD)) {
            if (component.getAttributes().get("name") == null) continue;
            builder.add(context, component, component.getRendererType(), new ResourceIdentifier(component), TARGET_HEAD);
        }
        for (UIComponent component : view.getComponentResources(context, TARGET_BODY)) {
            if (!(component instanceof DeferredScript)) continue;
            builder.add(context, component, component.getRendererType(), new ResourceIdentifier(component), TARGET_BODY);
        }
        builder.create(context);
    }

    @Override
    public String getLibraryName() {
        return LIBRARY_NAME;
    }

    @Override
    public Resource createResourceFromLibrary(String resourceName, String contentType) {
        return new CombinedResource(resourceName, this.cacheTTL);
    }

    private static Set<ResourceIdentifier> initResources(String name) {
        HashSet<ResourceIdentifier> resources = new HashSet<ResourceIdentifier>(1);
        String configuredResources = Faces.getInitParameter(name);
        if (configuredResources != null) {
            for (String resourceIdentifier : configuredResources.split("\\s*,\\s*")) {
                resources.add(new ResourceIdentifier(resourceIdentifier));
            }
        }
        return resources;
    }

    private static Set<ResourceIdentifier> initCDNResources() {
        Map<ResourceIdentifier, String> cdnResources = CDNResourceHandler.initCDNResources();
        return cdnResources != null ? cdnResources.keySet() : Collections.emptySet();
    }

    private static Integer initCacheTTL(String cacheTTLParam) {
        if (!Faces.isDevelopment() && cacheTTLParam != null) {
            int cacheTTL;
            if (Utils.isNumber(cacheTTLParam) && (cacheTTL = Integer.parseInt(cacheTTLParam)) > 0) {
                return cacheTTL;
            }
            throw new IllegalArgumentException(String.format(ERROR_INVALID_CACHE_TTL_PARAM, cacheTTLParam));
        }
        return null;
    }

    private static void removeComponentResources(FacesContext context, List<UIComponent> componentResourcesToRemove, String target) {
        UIViewRoot view = context.getViewRoot();
        for (UIComponent resourceToRemove : componentResourcesToRemove) {
            if (resourceToRemove == null) continue;
            UIComponent container = Utils.coalesce(Hacks.isMyFacesUsed() ? resourceToRemove.getParent() : resourceToRemove);
            container.setInView(false);
            view.removeComponentResource(context, resourceToRemove, target);
            container.setInView(true);
        }
    }

    private final class Builder {
        private final String extension;
        private final String target;
        private final String rendererType;
        private final CombinedResourceInfo.Builder infoBuilder;
        private final List<UIComponent> componentResourcesToRemove;
        private UIComponent componentResource;

        private Builder(String extension, String target, String rendererType) {
            this.extension = extension;
            this.target = target;
            this.rendererType = rendererType;
            this.infoBuilder = new CombinedResourceInfo.Builder();
            this.componentResourcesToRemove = new ArrayList<UIComponent>();
        }

        private boolean add(UIComponent componentResource, ResourceIdentifier resourceIdentifier) {
            if (componentResource != null && !componentResource.isRendered() || this.containsResourceIdentifier(CombinedResourceHandler.this.suppressedResources, resourceIdentifier)) {
                this.componentResourcesToRemove.add(componentResource);
                return true;
            }
            if (!this.containsResourceIdentifier(CombinedResourceHandler.this.excludedResources, resourceIdentifier)) {
                this.infoBuilder.add(resourceIdentifier);
                boolean deferredScript = componentResource instanceof DeferredScript;
                if (this.componentResource == null && (deferredScript || componentResource != null && componentResource.getAttributes().containsKey("target"))) {
                    this.componentResource = componentResource;
                } else {
                    if (deferredScript) {
                        this.mergeAttribute(this.componentResource, componentResource, "onbegin");
                        this.mergeAttribute(this.componentResource, componentResource, "onsuccess");
                        this.mergeAttribute(this.componentResource, componentResource, "onerror");
                    }
                    this.componentResourcesToRemove.add(componentResource);
                }
                return true;
            }
            return false;
        }

        private boolean containsResourceIdentifier(Set<ResourceIdentifier> ids, ResourceIdentifier id) {
            return !ids.isEmpty() && (ids.contains(id) || ids.contains(new ResourceIdentifier(id.getLibrary(), "*")));
        }

        private void mergeAttribute(UIComponent originalComponent, UIComponent newComponent, String name) {
            String originalAttribute = this.getAttribute(originalComponent, name);
            String newAttribute = this.getAttribute(newComponent, name);
            String separator = originalAttribute.isEmpty() || originalAttribute.endsWith(";") ? "" : ";";
            originalComponent.getAttributes().put(name, originalAttribute + separator + newAttribute);
        }

        private String getAttribute(UIComponent component, String name) {
            String attribute = (String)component.getAttributes().get(name);
            return attribute == null ? "" : attribute.trim();
        }

        private void create(FacesContext context) {
            if (!this.infoBuilder.isEmpty() && !FacesLocal.isAjaxRequestWithPartialRendering(context)) {
                if (this.componentResource == null) {
                    this.componentResource = new UIOutput();
                    this.componentResource.getAttributes().put(CombinedResourceHandler.COMPONENT_ADDED, true);
                    context.getViewRoot().addComponentResource(context, this.componentResource, this.target);
                    this.componentResource.getAttributes().remove(CombinedResourceHandler.COMPONENT_ADDED);
                }
                String resourceName = this.infoBuilder.create() + this.extension;
                this.componentResource.getAttributes().put("library", CombinedResourceHandler.LIBRARY_NAME);
                this.componentResource.getAttributes().put("name", resourceName);
                this.componentResource.setRendererType(this.rendererType);
                Resource resource = FacesLocal.createResource(context, CombinedResourceHandler.LIBRARY_NAME, resourceName);
                if (resource instanceof CDNResource) {
                    this.setFallbackURL(context, (CDNResource)resource);
                } else if (Utils.isOneOf(this.rendererType, "javax.faces.resource.Script", "javax.faces.resource.Stylesheet")) {
                    this.componentResource.getPassThroughAttributes().put("crossorigin", CombinedResourceHandler.this.crossorigin);
                    this.componentResource.getPassThroughAttributes().put("integrity", this.getIntegrityIfNecessary(context, resource));
                }
            }
            CombinedResourceHandler.removeComponentResources(context, this.componentResourcesToRemove, this.target);
        }

        private void setFallbackURL(FacesContext context, CDNResource cdnResource) {
            String fallbackURL = cdnResource.getLocalRequestPath();
            if ("javax.faces.resource.Script".equals(this.rendererType)) {
                this.componentResource.getPassThroughAttributes().put("onerror", "document.write('<script src=\"" + fallbackURL + "\" crossorigin=\"" + CombinedResourceHandler.this.crossorigin + "\" integrity=\"" + this.getIntegrityIfNecessary(context, (Resource)cdnResource) + "\"></script>')");
            } else if ("javax.faces.resource.Stylesheet".equals(this.rendererType)) {
                this.componentResource.getPassThroughAttributes().put("onerror", "this.onerror=null;this.href='" + fallbackURL + "'");
            } else if ("org.omnifaces.DeferredScript".equals(this.rendererType)) {
                String callbacks = "";
                String onsuccess = (String)this.componentResource.getAttributes().get("onsuccess");
                if (onsuccess != null) {
                    callbacks = ",null,function(){" + onsuccess + "}";
                }
                this.componentResource.getAttributes().put("onerror", "OmniFaces.Util.loadScript('" + fallbackURL + "','" + CombinedResourceHandler.this.crossorigin + "','" + this.getIntegrityIfNecessary(context, (Resource)cdnResource) + "'" + callbacks + ")");
            }
        }

        private String getIntegrityIfNecessary(FacesContext context, Resource resource) {
            return CombinedResourceHandler.this.needsIntegrity ? new ResourceIdentifier(resource).getIntegrity(context) : "";
        }
    }

    private final class CombinedResourceBuilder {
        private static final String EXTENSION_CSS = ".css";
        private static final String EXTENSION_JS = ".js";
        private Builder stylesheets;
        private Builder scripts;
        private Map<String, Builder> deferredScripts;
        private List<UIComponent> componentResourcesToRemove;

        public CombinedResourceBuilder() {
            this.stylesheets = new Builder(EXTENSION_CSS, CombinedResourceHandler.TARGET_HEAD, CombinedResourceHandler.this.inlineCSS ? "org.omnifaces.InlineStylesheet" : "javax.faces.resource.Stylesheet");
            this.scripts = new Builder(EXTENSION_JS, CombinedResourceHandler.TARGET_HEAD, CombinedResourceHandler.this.inlineJS ? "org.omnifaces.InlineScript" : "javax.faces.resource.Script");
            this.deferredScripts = new LinkedHashMap<String, Builder>();
            this.componentResourcesToRemove = new ArrayList<UIComponent>();
        }

        private void add(FacesContext context, UIComponent component, String rendererType, ResourceIdentifier id, String target) {
            if (CombinedResourceHandler.LIBRARY_NAME.equals(id.getLibrary())) {
                this.addCombined(context, component, rendererType, id, target);
            } else if (rendererType.equals("javax.faces.resource.Stylesheet")) {
                this.addStylesheet(context, component, id);
            } else if (rendererType.equals("javax.faces.resource.Script")) {
                this.addScript(context, component, id);
            } else if (component instanceof DeferredScript) {
                this.addDeferredScript(component, id);
            }
        }

        private void addCombined(FacesContext context, UIComponent component, String rendererType, ResourceIdentifier id, String target) {
            String[] resourcePathParts = id.getName().split("\\.", 2)[0].split("/");
            String resourceId = resourcePathParts[resourcePathParts.length - 1];
            CombinedResourceInfo info = CombinedResourceInfo.get(resourceId);
            boolean added = false;
            if (info != null) {
                for (ResourceIdentifier combinedId : info.getResourceIdentifiers()) {
                    this.add(context, added ? null : component, rendererType, combinedId, target);
                    added = true;
                }
            }
            if (!added) {
                this.componentResourcesToRemove.add(component);
            }
        }

        private void addStylesheet(FacesContext context, UIComponent component, ResourceIdentifier id) {
            if (component != null && "print".equals(component.getAttributes().get("media"))) {
                return;
            }
            ResourceHandler resourceHandler = context.getApplication().getResourceHandler();
            if (resourceHandler.isResourceRendered(context, id.getName(), id.getLibrary())) {
                this.componentResourcesToRemove.add(component);
            } else if (this.stylesheets.add(component, id)) {
                resourceHandler.markResourceRendered(context, id.getName(), id.getLibrary());
            }
        }

        private void addScript(FacesContext context, UIComponent component, ResourceIdentifier id) {
            ResourceHandler resourceHandler = context.getApplication().getResourceHandler();
            if (resourceHandler.isResourceRendered(context, id.getName(), id.getLibrary())) {
                this.componentResourcesToRemove.add(component);
            } else if (this.scripts.add(component, id)) {
                resourceHandler.markResourceRendered(context, id.getName(), id.getLibrary());
            }
        }

        private void addDeferredScript(UIComponent component, ResourceIdentifier id) {
            String group = (String)component.getAttributes().get("group");
            this.deferredScripts.computeIfAbsent(group, k -> new Builder(EXTENSION_JS, CombinedResourceHandler.TARGET_BODY, "org.omnifaces.DeferredScript")).add(component, id);
        }

        public void create(FacesContext context) {
            this.stylesheets.create(context);
            this.scripts.create(context);
            for (Builder builder : this.deferredScripts.values()) {
                builder.create(context);
            }
            CombinedResourceHandler.removeComponentResources(context, this.componentResourcesToRemove, CombinedResourceHandler.TARGET_HEAD);
        }
    }
}

