/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.resourcehandler;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.omnifaces.facesviews.FacesViews;
import org.omnifaces.resourcehandler.DefaultResourceHandler;
import org.omnifaces.resourcehandler.RemappedResource;
import org.omnifaces.util.Faces;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Hacks;
import org.omnifaces.util.Utils;

public class UnmappedResourceHandler
extends DefaultResourceHandler {
    private static final Logger logger = Logger.getLogger(UnmappedResourceHandler.class.getName());

    public UnmappedResourceHandler(ResourceHandler wrapped) {
        super(wrapped);
    }

    @Override
    public Resource decorateResource(Resource resource) {
        if (resource == null) {
            return resource;
        }
        String path = UnmappedResourceHandler.fixMyFacesMultiViewsPrefixMappingIfNecessary(resource.getRequestPath());
        return UnmappedResourceHandler.isResourceRequest(path) ? new RemappedResource(resource, UnmappedResourceHandler.unmapRequestPath(path)) : resource;
    }

    public boolean isResourceRequest(FacesContext context) {
        return UnmappedResourceHandler.isResourceRequest(FacesLocal.getRequestURI(context)) || super.isResourceRequest(context);
    }

    public void handleResourceRequest(FacesContext context) throws IOException {
        Resource resource = UnmappedResourceHandler.createResource(context);
        if (resource == null) {
            super.handleResourceRequest(context);
            return;
        }
        ExternalContext externalContext = context.getExternalContext();
        if (!resource.userAgentNeedsUpdate(context)) {
            externalContext.setResponseStatus(304);
            return;
        }
        InputStream inputStream = null;
        try {
            inputStream = resource.getInputStream();
        }
        catch (Exception resourceNameIsProbablyInvalid) {
            logger.log(Level.FINE, "Ignoring thrown exception; this can only be caused by a spoofed request.", resourceNameIsProbablyInvalid);
        }
        if (inputStream == null) {
            externalContext.setResponseStatus(404);
            return;
        }
        externalContext.setResponseContentType(resource.getContentType());
        for (Map.Entry header : resource.getResponseHeaders().entrySet()) {
            externalContext.setResponseHeader((String)header.getKey(), (String)header.getValue());
        }
        Utils.stream(inputStream, externalContext.getResponseOutputStream());
    }

    private static boolean isResourceRequest(String path) {
        return path.startsWith(Faces.getRequestContextPath() + "/javax.faces.resource");
    }

    private static String fixMyFacesMultiViewsPrefixMappingIfNecessary(String path) {
        String resourcePath;
        String contextPath;
        if (!(Hacks.isMyFacesUsed() && FacesViews.isMultiViewsEnabled(Faces.getServletContext()) && Faces.isPrefixMapping())) {
            return path;
        }
        int resourceIdentifierIndex = path.indexOf("/javax.faces.resource");
        if (resourceIdentifierIndex > -1 && path.startsWith(contextPath = Faces.getRequestContextPath()) && !path.startsWith(resourcePath = contextPath + "/javax.faces.resource")) {
            return resourcePath + path.substring(resourceIdentifierIndex);
        }
        return path;
    }

    private static String unmapRequestPath(String path) {
        String mapping = Faces.getMapping();
        if (Faces.isPrefixMapping(mapping)) {
            return path.replaceFirst(mapping, "");
        }
        if (path.contains("?")) {
            return path.replace(mapping + "?", "?");
        }
        if (path.endsWith(mapping)) {
            return path.substring(0, path.length() - mapping.length());
        }
        return path;
    }

    private static Resource createResource(FacesContext context) {
        String resourceName;
        if (Hacks.isPrimeFacesDynamicResourceRequest(context)) {
            return null;
        }
        String pathInfo = context.getExternalContext().getRequestPathInfo();
        String string = resourceName = pathInfo != null ? pathInfo.substring(1) : "";
        if (resourceName.isEmpty()) {
            return null;
        }
        String libraryName = (String)context.getExternalContext().getRequestParameterMap().get("ln");
        return FacesLocal.createResource(context, libraryName, resourceName);
    }
}

