/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.taghandler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.omnifaces.util.Utils;

public class MassAttribute
extends TagHandler {
    private static final Set<String> ILLEGAL_NAMES = Utils.unmodifiableSet("id", "binding");
    private static final String ERROR_ILLEGAL_NAME = "The 'name' attribute may not be set to 'id' or 'binding'.";
    private static final String ERROR_UNAVAILABLE_TARGET = "The 'target' attribute must represent a valid class name. Encountered '%s' which cannot be found in the classpath.";
    private static final String ERROR_INVALID_TARGET = "The 'target' attribute must represent an UIComponent class. Encountered '%s' which is not an UIComponent class.";
    private String name = this.getRequiredAttribute("name").getValue();
    private TagAttribute value;
    private Class<UIComponent>[] targetClasses;

    public MassAttribute(TagConfig config) {
        super(config);
        if (ILLEGAL_NAMES.contains(this.name)) {
            throw new IllegalArgumentException(ERROR_ILLEGAL_NAME);
        }
        this.value = this.getRequiredAttribute("value");
        TagAttribute target = this.getAttribute("target");
        if (target != null) {
            List<String> classNames = Utils.csvToList(target.getValue());
            this.targetClasses = new Class[classNames.size()];
            for (int i = 0; i < classNames.size(); ++i) {
                String className = classNames.get(i);
                Class<?> cls = null;
                try {
                    cls = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException(String.format(ERROR_UNAVAILABLE_TARGET, className), e);
                }
                if (!UIComponent.class.isAssignableFrom(cls)) {
                    throw new IllegalArgumentException(String.format(ERROR_INVALID_TARGET, cls));
                }
                this.targetClasses[i] = cls;
            }
        }
    }

    public void apply(FaceletContext context, UIComponent parent) throws IOException {
        ArrayList oldChildren = new ArrayList(parent.getChildren());
        this.nextHandler.apply(context, parent);
        if (ComponentHandler.isNew((UIComponent)parent)) {
            ArrayList<UIComponent> newChildren = new ArrayList<UIComponent>(parent.getChildren());
            newChildren.removeAll(oldChildren);
            this.applyMassAttribute(context, newChildren);
        }
    }

    private void applyMassAttribute(FaceletContext context, List<UIComponent> children) {
        for (UIComponent component : children) {
            Object literalValue;
            if ((this.targetClasses == null || Utils.isOneInstanceOf(component.getClass(), this.targetClasses)) && component.getValueExpression(this.name) == null && ((literalValue = component.getAttributes().get(this.name)) == null || literalValue instanceof Boolean)) {
                Class type = literalValue == null ? Object.class : Boolean.class;
                component.setValueExpression(this.name, this.value.getValueExpression(context, type));
            }
            this.applyMassAttribute(context, component.getChildren());
        }
    }
}

