/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.taghandler;

import java.beans.Introspector;
import java.io.IOException;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.el.ValueReference;
import javax.faces.FacesException;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.component.visit.VisitHint;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.event.PostValidateEvent;
import javax.faces.event.PreValidateEvent;
import javax.faces.validator.Validator;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import javax.validation.ConstraintViolation;
import javax.validation.Valid;
import org.omnifaces.el.ExpressionInspector;
import org.omnifaces.eventlistener.BeanValidationEventListener;
import org.omnifaces.util.Beans;
import org.omnifaces.util.Callback;
import org.omnifaces.util.Components;
import org.omnifaces.util.Events;
import org.omnifaces.util.Facelets;
import org.omnifaces.util.Faces;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Messages;
import org.omnifaces.util.Reflection;
import org.omnifaces.util.Utils;
import org.omnifaces.util.Validators;
import org.omnifaces.util.copier.Copier;
import org.omnifaces.util.copier.MultiStrategyCopier;

public class ValidateBean
extends TagHandler {
    private static final Logger logger = Logger.getLogger(ValidateBean.class.getName());
    private static final String DEFAULT_SHOWMESSAGEFOR = "@form";
    private static final String ERROR_MISSING_FORM = "o:validateBean must be nested in an UIForm.";
    private static final String ERROR_INVALID_PARENT = "o:validateBean parent must be an instance of UIInput or UICommand.";
    private static final String WARN_UNDISPLAYED_VIOLATION = "o:validateBean could not display violation message '%s' for property path '%s'.";
    private ValueExpression value;
    private boolean disabled;
    private ValidateMethod method;
    private String groups;
    private String copier;
    private String showMessageFor;
    private String messageFormat;

    public ValidateBean(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext context, UIComponent parent) throws IOException {
        if (this.getAttribute("value") == null && !(parent instanceof UICommand) && !(parent instanceof UIInput)) {
            throw new IllegalArgumentException(ERROR_INVALID_PARENT);
        }
        FacesContext facesContext = context.getFacesContext();
        if (!ComponentHandler.isNew((UIComponent)parent) || !facesContext.isPostback() || facesContext.getCurrentPhaseId() != PhaseId.RESTORE_VIEW) {
            return;
        }
        this.value = Facelets.getValueExpression(context, this.getAttribute("value"), Object.class);
        this.disabled = Facelets.getBoolean(context, this.getAttribute("disabled"));
        this.method = ValidateMethod.of(Facelets.getString(context, this.getAttribute("method")));
        this.groups = Facelets.getString(context, this.getAttribute("validationGroups"));
        this.copier = Facelets.getString(context, this.getAttribute("copier"));
        this.showMessageFor = Utils.coalesce(Facelets.getString(context, this.getAttribute("showMessageFor")), DEFAULT_SHOWMESSAGEFOR);
        this.messageFormat = Facelets.getString(context, this.getAttribute("messageFormat"));
        Events.subscribeToRequestAfterPhase(PhaseId.RESTORE_VIEW, () -> this.processValidateBean(facesContext, parent));
    }

    protected void processValidateBean(FacesContext context, UIComponent component) {
        UIForm form;
        UIForm uIForm = form = component instanceof UIForm ? (UIForm)component : Components.getClosestParent(component, UIForm.class);
        if (form == null) {
            throw new IllegalStateException(ERROR_MISSING_FORM);
        }
        if (!form.equals(Components.getCurrentForm()) || !(component instanceof UIForm) && !Components.hasInvokedSubmit(component)) {
            return;
        }
        Object bean = null;
        if (this.value != null) {
            Object[] found = new Object[1];
            Components.forEachComponent(context).fromRoot((UIComponent)form).invoke(target -> {
                found[0] = this.value.getValue(Faces.getELContext());
            });
            bean = found[0];
        }
        if (bean == null) {
            this.validateForm();
            return;
        }
        if (!this.disabled) {
            if (this.method == ValidateMethod.validateActual) {
                this.validateActualBean(form, bean);
            } else {
                this.validateCopiedBean(form, bean);
            }
        }
    }

    private void validateActualBean(final UIForm form, final Object bean) {
        ValidateBeanCallback validateActualBean = new ValidateBeanCallback(){

            @Override
            public void run() {
                FacesContext context = FacesContext.getCurrentInstance();
                ValidateBean.this.validate(context, form, bean, Beans.unwrapIfNecessary(bean), new HashSet(0), false);
            }
        };
        Events.subscribeToRequestAfterPhase(PhaseId.UPDATE_MODEL_VALUES, validateActualBean);
    }

    private void validateCopiedBean(final UIForm form, final Object bean) {
        final HashSet collectedClientIds = new HashSet();
        final HashMap collectedProperties = new HashMap();
        final Map<Object, Reflection.PropertyPath> knownBaseProperties = Reflection.getBaseBeanPropertyPaths(bean, this::isValidAnnotationPresent);
        ValidateBeanCallback collectBeanProperties = new ValidateBeanCallback(){

            @Override
            public void run() {
                FacesContext context = FacesContext.getCurrentInstance();
                ValidateBean.forEachInputWithMatchingBase(context, (UIComponent)form, knownBaseProperties.keySet(), input -> ValidateBean.addCollectingValidator(input, collectedClientIds, collectedProperties, knownBaseProperties));
            }
        };
        ValidateBeanCallback checkConstraints = new ValidateBeanCallback(){

            @Override
            public void run() {
                FacesContext context = FacesContext.getCurrentInstance();
                ValidateBean.forEachInputWithMatchingBase(context, (UIComponent)form, knownBaseProperties.keySet(), x$0 -> ValidateBean.removeCollectingValidator(x$0));
                Object copiedBean = ValidateBean.getCopier(context, ValidateBean.this.copier).copy(Beans.unwrapIfNecessary(bean));
                Reflection.setBeanProperties(copiedBean, collectedProperties);
                ValidateBean.this.validate(context, form, bean, copiedBean, collectedClientIds, true);
            }
        };
        Events.subscribeToRequestBeforePhase(PhaseId.PROCESS_VALIDATIONS, collectBeanProperties);
        Events.subscribeToRequestAfterPhase(PhaseId.PROCESS_VALIDATIONS, checkConstraints);
    }

    private boolean isValidAnnotationPresent(Method getter) {
        if (getter.isAnnotationPresent(Valid.class)) {
            return true;
        }
        Class<?> beanClass = getter.getDeclaringClass();
        if (beanClass.isAnnotationPresent(Valid.class)) {
            return true;
        }
        String propertyName = Introspector.decapitalize(getter.getName().replaceFirst("get", ""));
        Field property = Arrays.stream(beanClass.getDeclaredFields()).filter(field -> field.getName().equals(propertyName)).findFirst().orElse(null);
        if (property == null) {
            return false;
        }
        if (property.isAnnotationPresent(Valid.class)) {
            return true;
        }
        if (property.getAnnotatedType() instanceof AnnotatedParameterizedType) {
            for (AnnotatedType type : ((AnnotatedParameterizedType)property.getAnnotatedType()).getAnnotatedActualTypeArguments()) {
                if (!type.isAnnotationPresent(Valid.class)) continue;
                return true;
            }
        }
        return false;
    }

    private void validateForm() {
        ValidateBeanCallback validateForm = new ValidateBeanCallback(){

            @Override
            public void run() {
                BeanValidationEventListener listener = new BeanValidationEventListener(ValidateBean.this.groups, ValidateBean.this.disabled);
                Events.subscribeToViewEvent(PreValidateEvent.class, listener);
                Events.subscribeToViewEvent(PostValidateEvent.class, listener);
            }
        };
        Events.subscribeToRequestBeforePhase(PhaseId.PROCESS_VALIDATIONS, validateForm);
    }

    private void validate(FacesContext context, UIForm form, Object actualBean, Object validableBean, Set<String> clientIds, boolean renderResponseOnFail) {
        ArrayList groupClasses = new ArrayList();
        for (String group : Utils.csvToList(this.groups)) {
            groupClasses.add(Reflection.toClass(group));
        }
        Set<ConstraintViolation<?>> violations = Validators.validateBean(validableBean, groupClasses.toArray(new Class[groupClasses.size()]));
        if (!violations.isEmpty()) {
            if ("@violating".equals(this.showMessageFor)) {
                ValidateBean.invalidateInputsByPropertyPathAndShowMessages(context, form, actualBean, violations, this.messageFormat);
            } else if (this.showMessageFor.charAt(0) != '@') {
                ValidateBean.invalidateInputsByShowMessageForAndShowMessages(context, form, violations, this.showMessageFor, this.messageFormat);
            } else {
                ValidateBean.invalidateInputsByClientIdsAndShowMessages(context, form, violations, clientIds, this.showMessageFor, this.messageFormat);
            }
            if (context.isValidationFailed() && renderResponseOnFail) {
                context.renderResponse();
            }
        }
    }

    private static void forEachInputWithMatchingBase(FacesContext context, UIComponent form, Set<Object> bases, String property, Callback.WithArgument<UIInput> callback) {
        Components.forEachComponent(context).fromRoot(form).ofTypes(UIInput.class).withHints(VisitHint.SKIP_UNRENDERED).invoke(input -> {
            ValueReference valueReference;
            ValueExpression valueExpression = input.getValueExpression("value");
            if (valueExpression != null && bases.contains((valueReference = ExpressionInspector.getValueReference(context.getELContext(), valueExpression)).getBase()) && (property == null || property.equals(valueReference.getProperty()))) {
                callback.invoke((UIInput)input);
            }
        });
    }

    private static void forEachInputWithMatchingBase(FacesContext context, UIComponent form, Set<Object> bases, Callback.WithArgument<UIInput> callback) {
        ValidateBean.forEachInputWithMatchingBase(context, form, bases, null, callback);
    }

    private static void addCollectingValidator(UIInput input, Set<String> collectedClientIds, Map<Reflection.PropertyPath, Object> collectedProperties, Map<Object, Reflection.PropertyPath> knownBaseProperties) {
        input.addValidator((Validator)new CollectingValidator(collectedClientIds, collectedProperties, knownBaseProperties));
    }

    private static void removeCollectingValidator(UIInput input) {
        Validator collectingValidator = null;
        for (Validator validator : input.getValidators()) {
            if (!(validator instanceof CollectingValidator)) continue;
            collectingValidator = validator;
            break;
        }
        if (collectingValidator != null) {
            input.removeValidator(collectingValidator);
        }
    }

    private static Copier getCopier(FacesContext context, String copierName) {
        Copier copier = null;
        if (!Utils.isEmpty(copierName)) {
            Object expressionResult = FacesLocal.evaluateExpressionGet(context, copierName);
            if (expressionResult instanceof Copier) {
                copier = (Copier)expressionResult;
            } else if (expressionResult instanceof String) {
                copier = (Copier)Reflection.instance((String)expressionResult);
            }
        }
        if (copier == null) {
            copier = new MultiStrategyCopier();
        }
        return copier;
    }

    private static void invalidateInputsByPropertyPathAndShowMessages(FacesContext context, UIForm form, Object bean, Set<ConstraintViolation<?>> violations, String messageFormat) {
        HashSet undisplayed = new HashSet(violations);
        block0: for (ConstraintViolation<?> constraintViolation : violations) {
            for (Map.Entry<Object, String> baseAndProperty : Validators.resolveViolatedBasesAndProperties(bean, constraintViolation)) {
                boolean[] displayed = new boolean[]{false};
                ValidateBean.forEachInputWithMatchingBase(context, (UIComponent)form, Collections.singleton(baseAndProperty.getKey()), baseAndProperty.getValue(), input -> {
                    context.validationFailed();
                    input.setValid(false);
                    String clientId = input.getClientId(context);
                    Messages.addError(clientId, ValidateBean.formatMessage(violation.getMessage(), Components.getLabel((UIComponent)input), messageFormat), new Object[0]);
                    undisplayed.remove(violation);
                    displayed[0] = true;
                });
                if (!displayed[0]) continue;
                continue block0;
            }
        }
        if (FacesLocal.isDevelopment(context)) {
            for (ConstraintViolation constraintViolation : undisplayed) {
                logger.log(Level.WARNING, String.format(WARN_UNDISPLAYED_VIOLATION, constraintViolation.getMessage(), constraintViolation.getPropertyPath()));
            }
        }
    }

    private static void invalidateInputsByShowMessageForAndShowMessages(FacesContext context, UIForm form, Set<ConstraintViolation<?>> violations, String showMessageFor, String messageFormat) {
        for (String forId : showMessageFor.split("\\s+")) {
            UIComponent component = form.findComponent(forId);
            context.validationFailed();
            if (component instanceof UIInput) {
                ((UIInput)component).setValid(false);
            }
            String clientId = component.getClientId(context);
            ValidateBean.addErrors(clientId, violations, Components.getLabel(component), messageFormat);
        }
    }

    private static void invalidateInputsByClientIdsAndShowMessages(FacesContext context, UIForm form, Set<ConstraintViolation<?>> violations, Set<String> clientIds, String showMessageFor, String messageFormat) {
        context.validationFailed();
        StringBuilder labels = new StringBuilder();
        if (!clientIds.isEmpty()) {
            Components.forEachComponent(context).fromRoot((UIComponent)form).havingIds(clientIds).invoke(input -> {
                input.setValid(false);
                if (labels.length() > 0) {
                    labels.append(", ");
                }
                labels.append(Components.getLabel((UIComponent)input));
            });
        }
        ValidateBean.showMessages(context, form, violations, clientIds, labels.toString(), showMessageFor, messageFormat);
    }

    private static void showMessages(FacesContext context, UIForm form, Set<ConstraintViolation<?>> violations, Set<String> clientIds, String labels, String showMessagesFor, String messageFormat) {
        if (DEFAULT_SHOWMESSAGEFOR.equals(showMessagesFor)) {
            String formId = form.getClientId(context);
            ValidateBean.addErrors(formId, violations, labels, messageFormat);
        } else if ("@all".equals(showMessagesFor)) {
            for (String clientId : clientIds) {
                ValidateBean.addErrors(clientId, violations, labels, messageFormat);
            }
        } else if ("@global".equals(showMessagesFor)) {
            for (ConstraintViolation<?> violation : violations) {
                Messages.addGlobalError(ValidateBean.formatMessage(violation.getMessage(), labels, messageFormat), new Object[0]);
            }
        } else {
            for (String clientId : showMessagesFor.split("\\s+")) {
                ValidateBean.addErrors(clientId, violations, labels, messageFormat);
            }
        }
    }

    private static void addErrors(String clientId, Set<ConstraintViolation<?>> violations, String labels, String messageFormat) {
        for (ConstraintViolation<?> violation : violations) {
            Messages.addError(clientId, ValidateBean.formatMessage(violation.getMessage(), labels, messageFormat), new Object[0]);
        }
    }

    private static String formatMessage(String message, String label, String messageFormat) {
        if (!Utils.isEmpty(label)) {
            ResourceBundle messageBundle;
            String pattern = messageFormat;
            if (pattern == null && (messageBundle = Faces.getMessageBundle()) != null && messageBundle.containsKey("javax.faces.validator.BeanValidator.MESSAGE")) {
                pattern = messageBundle.getString("javax.faces.validator.BeanValidator.MESSAGE");
            }
            if (pattern != null) {
                return MessageFormat.format(pattern, message, label);
            }
        }
        return message;
    }

    private static abstract class ValidateBeanCallback
    implements Callback.Void {
        private ValidateBeanCallback() {
        }

        @Override
        public void invoke() {
            try {
                this.run();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception occured while doing validation.", e);
                Faces.validationFailed();
                Faces.renderResponse();
                throw new FacesException((Throwable)e);
            }
        }

        public abstract void run();
    }

    public static final class CollectingValidator
    implements Validator<Object> {
        private final Set<String> collectedClientIds;
        private final Map<Reflection.PropertyPath, Object> collectedProperties;
        private final Map<Object, Reflection.PropertyPath> knownBaseProperties;

        public CollectingValidator(Set<String> collectedClientIds, Map<Reflection.PropertyPath, Object> collectedProperties, Map<Object, Reflection.PropertyPath> knownBaseProperties) {
            this.collectedClientIds = collectedClientIds;
            this.collectedProperties = collectedProperties;
            this.knownBaseProperties = knownBaseProperties;
        }

        public void validate(FacesContext context, UIComponent component, Object value) {
            ValueExpression valueExpression = component.getValueExpression("value");
            if (valueExpression != null) {
                this.collectedClientIds.add(component.getClientId(context));
                ValueReference valueReference = ExpressionInspector.getValueReference(context.getELContext(), valueExpression);
                Comparable property = (Comparable)valueReference.getProperty();
                Reflection.PropertyPath basePath = this.knownBaseProperties.get(valueReference.getBase());
                Reflection.PropertyPath path = basePath != null ? basePath.with(property) : Reflection.PropertyPath.of(property);
                this.collectedProperties.put(path, value);
            }
        }
    }

    private static enum ValidateMethod {
        validateCopy,
        validateActual;


        public static ValidateMethod of(String name) {
            if (Utils.isEmpty(name)) {
                return validateCopy;
            }
            return ValidateMethod.valueOf(name);
        }
    }
}

