/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.InjectionPoint;
import org.omnifaces.util.BeansLocal;
import org.omnifaces.util.JNDI;
import org.omnifaces.util.Reflection;

@Typed
public final class Beans {
    private static final Logger logger = Logger.getLogger(Beans.class.getName());
    private static final String[] PROXY_INTERFACE_NAMES = new String[]{"org.jboss.weld.proxy.WeldConstruct", "org.apache.webbeans.proxy.OwbNormalScopeProxy", "io.quarkus.arc.ClientProxy", "io.quarkus.arc.Subclass"};
    private static final Pattern PATTERN_GENERATED_PROXY_CLASS_NAME = Pattern.compile("(.+)(\\$\\$(.*)Proxy|Proxy(.*)\\$\\$)(.*)", 2);

    private Beans() {
    }

    public static BeanManager getManager() {
        try {
            return CDI.current().getBeanManager();
        }
        catch (Exception | LinkageError e) {
            logger.log(Level.FINE, "Cannot get BeanManager from CDI.current(); falling back to JNDI.", e);
            BeanManager manager = (BeanManager)JNDI.lookup("java:comp/BeanManager");
            if (manager == null) {
                manager = (BeanManager)JNDI.lookup("java:comp/env/BeanManager");
            }
            return manager;
        }
    }

    public static <T> Bean<T> resolve(Class<T> beanClass, Annotation ... qualifiers) {
        return BeansLocal.resolve(Beans.getManager(), beanClass, qualifiers);
    }

    public static <T> Bean<T> resolveExact(Class<T> beanClass, Annotation ... qualifiers) {
        return BeansLocal.resolveExact(Beans.getManager(), beanClass, qualifiers);
    }

    public static <T> T getReference(Class<T> beanClass, Annotation ... qualifiers) {
        return BeansLocal.getReference(Beans.getManager(), beanClass, qualifiers);
    }

    public static <T> T getReference(Bean<T> bean) {
        return BeansLocal.getReference(Beans.getManager(), bean);
    }

    public static <T> T getInstance(Class<T> beanClass, Annotation ... qualifiers) {
        return BeansLocal.getInstance(Beans.getManager(), beanClass, qualifiers);
    }

    public static <T> T getInstance(Class<T> beanClass, boolean create, Annotation ... qualifiers) {
        return BeansLocal.getInstance(Beans.getManager(), beanClass, create, qualifiers);
    }

    public static <T> T getInstance(Bean<T> bean, boolean create) {
        return BeansLocal.getInstance(Beans.getManager(), bean, create);
    }

    public static <T> T getInstance(String name, boolean create) {
        return BeansLocal.getInstance(Beans.getManager(), name, create);
    }

    public static <T> T getInstance(String name) {
        return BeansLocal.getInstance(Beans.getManager(), name);
    }

    public static <T> boolean isProxy(T object) {
        if (object == null) {
            return false;
        }
        Class<?> beanClass = object instanceof Class ? (Class<?>)object : object.getClass();
        for (String proxyInterfaceName : PROXY_INTERFACE_NAMES) {
            Class proxyInterface = Reflection.toClassOrNull(proxyInterfaceName);
            if (proxyInterface == null || !proxyInterface.isAssignableFrom(beanClass)) continue;
            return true;
        }
        return PATTERN_GENERATED_PROXY_CLASS_NAME.matcher(beanClass.getSimpleName()).matches();
    }

    public static <T> T unwrapIfNecessary(T object) {
        return BeansLocal.unwrapIfNecessary(Beans.getManager(), object);
    }

    public static <S extends Annotation> boolean isActive(Class<S> scope) {
        return BeansLocal.isActive(Beans.getManager(), scope);
    }

    public static <S extends Annotation> Map<Object, String> getActiveInstances(Class<S> scope) {
        return BeansLocal.getActiveInstances(Beans.getManager(), scope);
    }

    public static <T> void destroy(Class<T> beanClass, Annotation ... qualifiers) {
        BeansLocal.destroy(Beans.getManager(), beanClass, qualifiers);
    }

    public static <T> void destroy(Bean<T> bean) {
        BeansLocal.destroy(Beans.getManager(), bean);
    }

    public static <T> void destroy(T instance) {
        BeansLocal.destroy(Beans.getManager(), instance);
    }

    public static <A extends Annotation> A getAnnotation(Annotated annotated, Class<A> annotationType) {
        return BeansLocal.getAnnotation(Beans.getManager(), annotated, annotationType);
    }

    public static InjectionPoint getCurrentInjectionPoint(CreationalContext<?> creationalContext) {
        return BeansLocal.getCurrentInjectionPoint(Beans.getManager(), creationalContext);
    }

    public static <A extends Annotation> A getQualifier(InjectionPoint injectionPoint, Class<A> qualifierClass) {
        for (Annotation annotation : injectionPoint.getQualifiers()) {
            if (!qualifierClass.isAssignableFrom(annotation.getClass())) continue;
            return (A)((Annotation)qualifierClass.cast(annotation));
        }
        return null;
    }

    public static void fireEvent(Object event, Annotation ... qualifiers) {
        BeansLocal.fireEvent(Beans.getManager(), event, qualifiers);
    }
}

