/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.application.ViewHandler;
import javax.faces.component.ActionSource2;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.component.UIMessage;
import javax.faces.component.UIMessages;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIOutput;
import javax.faces.component.UIParameter;
import javax.faces.component.UIViewRoot;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.BehaviorBase;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlBody;
import javax.faces.component.search.SearchExpressionContext;
import javax.faces.component.search.SearchExpressionHint;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextWrapper;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorListener;
import javax.faces.event.MethodExpressionActionListener;
import javax.faces.event.PhaseId;
import javax.faces.render.RenderKit;
import org.omnifaces.component.ParamHolder;
import org.omnifaces.component.SimpleParam;
import org.omnifaces.component.input.Form;
import org.omnifaces.el.ScopedRunner;
import org.omnifaces.util.Ajax;
import org.omnifaces.util.Callback;
import org.omnifaces.util.Events;
import org.omnifaces.util.Faces;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Hacks;
import org.omnifaces.util.Utils;

public final class Components {
    private static final Logger logger = Logger.getLogger(Components.class.getName());
    public static final String LABEL_ATTRIBUTE = "label";
    public static final String VALUE_ATTRIBUTE = "value";
    private static final String ERROR_MISSING_PARENT = "Component '%s' must have a parent of type '%s', but it cannot be found.";
    private static final String ERROR_MISSING_DIRECT_PARENT = "Component '%s' must have a direct parent of type '%s', but it cannot be found.";
    private static final String ERROR_MISSING_CHILD = "Component '%s' must have at least one child of type '%s', but it cannot be found.";
    private static final String ERROR_ILLEGAL_PARENT = "Component '%s' may not have a parent of type '%s'.";
    private static final String ERROR_ILLEGAL_CHILDREN = "Component '%s' may only have children of type '%s'. Encountered children of types '%s'.";
    private static final String ERROR_CHILDREN_DISALLOWED = "Component '%s' may not have any children. Encountered children of types '%s'.";
    private static final Set<SearchExpressionHint> RESOLVE_LABEL_FOR = EnumSet.of(SearchExpressionHint.RESOLVE_SINGLE_COMPONENT, SearchExpressionHint.IGNORE_NO_RESULT);

    private Components() {
    }

    public static <C extends UIComponent> C getCurrentComponent() {
        return (C)UIComponent.getCurrentComponent((FacesContext)Faces.getContext());
    }

    public static <T> T getAttribute(UIComponent component, String name) {
        return (T)component.getAttributes().get(name);
    }

    public static boolean isRendered(UIComponent component) {
        UIComponent current = component;
        while (current.getParent() != null) {
            if (!current.isRendered()) {
                return false;
            }
            current = current.getParent();
        }
        return true;
    }

    public static <C extends UIComponent> C findComponent(String clientId) {
        return (C)Faces.getViewRoot().findComponent(clientId);
    }

    public static <C extends UIComponent> C findComponentRelatively(UIComponent component, String clientId) {
        if (Utils.isEmpty(clientId)) {
            return null;
        }
        C result = Components.findComponentInParents(component, clientId);
        if (result == null) {
            result = Components.findComponentInChildren((UIComponent)Faces.getViewRoot(), clientId);
        }
        return result;
    }

    public static <C extends UIComponent> C findComponentInParents(UIComponent component, String clientId) {
        if (Utils.isEmpty(clientId)) {
            return null;
        }
        for (UIComponent parent = component; parent != null; parent = parent.getParent()) {
            UIComponent result;
            if (!(parent instanceof NamingContainer) && !(parent instanceof UIViewRoot) || (result = Components.findComponentIgnoringIAE(parent, clientId)) == null) continue;
            return (C)result;
        }
        return null;
    }

    public static <C extends UIComponent> C findComponentInChildren(UIComponent component, String clientId) {
        if (Utils.isEmpty(clientId)) {
            return null;
        }
        for (UIComponent child : component.getChildren()) {
            Object result = null;
            if (child instanceof NamingContainer) {
                result = Components.findComponentIgnoringIAE(child, clientId);
            }
            if (result == null) {
                result = Components.findComponentInChildren(child, clientId);
            }
            if (result == null) continue;
            return (C)result;
        }
        return null;
    }

    public static <C extends UIComponent> List<C> findComponentsInChildren(UIComponent component, Class<C> type) {
        ArrayList components = new ArrayList();
        Components.findComponentsInChildren(component, type, components);
        return components;
    }

    private static <C extends UIComponent> void findComponentsInChildren(UIComponent component, Class<C> type, List<C> matches) {
        for (UIComponent child : component.getChildren()) {
            if (type.isInstance(child)) {
                matches.add(child);
            }
            Components.findComponentsInChildren(child, type, matches);
        }
    }

    public static <C extends UIComponent> List<C> findComponentsInCurrentForm(Class<C> type) {
        UIForm currentForm = Components.getCurrentForm();
        return currentForm != null ? Components.findComponentsInChildren((UIComponent)currentForm, type) : Collections.emptyList();
    }

    public static <C extends UIComponent> C getClosestParent(UIComponent component, Class<C> parentType) {
        UIComponent parent;
        for (parent = component.getParent(); parent != null && !parentType.isInstance(parent); parent = parent.getParent()) {
        }
        return (C)((UIComponent)parentType.cast(parent));
    }

    public static <C extends UIComponent> Optional<C> findClosestParent(UIComponent component, Class<C> parentType) {
        return Optional.ofNullable(Components.getClosestParent(component, parentType));
    }

    public static ForEach forEachComponent() {
        return new ForEach();
    }

    public static ForEach forEachComponent(FacesContext facesContext) {
        return new ForEach(facesContext);
    }

    public static void includeFacelet(UIComponent parent, String path) throws IOException {
        Faces.getFaceletContext().includeFacelet(parent, path);
    }

    public static UIComponent includeCompositeComponent(UIComponent parent, String libraryName, String tagName, String id) {
        return Components.includeCompositeComponent(parent, libraryName, tagName, id, null);
    }

    public static UIComponent includeCompositeComponent(UIComponent parent, String libraryName, String tagName, String id, Map<String, String> attributes) {
        String taglibURI = "http://xmlns.jcp.org/jsf/composite/" + libraryName;
        HashMap<String, String> attrs = attributes == null ? null : new HashMap<String, String>(attributes);
        FacesContext context = FacesContext.getCurrentInstance();
        UIComponent composite = context.getApplication().getViewHandler().getViewDeclarationLanguage(context, context.getViewRoot().getViewId()).createComponent(context, taglibURI, tagName, attrs);
        composite.setId(id);
        parent.getChildren().add(composite);
        return composite;
    }

    @Deprecated
    public static UIComponent addScriptToBody(String script) {
        UIOutput outputScript = Components.createScriptResource();
        UIOutput content = new UIOutput();
        content.setValue((Object)script);
        outputScript.getChildren().add(content);
        return Components.addComponentResource((UIComponent)outputScript, "body");
    }

    @Deprecated
    public static UIComponent addScriptResourceToBody(String libraryName, String resourceName) {
        return Components.addScriptResourceToTarget(libraryName, resourceName, "body");
    }

    @Deprecated
    public static UIComponent addScriptResourceToHead(String libraryName, String resourceName) {
        return Components.addScriptResourceToTarget(libraryName, resourceName, "head");
    }

    private static UIOutput createScriptResource() {
        UIOutput outputScript = new UIOutput();
        outputScript.setRendererType("javax.faces.resource.Script");
        return outputScript;
    }

    private static UIComponent addScriptResourceToTarget(String libraryName, String resourceName, String target) {
        FacesContext context = FacesContext.getCurrentInstance();
        String id = (libraryName != null ? libraryName.replaceAll("\\W+", "_") + "_" : "") + resourceName.replaceAll("\\W+", "_");
        for (UIComponent existingResource : context.getViewRoot().getComponentResources(context)) {
            if (!id.equals(existingResource.getId())) continue;
            return existingResource;
        }
        UIOutput outputScript = Components.createScriptResource();
        outputScript.setId(id);
        if (libraryName != null) {
            outputScript.getAttributes().put("library", libraryName);
        }
        outputScript.getAttributes().put("name", resourceName);
        return Components.addComponentResource((UIComponent)outputScript, target);
    }

    private static UIComponent addComponentResource(UIComponent resource, String target) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (resource.getId() == null) {
            Hacks.setComponentResourceUniqueId(context, resource);
        }
        context.getViewRoot().addComponentResource(context, resource, target);
        return resource;
    }

    public static void addScript(String script) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (FacesLocal.isAjaxRequestWithPartialRendering(context)) {
            Ajax.oncomplete(script);
        } else if (context.getCurrentPhaseId() != PhaseId.RENDER_RESPONSE) {
            Events.subscribeToRequestBeforePhase(PhaseId.RENDER_RESPONSE, () -> Components.addScriptToBody(script));
        } else {
            Components.addScriptToBody(script);
        }
    }

    public static void addScriptResource(String libraryName, String resourceName) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (!context.getApplication().getResourceHandler().isResourceRendered(context, resourceName, libraryName)) {
            if (FacesLocal.isAjaxRequestWithPartialRendering(context)) {
                Ajax.load(libraryName, resourceName);
            } else if (context.getCurrentPhaseId() != PhaseId.RENDER_RESPONSE) {
                Components.addScriptResourceToHead(libraryName, resourceName);
                Events.subscribeToRequestBeforePhase(PhaseId.RENDER_RESPONSE, () -> Components.addScriptResourceToBody(libraryName, resourceName));
            } else if (Boolean.TRUE.equals(context.getAttributes().get("javax.faces.IS_BUILDING_INITIAL_STATE"))) {
                Components.addScriptResourceToHead(libraryName, resourceName);
            } else {
                Components.addScriptResourceToBody(libraryName, resourceName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UIViewRoot buildView(String viewId) throws IOException {
        FacesContext context = FacesContext.getCurrentInstance();
        String normalizedViewId = FacesLocal.normalizeViewId(context, viewId);
        ViewHandler viewHandler = context.getApplication().getViewHandler();
        UIViewRoot view = viewHandler.createView(context, normalizedViewId);
        TemporaryViewFacesContext temporaryContext = new TemporaryViewFacesContext(context, view);
        try {
            Faces.setContext((FacesContext)temporaryContext);
            viewHandler.getViewDeclarationLanguage((FacesContext)temporaryContext, normalizedViewId).buildView((FacesContext)temporaryContext, view);
        }
        finally {
            Faces.setContext(context);
        }
        return view;
    }

    public static String encodeHtml(UIComponent component) {
        FacesContext context = FacesContext.getCurrentInstance();
        ResponseWriter originalWriter = context.getResponseWriter();
        StringWriter output = new StringWriter();
        context.setResponseWriter(FacesLocal.getRenderKit(context).createResponseWriter((Writer)output, "text/html", "UTF-8"));
        try {
            component.encodeAll(context);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (originalWriter != null) {
                context.setResponseWriter(originalWriter);
            }
        }
        return output.toString();
    }

    public static UIForm getCurrentForm() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (!context.isPostback()) {
            return null;
        }
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot == null) {
            return null;
        }
        for (String name : context.getExternalContext().getRequestParameterMap().keySet()) {
            UIForm form;
            if (name.startsWith("javax.faces.")) continue;
            UIComponent component = Components.findComponentIgnoringIAE((UIComponent)viewRoot, name);
            if (component instanceof UIForm) {
                return (UIForm)component;
            }
            if (component == null || (form = Components.getClosestParent(component, UIForm.class)) == null) continue;
            return form;
        }
        return null;
    }

    public static UICommand getCurrentCommand() {
        Object source = Components.getCurrentActionSource();
        return source instanceof UICommand ? (UICommand)source : null;
    }

    public static <C extends UIComponent> C getCurrentActionSource() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (!context.isPostback()) {
            return null;
        }
        return (C)Components.getCurrentActionSource(context, (UIComponent)context.getViewRoot());
    }

    static UIComponent getCurrentActionSource(FacesContext context, UIComponent parent) {
        UIComponent actionSource;
        String sourceClientId;
        if (parent == null) {
            return null;
        }
        Map params = context.getExternalContext().getRequestParameterMap();
        if (context.getPartialViewContext().isAjaxRequest() && (sourceClientId = (String)params.get("javax.faces.source")) != null && (actionSource = Components.findComponentIgnoringIAE(parent, sourceClientId)) != null) {
            return actionSource;
        }
        for (String name : params.keySet()) {
            UIComponent actionSource2;
            if (name.startsWith("javax.faces.") || !((actionSource2 = Components.findComponentIgnoringIAE(parent, name)) instanceof UICommand)) continue;
            return actionSource2;
        }
        if (parent instanceof UIViewRoot) {
            return Components.getCurrentActionSource(context, (UIComponent)Components.getCurrentForm());
        }
        return null;
    }

    public static boolean isEditable(UIInput input) {
        return Components.isRendered((UIComponent)input) && !Boolean.TRUE.equals(input.getAttributes().get("disabled")) && !Boolean.TRUE.equals(input.getAttributes().get("readonly"));
    }

    public static String getLabel(UIComponent component) {
        String label = Components.getOptionalLabel(component);
        return label != null ? label : component.getClientId();
    }

    public static String getOptionalLabel(UIComponent component) {
        Object[] result = new Object[1];
        new ScopedRunner(Faces.getContext()).with("cc", UIComponent.getCompositeComponentParent((UIComponent)component)).invoke(() -> {
            ValueExpression labelExpression;
            Object label = component.getAttributes().get(LABEL_ATTRIBUTE);
            if (Utils.isEmpty(label) && (labelExpression = component.getValueExpression(LABEL_ATTRIBUTE)) != null) {
                label = labelExpression.getValue(Faces.getELContext());
            }
            result[0] = label;
        });
        return result[0] != null ? result[0].toString() : null;
    }

    public static void setLabel(UIComponent component, Object label) {
        if (label instanceof ValueExpression) {
            component.setValueExpression(LABEL_ATTRIBUTE, (ValueExpression)label);
        } else if (label != null) {
            component.getAttributes().put(LABEL_ATTRIBUTE, label);
        } else {
            component.getAttributes().remove(LABEL_ATTRIBUTE);
        }
    }

    public static <T> T getValue(EditableValueHolder component) {
        Object submittedValue = component.getSubmittedValue();
        return (T)(submittedValue != null ? submittedValue : component.getLocalValue());
    }

    public static <T> T getImmediateValue(UIInput input) {
        if (input.isValid() && input.getSubmittedValue() != null) {
            input.validate(Faces.getContext());
        }
        return (T)(input.isLocalValueSet() ? input.getValue() : null);
    }

    public static boolean hasSubmittedValue(EditableValueHolder component) {
        return !Utils.isEmpty(component.getSubmittedValue());
    }

    public static <T> Class<T> getExpectedValueType(UIComponent component) {
        ValueExpression valueExpression = component.getValueExpression(VALUE_ATTRIBUTE);
        if (valueExpression != null) {
            return Components.getExpectedType(valueExpression);
        }
        Object value = component.getAttributes().get(VALUE_ATTRIBUTE);
        if (value != null) {
            return value.getClass();
        }
        return null;
    }

    public static <T> Class<T> getExpectedType(ValueExpression valueExpression) {
        Class expectedType = valueExpression.getExpectedType();
        if (expectedType == Object.class) {
            expectedType = valueExpression.getType(Faces.getELContext());
        }
        return expectedType;
    }

    public static boolean hasInvokedSubmit(UIComponent component) {
        Object source = Components.getCurrentActionSource();
        return source != null && source.equals(component);
    }

    public static <T> List<ParamHolder<T>> getParams(UIComponent component) {
        if (component.getChildCount() == 0) {
            return Collections.emptyList();
        }
        ArrayList params = new ArrayList(component.getChildCount());
        for (UIComponent child : component.getChildren()) {
            UIParameter param;
            if (!(child instanceof UIParameter) || Utils.isEmpty((param = (UIParameter)child).getName()) || param.isDisable()) continue;
            params.add(new SimpleParam(param));
        }
        return Collections.unmodifiableList(params);
    }

    public static Map<String, List<String>> getParams(UIComponent component, boolean includeRequestParams, boolean includeViewParams) {
        FacesContext context = FacesContext.getCurrentInstance();
        Map<String, List<String>> params = includeRequestParams ? FacesLocal.getRequestQueryStringMap(context) : (includeViewParams ? FacesLocal.getViewParameterMap(context) : new LinkedHashMap<String, List<String>>(0));
        for (ParamHolder param : Components.getParams(component)) {
            String value = param.getValue();
            if (Utils.isEmpty(value)) continue;
            params.put(param.getName(), Arrays.asList(value));
        }
        return Collections.unmodifiableMap(params);
    }

    public static UIMessage getMessageComponent(UIInput input) {
        UIMessage[] found = new UIMessage[1];
        Components.forEachComponent().ofTypes(UIMessage.class).withHints(VisitHint.SKIP_ITERATION).invoke((context, target) -> {
            UIMessage messageComponent = (UIMessage)target;
            String forValue = messageComponent.getFor();
            if (!Utils.isEmpty(forValue)) {
                FacesContext facesContext = context.getFacesContext();
                SearchExpressionContext searchExpressionContext = SearchExpressionContext.createSearchExpressionContext((FacesContext)facesContext, (UIComponent)messageComponent, RESOLVE_LABEL_FOR, null);
                String forClientId = facesContext.getApplication().getSearchExpressionHandler().resolveClientId(searchExpressionContext, forValue);
                Object forComponent = Components.findComponentRelatively((UIComponent)messageComponent, forClientId);
                if (input.equals(forComponent)) {
                    found[0] = messageComponent;
                    return VisitResult.COMPLETE;
                }
            }
            return VisitResult.ACCEPT;
        });
        return found[0];
    }

    public static UIMessages getMessagesComponent() {
        UIMessages[] found = new UIMessages[1];
        Components.forEachComponent().ofTypes(UIMessages.class).withHints(VisitHint.SKIP_ITERATION).invoke((context, target) -> {
            found[0] = (UIMessages)target;
            return VisitResult.COMPLETE;
        });
        return found[0];
    }

    public static void resetForm(UIComponent component) {
        UIForm form;
        UIForm uIForm = form = component instanceof UIForm ? (UIForm)component : Components.getClosestParent(component, UIForm.class);
        if (form == null) {
            throw new IllegalArgumentException(String.format(ERROR_MISSING_PARENT, component.getClass(), UIForm.class));
        }
        Components.resetInputs((UIComponent)form);
    }

    public static void resetInputs(UIComponent component) {
        Components.forEachComponent().fromRoot(component).ofTypes(UIInput.class).invoke(UIInput::resetValue);
    }

    public static void addFormIfNecessary() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (FacesLocal.isAjaxRequestWithPartialRendering(context)) {
            return;
        }
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot == null || viewRoot.getChildCount() == 0) {
            return;
        }
        VisitCallback visitCallback = (visitContext, target) -> target instanceof UIForm ? VisitResult.COMPLETE : VisitResult.ACCEPT;
        boolean formFound = viewRoot.visitTree(VisitContext.createVisitContext((FacesContext)context, null, EnumSet.of(VisitHint.SKIP_ITERATION)), visitCallback);
        if (formFound) {
            return;
        }
        Optional<UIComponent> body = viewRoot.getChildren().stream().filter(HtmlBody.class::isInstance).findFirst();
        if (!body.isPresent()) {
            return;
        }
        Form form = new Form();
        form.setId("omnifaces_form");
        form.getAttributes().put("style", "display:none");
        body.get().getChildren().add(form);
    }

    public static ValueExpression createValueExpression(String expression, Class<?> type) {
        FacesContext context = FacesContext.getCurrentInstance();
        return context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), expression, type);
    }

    public static MethodExpression createMethodExpression(String expression, Class<?> returnType, Class<?> ... parameterTypes) {
        FacesContext context = FacesContext.getCurrentInstance();
        return context.getApplication().getExpressionFactory().createMethodExpression(context.getELContext(), expression, returnType, (Class[])parameterTypes);
    }

    public static MethodExpression createVoidMethodExpression(String expression, Class<?> ... parameterTypes) {
        return Components.createMethodExpression(expression, Void.class, parameterTypes);
    }

    public static MethodExpressionActionListener createActionListenerMethodExpression(String expression) {
        return new MethodExpressionActionListener(Components.createVoidMethodExpression(expression, ActionEvent.class));
    }

    public static AjaxBehavior createAjaxBehavior(String expression) {
        FacesContext context = FacesContext.getCurrentInstance();
        AjaxBehavior behavior = (AjaxBehavior)context.getApplication().createBehavior("javax.faces.behavior.Ajax");
        MethodExpression method = Components.createVoidMethodExpression(expression, AjaxBehaviorEvent.class);
        behavior.addAjaxBehaviorListener(event -> method.invoke(Faces.getELContext(), new Object[]{event}));
        return behavior;
    }

    public static List<String> getActionExpressionsAndListeners(UIComponent component) {
        String behaviorEvent;
        ArrayList<String> actions = new ArrayList<String>();
        if (component instanceof ActionSource2) {
            ActionSource2 source = (ActionSource2)component;
            Components.addExpressionStringIfNotNull(source.getActionExpression(), actions);
            for (ActionListener listener : source.getActionListeners()) {
                Components.addExpressionStringIfNotNull(Components.getField(listener.getClass(), MethodExpression.class, listener), actions);
            }
        }
        if (component instanceof ClientBehaviorHolder && (behaviorEvent = Faces.getRequestParameter("javax.faces.behavior.event")) != null) {
            for (BehaviorListener listener : Components.getBehaviorListeners((ClientBehaviorHolder)component, behaviorEvent)) {
                Components.addExpressionStringIfNotNull(Components.getField(listener.getClass(), MethodExpression.class, listener), actions);
            }
        }
        return Collections.unmodifiableList(actions);
    }

    public static <C extends UIComponent> void validateHasParent(UIComponent component, Class<C> parentType) {
        if (!Faces.isDevelopment()) {
            return;
        }
        if (Components.getClosestParent(component, parentType) == null) {
            throw new IllegalStateException(String.format(ERROR_MISSING_PARENT, component.getClass().getSimpleName(), parentType));
        }
    }

    public static <C extends UIComponent> void validateHasDirectParent(UIComponent component, Class<C> parentType) {
        if (!Faces.isDevelopment()) {
            return;
        }
        if (!parentType.isInstance(component.getParent())) {
            throw new IllegalStateException(String.format(ERROR_MISSING_DIRECT_PARENT, component.getClass().getSimpleName(), parentType));
        }
    }

    public static <C extends UIComponent> void validateHasNoParent(UIComponent component, Class<C> parentType) {
        if (!Faces.isDevelopment()) {
            return;
        }
        if (Components.getClosestParent(component, parentType) != null) {
            throw new IllegalStateException(String.format(ERROR_ILLEGAL_PARENT, component.getClass().getSimpleName(), parentType));
        }
    }

    public static <C extends UIComponent> void validateHasChild(UIComponent component, Class<C> childType) {
        if (!Faces.isDevelopment()) {
            return;
        }
        if (Components.findComponentsInChildren(component, childType).isEmpty()) {
            throw new IllegalStateException(String.format(ERROR_MISSING_CHILD, component.getClass().getSimpleName(), childType));
        }
    }

    public static <C extends UIComponent> void validateHasOnlyChildren(UIComponent component, Class<C> childType) {
        if (!Faces.isDevelopment() || component.getChildCount() == 0) {
            return;
        }
        StringBuilder childClassNames = new StringBuilder();
        for (UIComponent child : component.getChildren()) {
            if (childType.isAssignableFrom(child.getClass())) continue;
            if (childClassNames.length() > 0) {
                childClassNames.append(", ");
            }
            childClassNames.append(child.getClass().getName());
        }
        if (childClassNames.length() > 0) {
            throw new IllegalStateException(String.format(ERROR_ILLEGAL_CHILDREN, component.getClass().getSimpleName(), childType, childClassNames));
        }
    }

    public static void validateHasNoChildren(UIComponent component) {
        if (!Faces.isDevelopment()) {
            return;
        }
        if (component.getChildCount() > 0) {
            StringBuilder childClassNames = new StringBuilder();
            for (UIComponent child : component.getChildren()) {
                if (childClassNames.length() > 0) {
                    childClassNames.append(", ");
                }
                childClassNames.append(child.getClass().getName());
            }
            throw new IllegalStateException(String.format(ERROR_CHILDREN_DISALLOWED, component.getClass().getSimpleName(), childClassNames));
        }
    }

    private static String stripIterationIndexFromClientId(String clientId) {
        String separatorChar = Character.toString(UINamingContainer.getSeparatorChar((FacesContext)Faces.getContext()));
        return clientId.replaceAll(Pattern.quote(separatorChar) + "[0-9]+" + Pattern.quote(separatorChar), separatorChar);
    }

    private static UIComponent findComponentIgnoringIAE(UIComponent parent, String clientId) {
        try {
            return parent.findComponent(Components.stripIterationIndexFromClientId(clientId));
        }
        catch (IllegalArgumentException ignore) {
            logger.log(Level.FINEST, "Ignoring thrown exception; this may occur when view has changed by for example a successful navigation.", ignore);
            return null;
        }
    }

    private static void addExpressionStringIfNotNull(MethodExpression expression, List<String> list) {
        if (expression != null) {
            list.add(expression.getExpressionString());
        }
    }

    private static List<BehaviorListener> getBehaviorListeners(ClientBehaviorHolder component, String behaviorEvent) {
        List behaviors = (List)component.getClientBehaviors().get(behaviorEvent);
        if (behaviors == null) {
            return Collections.emptyList();
        }
        ArrayList<BehaviorListener> allListeners = new ArrayList<BehaviorListener>();
        for (ClientBehavior behavior : behaviors) {
            List listeners = Components.getField(BehaviorBase.class, List.class, behavior);
            if (listeners == null) continue;
            allListeners.addAll(listeners);
        }
        return allListeners;
    }

    private static <C, F> F getField(Class<? extends C> classType, Class<F> fieldType, C instance) {
        for (Class<C> type = classType; type != Object.class; type = type.getSuperclass()) {
            for (Field field : type.getDeclaredFields()) {
                if (!fieldType.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                try {
                    return (F)field.get(instance);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        return null;
    }

    private static class TemporaryViewFacesContext
    extends FacesContextWrapper {
        private UIViewRoot temporaryView;

        public TemporaryViewFacesContext(FacesContext wrapped, UIViewRoot temporaryView) {
            super(wrapped);
            this.temporaryView = temporaryView;
        }

        public UIViewRoot getViewRoot() {
            return this.temporaryView;
        }

        public RenderKit getRenderKit() {
            return FacesLocal.getRenderKit((FacesContext)this);
        }
    }

    public static class ForEach {
        private FacesContext facesContext;
        private UIComponent root;
        private Collection<String> ids;
        private Set<VisitHint> hints;
        private Class<?>[] types;

        public ForEach() {
            this.facesContext = Faces.getContext();
        }

        public ForEach(FacesContext facesContext) {
            this.facesContext = facesContext;
        }

        public ForEach fromRoot(UIComponent root) {
            this.root = root;
            return this;
        }

        public ForEach havingIds(Collection<String> ids) {
            this.ids = ids;
            return this;
        }

        public ForEach havingIds(String ... ids) {
            this.ids = Arrays.asList(ids);
            return this;
        }

        public ForEach withHints(Set<VisitHint> hints) {
            this.hints = hints;
            return this;
        }

        public ForEach withHints(VisitHint ... hints) {
            if (hints.length > 0) {
                EnumSet<VisitHint> hintsSet = EnumSet.noneOf(hints[0].getDeclaringClass());
                Collections.addAll(hintsSet, hints);
                this.hints = hintsSet;
            }
            return this;
        }

        @SafeVarargs
        public final ForEach ofTypes(Class<?> ... types) {
            this.types = types;
            return this;
        }

        public <C extends UIComponent> void invoke(Callback.WithArgument<C> operation) {
            this.invoke((context, target) -> {
                operation.invoke(target);
                return VisitResult.ACCEPT;
            });
        }

        public void invoke(VisitCallback operation) {
            VisitCallback visitCallback;
            VisitContext visitContext = VisitContext.createVisitContext((FacesContext)this.getFacesContext(), this.getIds(), this.getHints());
            Object object = visitCallback = this.types == null ? operation : new TypesVisitCallback(this.types, operation);
            if (this.getFacesContext().getViewRoot().equals(this.getRoot())) {
                this.getRoot().visitTree(visitContext, visitCallback);
            } else {
                Components.forEachComponent().havingIds(this.getRoot().getClientId()).invoke((C viewRoot) -> viewRoot.visitTree(visitContext, visitCallback));
            }
        }

        protected FacesContext getFacesContext() {
            return this.facesContext;
        }

        protected UIComponent getRoot() {
            return this.root != null ? this.root : this.getFacesContext().getViewRoot();
        }

        protected Collection<String> getIds() {
            return this.ids;
        }

        protected Set<VisitHint> getHints() {
            return this.hints;
        }

        private static class TypesVisitCallback
        implements VisitCallback {
            private Class<?>[] types;
            private VisitCallback next;

            public TypesVisitCallback(Class<?>[] types, VisitCallback next) {
                this.types = types;
                this.next = next;
            }

            public VisitResult visit(VisitContext context, UIComponent target) {
                if (Utils.isOneInstanceOf(target.getClass(), this.types)) {
                    return this.next.visit(context, target);
                }
                return VisitResult.ACCEPT;
            }
        }
    }
}

