/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.omnifaces.util.Utils;

public final class Json {
    private static final String ERROR_INVALID_BEAN = "Cannot introspect object of type '%s' as bean.";
    private static final String ERROR_INVALID_GETTER = "Cannot invoke getter of property '%s' of bean '%s'.";

    private Json() {
    }

    public static String encode(Object object) {
        return Json.encode(object, null);
    }

    public static String encode(Object object, UnaryOperator<String> propertyNameFormatter) {
        StringBuilder builder = new StringBuilder();
        Json.encode(object, builder, propertyNameFormatter);
        return builder.toString();
    }

    private static void encode(Object object, StringBuilder builder, UnaryOperator<String> propertyNameFormatter) {
        if (object == null) {
            builder.append("null");
        } else if (object instanceof Boolean || object instanceof Number) {
            builder.append(object.toString());
        } else if (object instanceof CharSequence || object instanceof Enum) {
            Json.encodeString(object.toString(), builder);
        } else if (object instanceof Date) {
            builder.append('\"').append(Utils.formatRFC1123((Date)object)).append('\"');
        } else if (object instanceof Temporal) {
            builder.append('\"').append(Utils.toZonedDateTime(object).format(DateTimeFormatter.RFC_1123_DATE_TIME)).append('\"');
        } else if (object instanceof Collection) {
            Json.encodeCollection((Collection)object, builder, propertyNameFormatter);
        } else if (object.getClass().isArray()) {
            Json.encodeArray(object, builder, propertyNameFormatter);
        } else if (object instanceof Map) {
            Json.encodeMap((Map)object, builder, propertyNameFormatter);
        } else if (object instanceof Class) {
            Json.encodeString(((Class)object).getName(), builder);
        } else {
            Json.encodeBean(object, builder, propertyNameFormatter);
        }
    }

    private static void encodeString(String string, StringBuilder builder) {
        builder.append('\"').append(Utils.escapeJS(string, false)).append('\"');
    }

    private static void encodeCollection(Collection<?> collection, StringBuilder builder, UnaryOperator<String> propertyNameFormatter) {
        builder.append('[');
        int i = 0;
        for (Object element : collection) {
            if (i++ > 0) {
                builder.append(',');
            }
            Json.encode(element, builder, propertyNameFormatter);
        }
        builder.append(']');
    }

    private static void encodeArray(Object array, StringBuilder builder, UnaryOperator<String> propertyNameFormatter) {
        builder.append('[');
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                builder.append(',');
            }
            Json.encode(Array.get(array, i), builder, propertyNameFormatter);
        }
        builder.append(']');
    }

    private static void encodeMap(Map<?, ?> map, StringBuilder builder, UnaryOperator<String> propertyNameFormatter) {
        builder.append('{');
        int i = 0;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (i++ > 0) {
                builder.append(',');
            }
            Json.encodePropertyName(String.valueOf(entry.getKey()), builder, propertyNameFormatter);
            builder.append(':');
            Json.encode(entry.getValue(), builder, propertyNameFormatter);
        }
        builder.append('}');
    }

    private static void encodeBean(Object bean, StringBuilder builder, UnaryOperator<String> propertyNameFormatter) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(bean.getClass());
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_BEAN, bean.getClass()), e);
        }
        builder.append('{');
        int i = 0;
        for (PropertyDescriptor property : beanInfo.getPropertyDescriptors()) {
            Object value;
            if (property.getReadMethod() == null || "class".equals(property.getName())) continue;
            try {
                value = property.getReadMethod().invoke(bean, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format(ERROR_INVALID_GETTER, property.getName(), bean.getClass()), e);
            }
            if (value == null) continue;
            if (i++ > 0) {
                builder.append(',');
            }
            Json.encodePropertyName(property.getName(), builder, propertyNameFormatter);
            builder.append(':');
            Json.encode(value, builder, propertyNameFormatter);
        }
        builder.append('}');
    }

    private static void encodePropertyName(String string, StringBuilder builder, UnaryOperator<String> propertyNameFormatter) {
        Json.encodeString(propertyNameFormatter == null ? string : (String)propertyNameFormatter.apply(string), builder);
    }
}

