/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.enterprise.inject.Typed;
import org.omnifaces.util.Beans;
import org.omnifaces.util.Utils;

@Typed
public final class Reflection {
    private static final Logger logger = Logger.getLogger(Reflection.class.getName());
    private static final String ERROR_LOAD_CLASS = "Cannot load class '%s'.";
    private static final String ERROR_CREATE_INSTANCE = "Cannot create instance of class '%s'.";
    private static final String ERROR_ACCESS_FIELD = "Cannot access field '%s' of class '%s'.";
    private static final String ERROR_MODIFY_FIELD = "Cannot modify field '%s' of class '%s' with value %s.";
    private static final String ERROR_INVOKE_METHOD = "Cannot invoke method '%s' of class '%s' with arguments %s.";

    private Reflection() {
    }

    public static void setProperties(Object bean, Map<String, Object> propertiesToSet) {
        Map<String, PropertyDescriptor> availableProperties = Reflection.getPropertyDescriptors(bean.getClass());
        for (Map.Entry<String, Object> propertyToSet : propertiesToSet.entrySet()) {
            Reflection.setBeanProperty(bean, propertyToSet.getValue(), availableProperties.get(propertyToSet.getKey()));
        }
    }

    public static void setPropertiesWithCoercion(Object bean, Map<String, Object> propertiesToSet) {
        for (PropertyDescriptor property : Reflection.getPropertyDescriptors(bean.getClass()).values()) {
            Method setter = property.getWriteMethod();
            if (setter == null || !propertiesToSet.containsKey(property.getName())) continue;
            Object value = propertiesToSet.get(property.getName());
            if (value instanceof String && !property.getPropertyType().equals(String.class)) {
                try {
                    PropertyEditor editor = PropertyEditorManager.findEditor(property.getPropertyType());
                    editor.setAsText((String)value);
                    value = editor.getValue();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            Reflection.setBeanProperty(bean, value, property);
        }
    }

    public static void setBeanProperties(Object bean, Map<PropertyPath, Object> properties) {
        HashMap cachedDescriptors = new HashMap();
        TreeMap sortedProperties = new TreeMap(Comparator.reverseOrder());
        sortedProperties.putAll(properties);
        for (Map.Entry entry : sortedProperties.entrySet()) {
            PropertyPath path = (PropertyPath)entry.getKey();
            if (path.nodes.isEmpty()) continue;
            Object base = Reflection.getBase(bean, path, cachedDescriptors);
            Reflection.setProperty(base, (Comparable)path.nodes.get(path.nodes.size() - 1), entry.getValue(), cachedDescriptors);
        }
    }

    private static Object getBase(Object bean, PropertyPath path, Map<Class<?>, Map<String, PropertyDescriptor>> cachedDescriptors) {
        Object base = bean;
        for (int index = 0; index < path.nodes.size() - 1; ++index) {
            Comparable node = (Comparable)path.nodes.get(index);
            base = base instanceof List ? ((List)base).get((Integer)node) : (base instanceof Map ? ((Map)base).get(node) : (base.getClass().isArray() ? Array.get(base, (Integer)node) : Reflection.getBeanProperty(base, (String)((Object)node), cachedDescriptors, (Comparable)path.nodes.get(index + 1))));
        }
        return base;
    }

    private static void setProperty(Object base, Comparable<?> property, Object value, Map<Class<?>, Map<String, PropertyDescriptor>> cachedDescriptors) {
        if (base == null) {
            return;
        }
        if (base instanceof List) {
            ((List)base).set((Integer)property, value);
        } else if (base instanceof Map) {
            ((Map)base).put(property, value);
        } else if (base.getClass().isArray()) {
            Array.set(base, (Integer)property, value);
        } else {
            Reflection.setBeanProperty(base, value, Reflection.getPropertyDescriptor(base.getClass(), (String)((Object)property), cachedDescriptors));
        }
    }

    private static void setBeanProperty(Object bean, Object value, PropertyDescriptor propertyDescriptor) {
        try {
            propertyDescriptor.getWriteMethod().invoke(bean, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Object getBeanProperty(Object bean, String property) {
        return Reflection.getBeanProperty(bean, property, new HashMap(), null);
    }

    private static Object getBeanProperty(Object bean, PropertyDescriptor propertyDescriptor) {
        try {
            return propertyDescriptor.getReadMethod().invoke(bean, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Object getBeanProperty(Object bean, String property, Map<Class<?>, Map<String, PropertyDescriptor>> cachedDescriptors, Comparable<?> nextPropertyNode) {
        PropertyDescriptor propertyDescriptor = Reflection.getPropertyDescriptor(bean.getClass(), property, cachedDescriptors);
        Object value = Reflection.getBeanProperty(bean, propertyDescriptor);
        if (Utils.isEmpty(value) && nextPropertyNode != null) {
            value = Reflection.setBeanPropertyWithDefaultValue(bean, propertyDescriptor, nextPropertyNode);
        }
        return value;
    }

    private static Object setBeanPropertyWithDefaultValue(Object bean, PropertyDescriptor propertyDescriptor, Comparable<?> nextPropertyNode) {
        Object value;
        Class<?> type = propertyDescriptor.getPropertyType();
        if (List.class.isAssignableFrom(type)) {
            value = new ArrayList();
            Class elementType = (Class)((ParameterizedType)propertyDescriptor.getReadMethod().getGenericReturnType()).getActualTypeArguments()[0];
            Integer size = (Integer)nextPropertyNode + 1;
            for (int index = 0; index < size; ++index) {
                ((List)value).add(Reflection.createDefaultValueIfNecessary(elementType));
            }
        } else if (Map.class.isAssignableFrom(type)) {
            value = new LinkedHashMap();
        } else if (type.isArray()) {
            Integer length = (Integer)nextPropertyNode + 1;
            value = Array.newInstance(type.getComponentType(), (int)length);
            for (int index = 0; index < length; ++index) {
                Array.set(value, index, Reflection.createDefaultValueIfNecessary(type.getComponentType()));
            }
        } else {
            value = Reflection.instance(type);
        }
        if (propertyDescriptor.getWriteMethod() != null) {
            Reflection.setBeanProperty(bean, value, propertyDescriptor);
        } else {
            Reflection.modifyField(bean, propertyDescriptor.getName(), value);
        }
        return value;
    }

    private static Object createDefaultValueIfNecessary(Class<?> type) {
        return Reflection.isNeedsFurtherRecursion(type) ? Reflection.instance(type) : null;
    }

    private static Map<String, PropertyDescriptor> getPropertyDescriptors(Class<?> type, Map<Class<?>, Map<String, PropertyDescriptor>> cachedDescriptors) {
        return cachedDescriptors.computeIfAbsent(type, Reflection::getPropertyDescriptors);
    }

    private static Map<String, PropertyDescriptor> getPropertyDescriptors(Class<?> type) {
        try {
            return Arrays.stream(Introspector.getBeanInfo(type).getPropertyDescriptors()).filter(propertyDescriptor -> propertyDescriptor.getReadMethod() != null).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e);
        }
    }

    private static PropertyDescriptor getPropertyDescriptor(Class<?> type, String property, Map<Class<?>, Map<String, PropertyDescriptor>> cachedDescriptors) {
        return Reflection.getPropertyDescriptors(type, cachedDescriptors).get(property);
    }

    public static Map<Object, PropertyPath> getBaseBeanPropertyPaths(Object bean) {
        return Reflection.getBaseBeanPropertyPaths(bean, recursableGetter -> true);
    }

    public static Map<Object, PropertyPath> getBaseBeanPropertyPaths(Object bean, Predicate<Method> recursableGetter) {
        HashMap cachedDescriptors = new HashMap();
        IdentityHashMap<Object, PropertyPath> collectedBasePropertyPaths = new IdentityHashMap<Object, PropertyPath>();
        PropertyPath basePath = PropertyPath.of(new Comparable[0]);
        collectedBasePropertyPaths.put(bean, basePath);
        Reflection.collectBasePropertyPaths(bean, basePath, recursableGetter, cachedDescriptors, collectedBasePropertyPaths);
        return collectedBasePropertyPaths;
    }

    private static void collectBasePropertyPaths(Object base, PropertyPath basePath, Predicate<Method> recursableGetter, Map<Class<?>, Map<String, PropertyDescriptor>> cachedDescriptors, Map<Object, PropertyPath> collectedBasePropertyPaths) {
        if (base == null) {
            return;
        }
        if (base instanceof List) {
            Reflection.collectBasePropertyPathsFromList((List)base, basePath, recursableGetter, cachedDescriptors, collectedBasePropertyPaths);
        } else if (base instanceof Map) {
            Reflection.collectBasePropertyPathsFromMap((Map)base, basePath, recursableGetter, cachedDescriptors, collectedBasePropertyPaths);
        } else if (base.getClass().isArray()) {
            Reflection.collectBasePropertyPathsFromArray((Object[])base, basePath, recursableGetter, cachedDescriptors, collectedBasePropertyPaths);
        } else {
            Reflection.collectBasePropertyPathsFromBean(Beans.unwrapIfNecessary(base), basePath, recursableGetter, cachedDescriptors, collectedBasePropertyPaths);
        }
    }

    private static void collectBasePropertyPathsFromList(List<?> list, PropertyPath basePath, Predicate<Method> recursableGetter, Map<Class<?>, Map<String, PropertyDescriptor>> cachedDescriptors, Map<Object, PropertyPath> collectedBasePropertyPaths) {
        for (int index = 0; index < list.size(); ++index) {
            Reflection.collectBasePropertyPath(list.get(index), recursableGetter, basePath, cachedDescriptors, collectedBasePropertyPaths, (Comparable<? extends Serializable>)index);
        }
    }

    private static void collectBasePropertyPathsFromMap(Map<?, ?> map, PropertyPath basePath, Predicate<Method> recursableGetter, Map<Class<?>, Map<String, PropertyDescriptor>> cachedDescriptors, Map<Object, PropertyPath> collectedBasePropertyPaths) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            if (!(key instanceof Comparable) || !(key instanceof Serializable)) continue;
            Reflection.collectBasePropertyPath(entry.getValue(), recursableGetter, basePath, cachedDescriptors, collectedBasePropertyPaths, (Comparable)key);
        }
    }

    private static void collectBasePropertyPathsFromArray(Object[] array, PropertyPath basePath, Predicate<Method> recursableGetter, Map<Class<?>, Map<String, PropertyDescriptor>> cachedDescriptors, Map<Object, PropertyPath> collectedBasePropertyPaths) {
        for (int index = 0; index < array.length; ++index) {
            Reflection.collectBasePropertyPath(array[index], recursableGetter, basePath, cachedDescriptors, collectedBasePropertyPaths, (Comparable<? extends Serializable>)index);
        }
    }

    private static void collectBasePropertyPathsFromBean(Object bean, PropertyPath basePath, Predicate<Method> recursableGetter, Map<Class<?>, Map<String, PropertyDescriptor>> cachedDescriptors, Map<Object, PropertyPath> collectedBasePropertyPaths) {
        for (PropertyDescriptor propertyDescriptor : Reflection.getPropertyDescriptors(bean.getClass(), cachedDescriptors).values()) {
            if (!recursableGetter.test(propertyDescriptor.getReadMethod())) continue;
            Reflection.collectBasePropertyPath(Reflection.getBeanProperty(bean, propertyDescriptor), recursableGetter, basePath, cachedDescriptors, collectedBasePropertyPaths, (Comparable<? extends Serializable>)((Object)propertyDescriptor.getName()));
        }
    }

    private static void collectBasePropertyPath(Object value, Predicate<Method> recursableGetter, PropertyPath basePath, Map<Class<?>, Map<String, PropertyDescriptor>> cachedDescriptors, Map<Object, PropertyPath> collectedBasePropertyPaths, Comparable<? extends Serializable> property) {
        if (value != null && Reflection.isNeedsFurtherRecursion(value.getClass()) && !collectedBasePropertyPaths.containsKey(value)) {
            PropertyPath path = basePath.with(property);
            collectedBasePropertyPaths.put(value, path);
            Reflection.collectBasePropertyPaths(value, path, recursableGetter, cachedDescriptors, collectedBasePropertyPaths);
        }
    }

    private static boolean isNeedsFurtherRecursion(Class<?> type) {
        if (type.isPrimitive()) {
            return false;
        }
        if (Utils.isOneInstanceOf(type, Type.class, Boolean.class, Number.class, CharSequence.class, Enum.class, Calendar.class, Date.class, Temporal.class)) {
            return false;
        }
        return !Iterable.class.isAssignableFrom(type) || Utils.isOneInstanceOf(type, List.class, Map.class);
    }

    public static Method findMethod(Object base, String methodName, Object ... params) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class<?> cls = base.getClass(); cls != null; cls = cls.getSuperclass()) {
            Reflection.collectMethods(methods, cls, false, methodName, params);
            for (Class<?> iface : cls.getInterfaces()) {
                Reflection.collectInterfaceMethods(methods, iface, methodName, params);
            }
        }
        if (methods.size() == 1) {
            return (Method)methods.get(0);
        }
        return Reflection.closestMatchingMethod(methods, params);
    }

    private static void collectInterfaceMethods(List<Method> methods, Class<?> iface, String methodName, Object ... params) {
        Reflection.collectMethods(methods, iface, true, methodName, params);
        for (Class<?> superiface : iface.getInterfaces()) {
            Reflection.collectInterfaceMethods(methods, superiface, methodName, params);
        }
    }

    private static void collectMethods(List<Method> methods, Class<?> type, boolean iface, String methodName, Object ... params) {
        for (Method method : type.getDeclaredMethods()) {
            if (iface && !method.isDefault() || !method.getName().equals(methodName) || method.getParameterTypes().length != params.length || !Reflection.isNotOverridden(methods, method)) continue;
            methods.add(method);
        }
    }

    private static boolean isNotOverridden(List<Method> methodsWithSameName, Method method) {
        for (Method methodWithSameName : methodsWithSameName) {
            if (!Arrays.equals(methodWithSameName.getParameterTypes(), method.getParameterTypes())) continue;
            return false;
        }
        return true;
    }

    private static Method closestMatchingMethod(List<Method> methods, Object ... params) {
        for (Method method : methods) {
            Class<?>[] candidateParamTypes = method.getParameterTypes();
            boolean match = true;
            for (int i = 0; i < params.length; ++i) {
                if (Reflection.isAssignable(params[i], candidateParamTypes[i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return method;
        }
        return null;
    }

    public static <A extends Annotation> List<Method> findMethods(Object base, Class<A> annotation) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class<?> cls = base.getClass(); cls != null; cls = cls.getSuperclass()) {
            for (Method method : cls.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(annotation) || !Reflection.isNotOverridden(methods, method)) continue;
                methods.add(method);
            }
        }
        return methods;
    }

    public static boolean isAssignable(Object source, Class<?> targetType) {
        Class<?> sourceType;
        Class<Object> clazz = source instanceof Class ? (Class<?>)source : (sourceType = source != null ? source.getClass() : null);
        if (sourceType != null && targetType.isPrimitive()) {
            sourceType = Utils.getPrimitiveType(sourceType);
        }
        return sourceType == null ? !targetType.isPrimitive() : targetType.isAssignableFrom(sourceType);
    }

    public static <T> Class<T> toClass(String className) {
        try {
            return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            try {
                return Class.forName(className);
            }
            catch (Exception ignore) {
                logger.log(Level.FINEST, "Ignoring thrown exception; previous exception will be rethrown instead.", ignore);
                throw new IllegalStateException(String.format(ERROR_LOAD_CLASS, className), e);
            }
        }
    }

    public static <T> Class<T> toClassOrNull(String className) {
        try {
            return Reflection.toClass(className);
        }
        catch (Exception ignore) {
            logger.log(Level.FINEST, "Ignoring thrown exception; the sole intent is to return null instead.", ignore);
            return null;
        }
    }

    public static <T> Constructor<T> findConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        try {
            return clazz.getConstructor(parameterTypes);
        }
        catch (Exception ignore) {
            logger.log(Level.FINEST, "Ignoring thrown exception; the sole intent is to return null instead.", ignore);
            return null;
        }
    }

    public static <T> T instance(String className) {
        return Reflection.instance(Reflection.toClass(className));
    }

    public static <T> T instance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format(ERROR_CREATE_INSTANCE, clazz), e);
        }
    }

    public static <T> T accessField(Object instance, String fieldName) {
        try {
            Field field = instance.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(instance);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format(ERROR_ACCESS_FIELD, fieldName, instance.getClass()), e);
        }
    }

    public static <T> T modifyField(Object instance, String fieldName, T value) {
        try {
            return Reflection.modifyField(instance, instance.getClass().getDeclaredField(fieldName), value);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format(ERROR_MODIFY_FIELD, fieldName, instance != null ? instance.getClass() : null, value), e);
        }
    }

    public static <T> T modifyField(Object instance, Field field, T value) {
        try {
            field.setAccessible(true);
            Object oldValue = field.get(instance);
            field.set(instance, value);
            return (T)oldValue;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format(ERROR_MODIFY_FIELD, field != null ? field.getName() : null, instance != null ? instance.getClass() : null, value), e);
        }
    }

    public static <T> T invokeMethod(Object instance, String methodName, Object ... parameters) {
        try {
            Method method = Reflection.findMethod(instance, methodName, parameters);
            if (method == null) {
                throw new NoSuchMethodException();
            }
            return Reflection.invokeMethod(instance, method, parameters);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format(ERROR_INVOKE_METHOD, methodName, instance != null ? instance.getClass() : null, Arrays.toString(parameters)), e);
        }
    }

    public static <T> T invokeMethod(Object instance, Method method, Object ... parameters) {
        try {
            method.setAccessible(true);
            return (T)method.invoke(instance, parameters);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format(ERROR_INVOKE_METHOD, method != null ? method.getName() : null, instance != null ? instance.getClass() : null, Arrays.toString(parameters)), e);
        }
    }

    public static <A extends Annotation> void invokeMethods(Object instance, Class<A> annotation) {
        for (Method method : Reflection.findMethods(instance, annotation)) {
            try {
                Reflection.invokeMethod(instance, method, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format(ERROR_INVOKE_METHOD, method.getName(), instance.getClass(), "[]"), e);
            }
        }
    }

    public static final class PropertyPath
    implements Comparable<PropertyPath>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final List<Comparable<? extends Serializable>> nodes;

        private PropertyPath(List<Comparable<? extends Serializable>> nodes) {
            this.nodes = nodes;
        }

        @SafeVarargs
        public static PropertyPath of(Comparable<? extends Serializable> ... nodes) {
            for (Comparable<? extends Serializable> node : nodes) {
                Objects.requireNonNull(node, "node");
                if (node instanceof Serializable) continue;
                throw new IllegalArgumentException("Node " + node + " (" + node.getClass() + ") must be an instance of Serializable.");
            }
            return new PropertyPath(Arrays.asList(nodes));
        }

        public PropertyPath with(Comparable<? extends Serializable> node) {
            Objects.requireNonNull(node, "node");
            ArrayList<Comparable<? extends Serializable>> newNodes = new ArrayList<Comparable<? extends Serializable>>(this.nodes);
            newNodes.add(node);
            return new PropertyPath(Collections.unmodifiableList(newNodes));
        }

        @Override
        public int compareTo(PropertyPath other) {
            if (this.nodes.size() != other.nodes.size()) {
                return this.nodes.size() < other.nodes.size() ? -1 : 1;
            }
            for (int index = 0; index < this.nodes.size(); ++index) {
                int compare;
                Object thisNode = this.nodes.get(index);
                Object otherNode = other.nodes.get(index);
                if (!thisNode.getClass().isInstance(otherNode) || !otherNode.getClass().isInstance(thisNode)) {
                    thisNode = thisNode.toString();
                    otherNode = otherNode.toString();
                }
                if ((compare = thisNode.compareTo(otherNode)) == 0) continue;
                return compare;
            }
            return 0;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof PropertyPath && ((PropertyPath)object).nodes.equals(this.nodes);
        }

        public int hashCode() {
            return this.nodes.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Comparable<? extends Serializable> node : this.nodes) {
                if (node instanceof String) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('.');
                    }
                    stringBuilder.append(node);
                    continue;
                }
                stringBuilder.append('[').append(node).append(']');
            }
            return stringBuilder.toString();
        }
    }
}

