/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.FactoryFinder;
import javax.faces.application.ProjectStage;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.omnifaces.component.ParamHolder;
import org.omnifaces.filter.MutableRequestFilter;
import org.omnifaces.util.Beans;
import org.omnifaces.util.BeansLocal;
import org.omnifaces.util.Faces;
import org.omnifaces.util.JNDI;
import org.omnifaces.util.Utils;

public final class Servlets {
    private static final Logger logger = Logger.getLogger(Servlets.class.getName());
    private static final String CONTENT_DISPOSITION_HEADER = "%s;filename=\"%2$s\"; filename*=UTF-8''%2$s";
    private static final Set<String> FACES_AJAX_HEADERS = Utils.unmodifiableSet("partial/ajax", "partial/process");
    private static final String FACES_AJAX_REDIRECT_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><partial-response><redirect url=\"%s\"></redirect></partial-response>";
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private static final String QUARKUS_WEB_XML = "META-INF/web.xml";
    private static Boolean facesDevelopment;

    private Servlets() {
    }

    public static String getRequestHostname(HttpServletRequest request) {
        try {
            return new URL(request.getRequestURL().toString()).getHost();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getRequestDomainURL(HttpServletRequest request) {
        try {
            URL url = new URL(request.getRequestURL().toString());
            String fullURL = url.toString();
            return fullURL.substring(0, fullURL.length() - url.getPath().length());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getRequestBaseURL(HttpServletRequest request) {
        return Servlets.getRequestDomainURL(request) + request.getContextPath() + "/";
    }

    public static String getRequestURI(HttpServletRequest request) {
        return Utils.coalesce((String)request.getAttribute("javax.servlet.error.request_uri"), (String)request.getAttribute("javax.servlet.forward.request_uri"), request.getRequestURI());
    }

    public static String getRequestPathInfo(HttpServletRequest request) {
        return Utils.coalesce((String)request.getAttribute("org.omnifaces.facesviews.original.path_info"), request.getPathInfo());
    }

    public static String getRequestQueryString(HttpServletRequest request) {
        return Utils.coalesce((String)request.getAttribute("javax.servlet.forward.query_string"), request.getQueryString());
    }

    public static Map<String, List<String>> getRequestQueryStringMap(HttpServletRequest request) {
        String queryString = Servlets.getRequestQueryString(request);
        if (Utils.isEmpty(queryString)) {
            return new LinkedHashMap<String, List<String>>(0);
        }
        return Servlets.toParameterMap(queryString);
    }

    public static Map<String, List<String>> getRequestParameterMap(HttpServletRequest request) {
        HashMap<String, List<String>> parameterMap = new HashMap<String, List<String>>(request.getParameterMap().size());
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            parameterMap.put((String)entry.getKey(), (List<String>)Arrays.asList((Object[])entry.getValue()));
        }
        return parameterMap;
    }

    public static Map<String, List<String>> getMutableRequestParameterMap(HttpServletRequest request) {
        return MutableRequestFilter.getMutableRequest(request).getMutableParameterMap();
    }

    public static String getRequestURIWithQueryString(HttpServletRequest request) {
        String requestURI = Servlets.getRequestURI(request);
        String queryString = Servlets.getRequestQueryString(request);
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    public static String getRequestRelativeURI(HttpServletRequest request) {
        return Servlets.getRequestURI(request).substring(request.getContextPath().length());
    }

    public static String getRequestRelativeURIWithoutPathParameters(HttpServletRequest request) {
        return Servlets.getRequestRelativeURI(request).split(";", 2)[0];
    }

    public static String getRequestURL(HttpServletRequest request) {
        return Servlets.getRequestDomainURL(request) + Servlets.getRequestURI(request);
    }

    public static String getRequestURLWithQueryString(HttpServletRequest request) {
        return Servlets.getRequestDomainURL(request) + Servlets.getRequestURIWithQueryString(request);
    }

    public static Map<String, List<String>> toParameterMap(String queryString) {
        String[] parameters = queryString.split(Pattern.quote("&"));
        LinkedHashMap<String, List<String>> parameterMap = new LinkedHashMap<String, List<String>>(parameters.length);
        for (String parameter : parameters) {
            String[] pair;
            if (!parameter.contains("=") || (pair = parameter.split(Pattern.quote("="))).length == 0) continue;
            String key = Servlets.decodeURLWithFallback(pair[0]);
            String value = pair.length > 1 && !Utils.isEmpty(pair[1]) ? Servlets.decodeURLWithFallback(pair[1]) : "";
            Servlets.addParamToMapIfNecessary(parameterMap, key, value);
        }
        return parameterMap;
    }

    private static String decodeURLWithFallback(String string) {
        try {
            return Utils.decodeURL(string);
        }
        catch (IllegalArgumentException e) {
            return string;
        }
    }

    public static String toQueryString(Map<String, List<String>> parameterMap) {
        StringBuilder queryString = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : parameterMap.entrySet()) {
            if (Utils.isEmpty(entry.getKey())) continue;
            String name = Utils.encodeURL(entry.getKey());
            for (String value : entry.getValue()) {
                if (value == null) continue;
                if (queryString.length() > 0) {
                    queryString.append("&");
                }
                queryString.append(name).append("=").append(Utils.encodeURL(value));
            }
        }
        return queryString.toString();
    }

    public static String toQueryString(List<? extends ParamHolder<?>> params) {
        StringBuilder queryString = new StringBuilder();
        for (ParamHolder<?> param : params) {
            String value;
            if (Utils.isEmpty(param.getName()) || (value = param.getValue()) == null) continue;
            if (queryString.length() > 0) {
                queryString.append("&");
            }
            queryString.append(Utils.encodeURL(param.getName())).append("=").append(Utils.encodeURL(value));
        }
        return queryString.toString();
    }

    public static String getRemoteAddr(HttpServletRequest request) {
        String forwardedFor = Utils.coalesce(request.getHeader("Forwarded"), request.getHeader("X-Forwarded-For"));
        return Utils.isEmpty(forwardedFor) ? request.getRemoteAddr() : forwardedFor.split("\\s*,\\s*", 2)[0];
    }

    public static boolean isProxied(HttpServletRequest request) {
        return !Utils.isEmpty(Utils.coalesce(request.getHeader("Forwarded"), request.getHeader("X-Forwarded-For")));
    }

    public static String getUserAgent(HttpServletRequest request) {
        return request.getHeader("User-Agent");
    }

    public static String getReferrer(HttpServletRequest request) {
        return request.getHeader("Referer");
    }

    public static boolean isSecure(HttpServletRequest request) {
        return request.isSecure() || "https".equalsIgnoreCase(request.getHeader("X-Forwarded-Proto"));
    }

    public static String getSubmittedFileName(Part part) {
        String[] parts;
        Map<String, String> entries = Servlets.headerToMap(part.getHeader("Content-Disposition"));
        String encodedFileName = entries.get("filename*");
        String fileName = null;
        if (encodedFileName != null && (parts = encodedFileName.split("'", 3)).length == 3 && !Utils.isEmpty(parts[0])) {
            try {
                fileName = URLDecoder.decode(parts[2], Charset.forName(parts[0]).name());
            }
            catch (UnsupportedEncodingException | IllegalArgumentException ignore) {
                logger.log(Level.FINEST, "Ignoring thrown exception, falling back to default filename", ignore);
            }
        }
        if (fileName == null) {
            fileName = entries.get("filename");
        }
        if (fileName != null) {
            if (fileName.matches("^[A-Za-z]:\\\\.*")) {
                fileName = fileName.substring(fileName.lastIndexOf(92) + 1);
            }
            return fileName.substring(fileName.lastIndexOf(47) + 1).replace("\\", "");
        }
        return null;
    }

    public static Map<String, String> headerToMap(String header) {
        if (Utils.isEmpty(header)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuilder builder = new StringBuilder();
        boolean quoted = false;
        for (int i = 0; i < header.length(); ++i) {
            char c = header.charAt(i);
            builder.append(c);
            if (c == '\"' && i > 0 && (header.charAt(i - 1) != '\\' || i > 1 && header.charAt(i - 2) == '\\')) {
                boolean bl = quoted = !quoted;
            }
            if ((quoted || c != ';') && i + 1 != header.length()) continue;
            String[] entry = builder.toString().replaceAll(";$", "").trim().split("\\s*=\\s*", 2);
            String name = entry[0].toLowerCase();
            String value = entry.length == 1 ? "" : entry[1].replaceAll("^\"|\"$", "").replace("\\\"", "\"").replaceAll("%\\\\([0-9]{2})", "%$1").trim();
            map.put(name, value);
            builder = new StringBuilder();
        }
        return Collections.unmodifiableMap(map);
    }

    public static Map<String, List<String>> getMutableRequestHeaderMap(HttpServletRequest request) {
        return MutableRequestFilter.getMutableRequest(request).getMutableHeaderMap();
    }

    public static void setCacheHeaders(HttpServletResponse response, long expires) {
        if (expires > 0L) {
            response.setHeader("Cache-Control", "public,max-age=" + expires + ",must-revalidate");
            response.setDateHeader("Expires", System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(expires));
            response.setHeader("Pragma", "");
        } else {
            Servlets.setNoCacheHeaders(response);
        }
    }

    public static void setNoCacheHeaders(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache,no-store,must-revalidate");
        response.setDateHeader("Expires", 0L);
        response.setHeader("Pragma", "no-cache");
    }

    public static String formatContentDispositionHeader(String filename, boolean attachment) {
        return String.format(CONTENT_DISPOSITION_HEADER, attachment ? "attachment" : "inline", Utils.encodeURI(filename));
    }

    public static void redirectPermanent(HttpServletResponse response, String url) {
        response.setStatus(301);
        response.setHeader("Location", url);
        response.setHeader("Connection", "close");
    }

    public static String getRequestCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return Utils.decodeURL(cookie.getValue());
            }
        }
        return null;
    }

    public static void addResponseCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, int maxAge) {
        Servlets.addResponseCookie(request, response, name, value, Servlets.getRequestHostname(request), null, maxAge);
    }

    public static void addResponseCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, String path, int maxAge) {
        Servlets.addResponseCookie(request, response, name, value, Servlets.getRequestHostname(request), path, maxAge);
    }

    public static void addResponseCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, String domain, String path, int maxAge) {
        Cookie cookie = new Cookie(name, Utils.encodeURL(value));
        if (!Utils.isOneOf(domain, null, "localhost")) {
            cookie.setDomain(domain);
        }
        if (path != null) {
            cookie.setPath(path);
        }
        cookie.setMaxAge(maxAge);
        cookie.setHttpOnly(true);
        cookie.setSecure(Servlets.isSecure(request));
        response.addCookie(cookie);
    }

    public static void removeResponseCookie(HttpServletRequest request, HttpServletResponse response, String name, String path) {
        Servlets.addResponseCookie(request, response, name, null, path, 0);
    }

    public static ServletContext getContext() {
        if (Faces.hasContext()) {
            return Faces.getServletContext();
        }
        BeanManager beanManager = Beans.getManager();
        if (BeansLocal.isActive(beanManager, RequestScoped.class)) {
            return BeansLocal.getInstance(beanManager, ServletContext.class, new Annotation[0]);
        }
        Bean<ServletContext> bean = BeansLocal.resolve(beanManager, ServletContext.class, new Annotation[0]);
        Context context = beanManager.getContext(ApplicationScoped.class);
        return (ServletContext)context.get(bean, beanManager.createCreationalContext(bean));
    }

    public static <T> T getApplicationAttribute(ServletContext context, String name) {
        return (T)context.getAttribute(name);
    }

    public static Lifecycle getFacesLifecycle(ServletContext context) {
        String lifecycleId = Utils.coalesce(context.getInitParameter("javax.faces.LIFECYCLE_ID"), "DEFAULT");
        return ((LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory")).getLifecycle(lifecycleId);
    }

    public static boolean isFacesAjaxRequest(HttpServletRequest request) {
        return FACES_AJAX_HEADERS.contains(request.getHeader("Faces-Request"));
    }

    public static boolean isFacesResourceRequest(HttpServletRequest request) {
        return Servlets.getRequestURI(request).startsWith(request.getContextPath() + "/javax.faces.resource" + "/");
    }

    public static boolean isFacesDevelopment(ServletContext context) {
        if (facesDevelopment == null) {
            String projectStage = null;
            try {
                projectStage = (String)JNDI.lookup("java:comp/env/jsf/ProjectStage");
            }
            catch (IllegalStateException ignore) {
                logger.log(Level.FINEST, "Ignoring thrown exception; will only happen in buggy containers.", ignore);
                return false;
            }
            if (projectStage == null) {
                projectStage = context.getInitParameter("javax.faces.PROJECT_STAGE");
            }
            facesDevelopment = ProjectStage.Development.name().equals(projectStage);
        }
        return facesDevelopment;
    }

    public static void facesRedirect(HttpServletRequest request, HttpServletResponse response, String url, Object ... paramValues) {
        String redirectURL = Servlets.prepareRedirectURL(request, url, paramValues);
        try {
            if (Servlets.isFacesAjaxRequest(request)) {
                Servlets.setNoCacheHeaders(response);
                response.setContentType("text/xml");
                response.setCharacterEncoding(StandardCharsets.UTF_8.name());
                response.getWriter().printf(FACES_AJAX_REDIRECT_XML, redirectURL);
            } else {
                response.sendRedirect(redirectURL);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static URL getWebXmlURL(ServletContext context) throws IOException {
        URL webXml = context.getResource(WEB_XML);
        return webXml != null ? webXml : Thread.currentThread().getContextClassLoader().getResource(QUARKUS_WEB_XML);
    }

    static String prepareRedirectURL(HttpServletRequest request, String url, Object ... paramValues) {
        String redirectURL = url;
        if (!Utils.startsWithOneOf(url, "http://", "https://", "/")) {
            redirectURL = request.getContextPath() + "/" + url;
        }
        if (Utils.isEmpty(paramValues)) {
            return redirectURL;
        }
        Object[] encodedParams = new Object[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            Object paramValue = paramValues[i];
            encodedParams[i] = paramValue instanceof String ? Utils.encodeURL((String)paramValue) : paramValue;
        }
        return String.format(redirectURL, encodedParams);
    }

    static void addParamToMapIfNecessary(Map<String, List<String>> map, String name, Object value) {
        if (Utils.isAnyEmpty(name, value)) {
            return;
        }
        map.computeIfAbsent(name, k -> new ArrayList(1)).add(value.toString());
    }
}

