/*
 * Decompiled with CFR 0.152.
 */
package xsbti.compile;

import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import xsbti.Logger;
import xsbti.compile.ClassFileManagerType;
import xsbti.compile.DeleteImmediatelyManagerType;
import xsbti.compile.IncOptions;
import xsbti.compile.TransactionalManagerType;

public class IncOptionsUtil {
    public static final String TRANSITIVE_STEP_KEY = "transitiveStep";
    public static final String RECOMPILE_ALL_FRACTION_KEY = "recompileAllFraction";
    public static final String RELATIONS_DEBUG_KEY = "relationsDebug";
    public static final String API_DEBUG_KEY = "apiDebug";
    public static final String API_DIFF_CONTEXT_SIZE_KEY = "apiDiffContextSize";
    public static final String API_DUMP_DIRECTORY_KEY = "apiDumpDirectory";
    public static final String RECOMPILE_ON_MACRO_DEF_KEY = "recompileOnMacroDef";
    public static final String USE_OPTIMIZED_SEALED = "useOptimizedSealed";
    public static final String LOG_RECOMPILE_ON_MACRO = "logRecompileOnMacro";
    public static final String CLASSFILE_MANAGER_TYPE_KEY = "classfileManagerType";
    public static final String IGNORED_SCALAC_OPTIONS_KEY = "ignoredScalacOptions";
    public static final String TRANSACTIONAL_MANAGER_TYPE = "transactionalManagerType";
    public static final String TRANSACTIONAL_MANAGER_BASE_DIRECTORY = "transactionalManagerBaseDirectory";
    public static final String DELETE_IMMEDIATELY_MANAGER_TYPE = "deleteImmediatelyManagerType";
    public static final String STORE_APIS = "storeApis";
    public static final String ALLOW_MACHINE_PATH = "allowMachinePath";
    public static final String PIPELINING = "pipelining";
    private static final String XSBTI_NOTHING = "NOTHING";

    private static Supplier<String> f0(final String string) {
        return new Supplier<String>(){

            @Override
            public String get() {
                return string;
            }
        };
    }

    public static IncOptions fromStringMap(Map<String, String> map, Logger logger) {
        return IncOptionsUtil.fromStringMap(IncOptions.of(), map, logger);
    }

    public static IncOptions fromStringMap(IncOptions incOptions, Map<String, String> map, Logger logger) {
        logger.debug(IncOptionsUtil.f0("Reading incremental options from map"));
        if (map.containsKey(TRANSITIVE_STEP_KEY)) {
            logger.debug(IncOptionsUtil.f0("TRANSITIVE_STEP_KEY value was read."));
            incOptions = incOptions.withTransitiveStep(Integer.parseInt(map.get(TRANSITIVE_STEP_KEY)));
        }
        if (map.containsKey(RECOMPILE_ALL_FRACTION_KEY)) {
            logger.debug(IncOptionsUtil.f0("RECOMPILE_ALL_FRACTION_KEY value was read."));
            incOptions = incOptions.withRecompileAllFraction(Double.parseDouble(map.get(RECOMPILE_ALL_FRACTION_KEY)));
        }
        if (map.containsKey(RELATIONS_DEBUG_KEY)) {
            logger.debug(IncOptionsUtil.f0("RELATIONS_DEBUG_KEY value was read."));
            incOptions = incOptions.withRelationsDebug(Boolean.parseBoolean(map.get(RELATIONS_DEBUG_KEY)));
        }
        if (map.containsKey(API_DEBUG_KEY)) {
            logger.debug(IncOptionsUtil.f0("API_DEBUG_KEY value was read."));
            incOptions = incOptions.withApiDebug(Boolean.parseBoolean(map.get(API_DEBUG_KEY)));
        }
        if (map.containsKey(API_DIFF_CONTEXT_SIZE_KEY)) {
            logger.debug(IncOptionsUtil.f0("API_DIFF_CONTENT_SIZE_KEY value was read."));
            incOptions = incOptions.withApiDiffContextSize(Integer.parseInt(map.get(API_DIFF_CONTEXT_SIZE_KEY)));
        }
        if (map.containsKey(API_DUMP_DIRECTORY_KEY)) {
            if (map.get(API_DUMP_DIRECTORY_KEY).equals(XSBTI_NOTHING)) {
                incOptions = incOptions.withApiDumpDirectory(Optional.empty());
            } else {
                logger.debug(IncOptionsUtil.f0("API_DUMP_DIRECTORY_KEY value was read."));
                incOptions = incOptions.withApiDumpDirectory(Optional.of(new File(map.get(API_DUMP_DIRECTORY_KEY))));
            }
        }
        if (map.containsKey(CLASSFILE_MANAGER_TYPE_KEY)) {
            String string = map.get(CLASSFILE_MANAGER_TYPE_KEY);
            if (string.equals(XSBTI_NOTHING)) {
                incOptions = incOptions.withClassfileManagerType(Optional.empty());
            } else {
                logger.debug(IncOptionsUtil.f0("CLASS_FILE_MANAGER_TYPE_KEY value was read."));
                if (string.equals(TRANSACTIONAL_MANAGER_TYPE)) {
                    if (map.containsKey(TRANSACTIONAL_MANAGER_BASE_DIRECTORY)) {
                        File file = new File(map.get(TRANSACTIONAL_MANAGER_BASE_DIRECTORY));
                        incOptions = incOptions.withClassfileManagerType((ClassFileManagerType)new TransactionalManagerType(file, logger));
                    } else {
                        logger.warn(IncOptionsUtil.f0("Missing transactionalManagerBaseDirectory key for specified transactional classfile manager."));
                        logger.warn(IncOptionsUtil.f0("Classfile manager defaults to delete immediately manager type."));
                        incOptions = incOptions.withClassfileManagerType((ClassFileManagerType)new DeleteImmediatelyManagerType());
                    }
                } else if (string.equals(DELETE_IMMEDIATELY_MANAGER_TYPE)) {
                    incOptions = incOptions.withClassfileManagerType((ClassFileManagerType)new DeleteImmediatelyManagerType());
                } else {
                    logger.warn(IncOptionsUtil.f0("Unrecognised classfile manager type key " + string + "."));
                    logger.warn(IncOptionsUtil.f0("Classfile manager defaults to delete immediately manager type."));
                    incOptions = incOptions.withClassfileManagerType((ClassFileManagerType)new DeleteImmediatelyManagerType());
                }
            }
        }
        if (map.containsKey(RECOMPILE_ON_MACRO_DEF_KEY)) {
            if (map.get(RECOMPILE_ON_MACRO_DEF_KEY).equals(XSBTI_NOTHING)) {
                incOptions = incOptions.withRecompileOnMacroDef(Optional.empty());
            } else {
                logger.debug(IncOptionsUtil.f0("RECOMPILE_ON_MACRO_DEF_KEY value was read."));
                incOptions = incOptions.withRecompileOnMacroDef(Optional.of(Boolean.parseBoolean(map.get(RECOMPILE_ON_MACRO_DEF_KEY))));
            }
        }
        if (map.containsKey(LOG_RECOMPILE_ON_MACRO)) {
            logger.debug(IncOptionsUtil.f0("LOG_RECOMPILE_ON_MACRO value was read."));
            incOptions = incOptions.withLogRecompileOnMacro(Boolean.parseBoolean(map.get(LOG_RECOMPILE_ON_MACRO)));
        }
        if (map.containsKey(USE_OPTIMIZED_SEALED)) {
            logger.debug(IncOptionsUtil.f0("USE_OPTIMIZED_SEALED value was read."));
            incOptions = incOptions.withUseOptimizedSealed(Boolean.parseBoolean(map.get(USE_OPTIMIZED_SEALED)));
        }
        if (map.containsKey(IGNORED_SCALAC_OPTIONS_KEY)) {
            logger.debug(IncOptionsUtil.f0("IGNORED_SCALAC_OPTIONS_KEY value was read."));
            incOptions = incOptions.withIgnoredScalacOptions(map.get(IGNORED_SCALAC_OPTIONS_KEY).split(" +"));
        }
        if (map.containsKey(STORE_APIS)) {
            logger.debug(IncOptionsUtil.f0("STORE_APIS value was read."));
            incOptions = incOptions.withStoreApis(Boolean.parseBoolean(map.get(STORE_APIS)));
        }
        if (map.containsKey(ALLOW_MACHINE_PATH)) {
            logger.debug(IncOptionsUtil.f0("ALLOW_MACHINE_PATH value was read."));
            incOptions = incOptions.withAllowMachinePath(Boolean.parseBoolean(map.get(ALLOW_MACHINE_PATH)));
        }
        if (map.containsKey(PIPELINING)) {
            logger.debug(IncOptionsUtil.f0("PIPELINING value was read."));
            incOptions = incOptions.withPipelining(Boolean.parseBoolean(map.get(PIPELINING)));
        }
        return incOptions;
    }
}

