/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import org.seleniumhq.selenium.fluent.FluentMatcher;
import org.seleniumhq.selenium.fluent.FluentWebElement;

public class CompositeFluentMatcher
implements FluentMatcher {
    private final LogicalOperator logicalOperator;
    private FluentMatcher[] matchers;

    public CompositeFluentMatcher(LogicalOperator logicalOperator, FluentMatcher ... matchers) {
        this.logicalOperator = logicalOperator;
        this.matchers = matchers;
    }

    public boolean matches(FluentWebElement webElement, int ix) {
        Boolean matched = null;
        for (FluentMatcher matcher : this.matchers) {
            matched = this.logicalOperator.invoke(webElement, matched, matcher, ix);
        }
        return matched;
    }

    public static FluentMatcher both(FluentMatcher one, FluentMatcher two) {
        return new CompositeFluentMatcher(new And(), one, two);
    }

    public static FluentMatcher all(FluentMatcher ... matchers) {
        return new CompositeFluentMatcher(new And(), matchers);
    }

    public static FluentMatcher any(FluentMatcher ... matchers) {
        return new CompositeFluentMatcher(new Or(), matchers);
    }

    public static FluentMatcher either(FluentMatcher one, FluentMatcher two) {
        return new CompositeFluentMatcher(new Or(), one, two);
    }

    private static class Or
    implements LogicalOperator {
        private Or() {
        }

        public boolean invoke(FluentWebElement webElement, Boolean matched, FluentMatcher matcher, int ix) {
            if (matched == null) {
                matched = false;
            }
            return matched != false || matcher.matches(webElement, ix);
        }
    }

    private static class And
    implements LogicalOperator {
        private And() {
        }

        public boolean invoke(FluentWebElement webElement, Boolean matched, FluentMatcher matcher, int ix) {
            if (matched == null) {
                matched = true;
            }
            return matched != false && matcher.matches(webElement, ix);
        }
    }

    private static interface LogicalOperator {
        public boolean invoke(FluentWebElement var1, Boolean var2, FluentMatcher var3, int var4);
    }
}

