/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByXPath;

public abstract class FluentBy
extends By {
    public void beforeFindElement(WebDriver driver) {
    }

    public static ByStrictClassName strictClassName(String className) {
        if (className == null) {
            throw new IllegalArgumentException("Cannot find elements when the class name expression is null.");
        }
        if (className.matches(".*\\s+.*")) {
            throw new InvalidSelectorException("Compound class names are not supported. Consider searching for one class name and filtering the results.");
        }
        return new ByStrictClassName(className);
    }

    public static ByAttribute attribute(String name) {
        return FluentBy.attribute(name, null);
    }

    public static ByAttribute attribute(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot find elements when the attribute name is null");
        }
        return new ByAttribute(name, value);
    }

    public static ByAttribute notAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot find elements when the attribute name is null");
        }
        return new NotByAttribute(name);
    }

    public static ByComposite composite(By.ByTagName b0, By.ByClassName b1) {
        return new ByComposite(new By[]{b0, b1});
    }

    public static ByComposite composite(By.ByTagName b0, ByAttribute b1) {
        return new ByComposite(new By[]{b0, b1});
    }

    public static ByLast last(By by) {
        if (by instanceof ByAttribute) {
            return new ByLast((ByAttribute)by);
        }
        throw new UnsupportedOperationException("last() not allowed for " + by.getClass().getName() + " type");
    }

    public static ByLast last() {
        return new ByLast();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByAttribute
    extends FluentBy {
        protected final String name;
        private final String value;

        public ByAttribute(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public WebElement findElement(SearchContext context) {
            return this.makeByXPath().findElement(context);
        }

        private By makeByXPath() {
            return By.xpath((String)this.makeXPath());
        }

        private String makeXPath() {
            return ".//*[" + this.nameAndValue() + "]";
        }

        protected String nameAndValue() {
            return "@" + this.name + this.val();
        }

        private String val() {
            return this.value == null ? "" : " = '" + this.value + "'";
        }

        public List<WebElement> findElements(SearchContext context) {
            return this.makeByXPath().findElements(context);
        }

        public String toString() {
            return "FluentBy.attribute: " + this.name + this.val();
        }
    }

    public static class NotByAttribute
    extends ByAttribute {
        public NotByAttribute(String name) {
            super(name, null);
        }

        protected String nameAndValue() {
            return "not(" + super.nameAndValue() + ")";
        }

        public String toString() {
            return "FluentBy.notAttribute: " + this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ByStrictClassName
    extends FluentBy {
        private final String className;

        public ByStrictClassName(String className) {
            this.className = className;
        }

        public List<WebElement> findElements(SearchContext context) {
            if (context instanceof FindsByClassName) {
                return ((FindsByClassName)context).findElementsByClassName(this.className);
            }
            return ((FindsByXPath)context).findElementsByXPath(".//*[@class = '" + this.className + "']");
        }

        public WebElement findElement(SearchContext context) {
            if (context instanceof FindsByClassName) {
                return ((FindsByClassName)context).findElementByClassName(this.className);
            }
            return ((FindsByXPath)context).findElementByXPath(".//*[@class = '" + this.className + "']");
        }

        public String toString() {
            return "FluentBy.strictClassName: " + this.className;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ByComposite
    extends FluentBy {
        private final By[] bys;

        private ByComposite(By ... bys) {
            this.bys = bys;
        }

        public List<WebElement> findElements(SearchContext context) {
            return this.makeByXPath().findElements(context);
        }

        private String containingWord(String attribute, String word) {
            return "contains(concat(' ',normalize-space(@" + attribute + "),' '),' " + word + " ')";
        }

        private By makeByXPath() {
            String xpathExpression = this.makeXPath();
            return By.xpath((String)xpathExpression);
        }

        private String makeXPath() {
            String xpathExpression = ".//" + this.getTagName();
            if (this.bys[1] instanceof By.ByClassName) {
                String className = this.bys[1].toString().substring("By.className: ".length());
                xpathExpression = xpathExpression + "[" + this.containingWord("class", className) + "]";
            } else if (this.bys[1] instanceof ByAttribute) {
                ByAttribute by = (ByAttribute)this.bys[1];
                xpathExpression = xpathExpression + "[" + by.nameAndValue() + "]";
            }
            return xpathExpression;
        }

        private String getTagName() {
            return this.bys[0].toString().substring("By.tagName: ".length());
        }

        public WebElement findElement(SearchContext context) {
            return this.makeByXPath().findElement(context);
        }

        public String toString() {
            return "FluentBy.composite(" + Arrays.asList(this.bys) + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ByLast
    extends FluentBy {
        private final String orig;
        private final ByAttribute by;

        public ByLast(ByAttribute by) {
            this.by = by;
            this.orig = by.makeXPath();
        }

        public ByLast() {
            this.orig = ".//*[]";
            this.by = null;
        }

        public List<WebElement> findElements(SearchContext context) {
            return this.makeXPath().findElements(context);
        }

        private By makeXPath() {
            return By.xpath((String)(this.orig.substring(0, this.orig.length() - 1) + " and position() = last()]").replace("[ and ", "["));
        }

        public WebElement findElement(SearchContext context) {
            return this.makeXPath().findElement(context);
        }

        public String toString() {
            return "FluentBy.last(" + (this.by == null ? "" : this.by) + ")";
        }
    }
}

