/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.Point;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.seleniumhq.selenium.fluent.FluentExecutionStopped;
import org.seleniumhq.selenium.fluent.FluentWebDriver;
import org.seleniumhq.selenium.fluent.FluentWebElements;
import org.seleniumhq.selenium.fluent.Internal;
import org.seleniumhq.selenium.fluent.Monitor;
import org.seleniumhq.selenium.fluent.Period;
import org.seleniumhq.selenium.fluent.TestableString;
import org.seleniumhq.selenium.fluent.TestableValue;
import org.seleniumhq.selenium.fluent.internal.Context;
import org.seleniumhq.selenium.fluent.internal.Execution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluentWebElement
extends Internal.BaseFluentWebElement {
    protected final Internal.WebElementHolder currentElement;

    protected FluentWebElement(WebDriver delegate, Internal.WebElementHolder currentElement, Context context, Monitor monitor, boolean booleanInsteadOfNoSuchElement) {
        super(delegate, context, monitor, booleanInsteadOfNoSuchElement);
        this.currentElement = currentElement;
    }

    @Override
    protected SearchContext getSearchContext() {
        return this.currentElement.getFound();
    }

    @Override
    public WebElement getWebElement() {
        return this.currentElement.getFound();
    }

    @Override
    protected WebElement findElement(By by, Context ctx, SearchContext searchContext) {
        return this.actualFindElement(by, ctx, searchContext);
    }

    @Override
    protected List<WebElement> findElements(By by, Context ctx) {
        return this.actualFindElements(by, ctx);
    }

    @Override
    protected WebElement actualFindElement(By by, Context ctx, SearchContext searchContext) {
        this.beforeFindElement(by);
        return searchContext.findElement(by);
    }

    @Override
    protected List<WebElement> actualFindElements(By by, Context ctx) {
        this.beforeFindElement(by);
        return this.currentElement.getFound().findElements(by);
    }

    private <T> T executeAndWrapReThrowIfNeeded(Execution<T> execution, Context ctx, boolean expectedToBeThere) {
        return this.executeAndWrapReThrowIfNeeded(execution, this.currentElement, ctx, expectedToBeThere);
    }

    public FluentWebElement click() {
        Context ctx = Context.singular(this.context, "click");
        this.executeAndWrapReThrowIfNeeded(this.setCurrentElement(new Click()), ctx, true);
        return new FluentWebElement(this.delegate, this.currentElement, ctx, this.monitor, this.booleanInsteadOfNotFoundException);
    }

    public FluentWebElement clearField() {
        Context ctx = Context.singular(this.context, "clearField");
        this.executeAndWrapReThrowIfNeeded(this.setCurrentElement(new Clear()), ctx, true);
        return new FluentWebElement(this.delegate, this.currentElement, ctx, this.monitor, this.booleanInsteadOfNotFoundException);
    }

    public FluentWebElement submit() {
        this.executeAndWrapReThrowIfNeeded(new Submit(), Context.singular(this.context, "submit"), true);
        return new FluentWebElement(this.delegate, this.currentElement, this.context, this.monitor, this.booleanInsteadOfNotFoundException);
    }

    public FluentWebElement sendKeys(CharSequence ... keysToSend) {
        this.executeAndWrapReThrowIfNeeded(new SendKeys(keysToSend), Context.singular(this.context, "sendKeys", null, this.charSeqArrayAsHumanString(keysToSend)), true);
        return new FluentWebElement(this.delegate, this.currentElement, this.context, this.monitor, this.booleanInsteadOfNotFoundException);
    }

    public TestableString getTagName() {
        return new TestableString(this.setCurrentElement(new GetTagName()), Context.singular(this.context, "getTagName"), this.monitor);
    }

    public TestableValue<Boolean> isSelected() {
        Context isSelected = Context.singular(this.context, "isSelected");
        return new TestableValue<Boolean>(this.setCurrentElement(new IsSelected()), isSelected, this.monitor);
    }

    public TestableValue<Boolean> isEnabled() {
        Context isEnabled = Context.singular(this.context, "isEnabled");
        return new TestableValue<Boolean>(this.setCurrentElement(new IsEnabled()), isEnabled, this.monitor);
    }

    public TestableValue<Boolean> isDisplayed() {
        Context isDisplayed = Context.singular(this.context, "isDisplayed");
        return new TestableValue<Boolean>(this.setCurrentElement(new IsDisplayed()), isDisplayed, this.monitor);
    }

    public FluentWebElement ifInvisibleWaitUpTo(Period period) {
        Context ifInvisibleWaitUpTo = Context.singular(this.context, "ifInvisibleWaitUpTo", period);
        this.executeAndWrapReThrowIfNeeded(this.setCurrentElement(new IfInvisibleWait(period)), this.currentElement, ifInvisibleWaitUpTo, true);
        return new FluentWebElement(this.delegate, this.currentElement, ifInvisibleWaitUpTo, this.monitor, this.booleanInsteadOfNotFoundException);
    }

    public TestableValue<Point> getLocation() {
        Context getLocation = Context.singular(this.context, "getLocation");
        return new TestableValue<Point>(this.setCurrentElement(new GetLocation()), getLocation, this.monitor);
    }

    private Execution setCurrentElement(Execution execution) {
        return execution.withWebElementHolder(this.currentElement);
    }

    public TestableValue<Dimension> getSize() {
        Context getSize = Context.singular(this.context, "getSize");
        return new TestableValue<Dimension>(this.setCurrentElement(new GetSize()), getSize, this.monitor);
    }

    public TestableString getCssValue(String cssName) {
        return new TestableString(this.setCurrentElement(new GetCssValue(cssName)), Context.singular(this.context, "getCssValue", null, cssName), this.monitor).within(this.getPeriod());
    }

    public TestableString getAttribute(String attr) {
        return new TestableString(this.setCurrentElement(new GetAttribute(attr)), Context.singular(this.context, "getAttribute", null, attr), this.monitor).within(this.getPeriod());
    }

    public TestableString getText() {
        return new TestableString(this.setCurrentElement(new GetText(new TestableString.NoopStringChanger())), Context.singular(this.context, "getText"), this.monitor);
    }

    public TestableString getText(TestableString.StringChanger ... stringChangers) {
        return new TestableString(this.setCurrentElement(new GetText(stringChangers)), Context.singular(this.context, "getText"), this.monitor);
    }

    public FluentWebElement within(Period period) {
        return new RetryingFluentWebElement(this.delegate, this.currentElement, Context.singular(this.context, "within", null, period), period, this.monitor, this.booleanInsteadOfNotFoundException);
    }

    public NegatingFluentWebElement without(Period period) {
        return new NegatingFluentWebElement(this.delegate, this.currentElement, period, Context.singular(this.context, "without", null, period), this.monitor, this.booleanInsteadOfNotFoundException);
    }

    @Override
    public FluentWebElement element() {
        return (FluentWebElement)super.element();
    }

    @Override
    public FluentWebElement element(By by) {
        return (FluentWebElement)super.element(by);
    }

    @Override
    public FluentWebElements elements() {
        return (FluentWebElements)super.elements();
    }

    @Override
    public FluentWebElements elements(By by) {
        return (FluentWebElements)super.elements(by);
    }

    @Override
    public FluentWebElement span() {
        return (FluentWebElement)super.span();
    }

    @Override
    public FluentWebElement span(By by) {
        return (FluentWebElement)super.span(by);
    }

    @Override
    public FluentWebElements spans() {
        return (FluentWebElements)super.spans();
    }

    @Override
    public FluentWebElements spans(By by) {
        return (FluentWebElements)super.spans(by);
    }

    @Override
    public FluentWebElement div() {
        return (FluentWebElement)super.div();
    }

    @Override
    public FluentWebElement div(By by) {
        return (FluentWebElement)super.div(by);
    }

    @Override
    public FluentWebElements divs() {
        return (FluentWebElements)super.divs();
    }

    @Override
    public FluentWebElements divs(By by) {
        return (FluentWebElements)super.divs(by);
    }

    @Override
    public FluentWebElement button() {
        return (FluentWebElement)super.button();
    }

    @Override
    public FluentWebElement button(By by) {
        return (FluentWebElement)super.button(by);
    }

    @Override
    public FluentWebElements buttons() {
        return (FluentWebElements)super.buttons();
    }

    @Override
    public FluentWebElements buttons(By by) {
        return (FluentWebElements)super.buttons(by);
    }

    @Override
    public FluentWebElement link() {
        return (FluentWebElement)super.link();
    }

    @Override
    public FluentWebElement link(By by) {
        return (FluentWebElement)super.link(by);
    }

    @Override
    public FluentWebElements links() {
        return (FluentWebElements)super.links();
    }

    @Override
    public FluentWebElements links(By by) {
        return (FluentWebElements)super.links(by);
    }

    @Override
    public FluentWebElement input() {
        return (FluentWebElement)super.input();
    }

    @Override
    public FluentWebElement input(By by) {
        return (FluentWebElement)super.input(by);
    }

    @Override
    public FluentWebElements inputs() {
        return (FluentWebElements)super.inputs();
    }

    @Override
    public FluentWebElements inputs(By by) {
        return (FluentWebElements)super.inputs(by);
    }

    @Override
    public FluentWebElement option() {
        return (FluentWebElement)super.option();
    }

    @Override
    public FluentWebElements options() {
        return (FluentWebElements)super.options();
    }

    @Override
    public FluentWebElement option(By by) {
        return (FluentWebElement)super.option(by);
    }

    @Override
    public FluentWebElements options(By by) {
        return (FluentWebElements)super.options(by);
    }

    @Override
    public FluentWebElement textarea() {
        return (FluentWebElement)super.textarea();
    }

    @Override
    public FluentWebElements textareas() {
        return (FluentWebElements)super.textareas();
    }

    @Override
    public FluentWebElement textarea(By by) {
        return (FluentWebElement)super.textarea(by);
    }

    @Override
    public FluentWebElements textareas(By by) {
        return (FluentWebElements)super.textareas(by);
    }

    @Override
    public FluentWebElement h1() {
        return (FluentWebElement)super.h1();
    }

    @Override
    public FluentWebElement h1(By by) {
        return (FluentWebElement)super.h1(by);
    }

    @Override
    public FluentWebElements h1s() {
        return (FluentWebElements)super.h1s();
    }

    @Override
    public FluentWebElements h1s(By by) {
        return (FluentWebElements)super.h1s(by);
    }

    @Override
    public FluentWebElement h2() {
        return (FluentWebElement)super.h2();
    }

    @Override
    public FluentWebElement h2(By by) {
        return (FluentWebElement)super.h2(by);
    }

    @Override
    public FluentWebElements h2s() {
        return (FluentWebElements)super.h2s();
    }

    @Override
    public FluentWebElements h2s(By by) {
        return (FluentWebElements)super.h2s(by);
    }

    @Override
    public FluentWebElement h3() {
        return (FluentWebElement)super.h3();
    }

    @Override
    public FluentWebElement h3(By by) {
        return (FluentWebElement)super.h3(by);
    }

    @Override
    public FluentWebElements h3s() {
        return (FluentWebElements)super.h3s();
    }

    @Override
    public FluentWebElements h3s(By by) {
        return (FluentWebElements)super.h3s(by);
    }

    @Override
    public FluentWebElement h4() {
        return (FluentWebElement)super.h4();
    }

    @Override
    public FluentWebElement h4(By by) {
        return (FluentWebElement)super.h4(by);
    }

    @Override
    public FluentWebElements h4s() {
        return (FluentWebElements)super.h4s();
    }

    @Override
    public FluentWebElements h4s(By by) {
        return (FluentWebElements)super.h4s(by);
    }

    @Override
    public FluentWebElement h5() {
        return (FluentWebElement)super.h5();
    }

    @Override
    public FluentWebElement h5(By by) {
        return (FluentWebElement)super.h5(by);
    }

    @Override
    public FluentWebElements h5s() {
        return (FluentWebElements)super.h5s();
    }

    @Override
    public FluentWebElements h5s(By by) {
        return (FluentWebElements)super.h5s(by);
    }

    @Override
    public FluentWebElement h6() {
        return (FluentWebElement)super.h6();
    }

    @Override
    public FluentWebElement h6(By by) {
        return (FluentWebElement)super.h6(by);
    }

    @Override
    public FluentWebElements h6s() {
        return (FluentWebElements)super.h6s();
    }

    @Override
    public FluentWebElements h6s(By by) {
        return (FluentWebElements)super.h6s(by);
    }

    @Override
    public FluentWebElement td() {
        return (FluentWebElement)super.td();
    }

    @Override
    public FluentWebElement td(By by) {
        return (FluentWebElement)super.td(by);
    }

    @Override
    public FluentWebElements tds() {
        return (FluentWebElements)super.tds();
    }

    @Override
    public FluentWebElements tds(By by) {
        return (FluentWebElements)super.tds(by);
    }

    @Override
    public FluentWebElement form() {
        return (FluentWebElement)super.form();
    }

    @Override
    public FluentWebElement form(By by) {
        return (FluentWebElement)super.form(by);
    }

    @Override
    public FluentWebElements forms() {
        return (FluentWebElements)super.forms();
    }

    @Override
    public FluentWebElements forms(By by) {
        return (FluentWebElements)super.forms(by);
    }

    @Override
    public FluentWebElement table() {
        return (FluentWebElement)super.table();
    }

    @Override
    public FluentWebElement table(By by) {
        return (FluentWebElement)super.table(by);
    }

    @Override
    public FluentWebElements tables() {
        return (FluentWebElements)super.tables();
    }

    @Override
    public FluentWebElements tables(By by) {
        return (FluentWebElements)super.tables(by);
    }

    @Override
    public FluentWebElement fieldset() {
        return (FluentWebElement)super.fieldset();
    }

    @Override
    public FluentWebElement fieldset(By by) {
        return (FluentWebElement)super.fieldset(by);
    }

    @Override
    public FluentWebElements fieldsets() {
        return (FluentWebElements)super.fieldsets();
    }

    @Override
    public FluentWebElements fieldsets(By by) {
        return (FluentWebElements)super.fieldsets(by);
    }

    @Override
    public FluentWebElement tr() {
        return (FluentWebElement)super.tr();
    }

    @Override
    public FluentWebElement tr(By by) {
        return (FluentWebElement)super.tr(by);
    }

    @Override
    public FluentWebElements trs() {
        return (FluentWebElements)super.trs();
    }

    @Override
    public FluentWebElements trs(By by) {
        return (FluentWebElements)super.trs(by);
    }

    @Override
    public FluentWebElement img() {
        return (FluentWebElement)super.img();
    }

    @Override
    public FluentWebElement img(By by) {
        return (FluentWebElement)super.img(by);
    }

    @Override
    public FluentWebElements imgs() {
        return (FluentWebElements)super.imgs();
    }

    @Override
    public FluentWebElements imgs(By by) {
        return (FluentWebElements)super.imgs(by);
    }

    @Override
    public FluentWebElement legend() {
        return (FluentWebElement)super.legend();
    }

    @Override
    public FluentWebElement legend(By by) {
        return (FluentWebElement)super.legend(by);
    }

    @Override
    public FluentWebElements legends() {
        return (FluentWebElements)super.legends();
    }

    @Override
    public FluentWebElements legends(By by) {
        return (FluentWebElements)super.legends(by);
    }

    @Override
    public FluentWebElement th() {
        return (FluentWebElement)super.th();
    }

    @Override
    public FluentWebElement th(By by) {
        return (FluentWebElement)super.th(by);
    }

    @Override
    public FluentWebElements ths() {
        return (FluentWebElements)super.ths();
    }

    @Override
    public FluentWebElements ths(By by) {
        return (FluentWebElements)super.ths(by);
    }

    @Override
    public FluentWebElement map() {
        return (FluentWebElement)super.map();
    }

    @Override
    public FluentWebElement map(By by) {
        return (FluentWebElement)super.map(by);
    }

    @Override
    public FluentWebElements maps() {
        return (FluentWebElements)super.maps();
    }

    @Override
    public FluentWebElements maps(By by) {
        return (FluentWebElements)super.maps(by);
    }

    @Override
    public FluentWebElement ol() {
        return (FluentWebElement)super.ol();
    }

    @Override
    public FluentWebElement ol(By by) {
        return (FluentWebElement)super.ol(by);
    }

    @Override
    public FluentWebElements ols() {
        return (FluentWebElements)super.ols();
    }

    @Override
    public FluentWebElements ols(By by) {
        return (FluentWebElements)super.ols(by);
    }

    @Override
    public FluentWebElement li() {
        return (FluentWebElement)super.li();
    }

    @Override
    public FluentWebElement li(By by) {
        return (FluentWebElement)super.li(by);
    }

    @Override
    public FluentWebElement ul() {
        return (FluentWebElement)super.ul();
    }

    @Override
    public FluentWebElement ul(By by) {
        return (FluentWebElement)super.ul(by);
    }

    @Override
    public FluentWebElements uls() {
        return (FluentWebElements)super.uls();
    }

    @Override
    public FluentWebElements uls(By by) {
        return (FluentWebElements)super.uls(by);
    }

    @Override
    public FluentWebElements lis() {
        return (FluentWebElements)super.lis();
    }

    @Override
    public FluentWebElements lis(By by) {
        return (FluentWebElements)super.lis(by);
    }

    @Override
    public FluentWebElement p() {
        return (FluentWebElement)super.p();
    }

    @Override
    public FluentWebElement p(By by) {
        return (FluentWebElement)super.p(by);
    }

    @Override
    public FluentWebElements ps() {
        return (FluentWebElements)super.ps();
    }

    @Override
    public FluentWebElements ps(By by) {
        return (FluentWebElements)super.ps(by);
    }

    @Override
    public FluentWebElement b() {
        return (FluentWebElement)super.b();
    }

    @Override
    public FluentWebElement b(By by) {
        return (FluentWebElement)super.b(by);
    }

    @Override
    public FluentWebElements bs() {
        return (FluentWebElements)super.bs();
    }

    @Override
    public FluentWebElements bs(By by) {
        return (FluentWebElements)super.bs(by);
    }

    @Override
    public FluentWebElement pre() {
        return (FluentWebElement)super.pre();
    }

    @Override
    public FluentWebElement pre(By by) {
        return (FluentWebElement)super.pre(by);
    }

    @Override
    public FluentWebElements pres() {
        return (FluentWebElements)super.pres();
    }

    @Override
    public FluentWebElements pres(By by) {
        return (FluentWebElements)super.pres(by);
    }

    @Override
    public FluentWebElement header() {
        return (FluentWebElement)super.header();
    }

    @Override
    public FluentWebElement header(By by) {
        return (FluentWebElement)super.header(by);
    }

    @Override
    public FluentWebElements headers() {
        return (FluentWebElements)super.headers();
    }

    @Override
    public FluentWebElements headers(By by) {
        return (FluentWebElements)super.headers(by);
    }

    @Override
    public FluentWebElement footer() {
        return (FluentWebElement)super.footer();
    }

    @Override
    public FluentWebElement footer(By by) {
        return (FluentWebElement)super.footer(by);
    }

    @Override
    public FluentWebElements footers() {
        return (FluentWebElements)super.footers();
    }

    @Override
    public FluentWebElements footers(By by) {
        return (FluentWebElements)super.footers(by);
    }

    @Override
    public FluentWebElement figure() {
        return (FluentWebElement)super.figure();
    }

    @Override
    public FluentWebElement figure(By by) {
        return (FluentWebElement)super.figure(by);
    }

    @Override
    public FluentWebElements figures() {
        return (FluentWebElements)super.figures();
    }

    @Override
    public FluentWebElements figures(By by) {
        return (FluentWebElements)super.figures(by);
    }

    @Override
    public FluentWebElement acronym() {
        return (FluentWebElement)super.acronym();
    }

    @Override
    public FluentWebElement acronym(By by) {
        return (FluentWebElement)super.acronym(by);
    }

    @Override
    public FluentWebElements acronyms() {
        return (FluentWebElements)super.acronyms();
    }

    @Override
    public FluentWebElements acronyms(By by) {
        return (FluentWebElements)super.acronyms(by);
    }

    @Override
    public FluentWebElement abbr() {
        return (FluentWebElement)super.abbr();
    }

    @Override
    public FluentWebElement abbr(By by) {
        return (FluentWebElement)super.abbr(by);
    }

    @Override
    public FluentWebElements abbrs() {
        return (FluentWebElements)super.abbrs();
    }

    @Override
    public FluentWebElements abbrs(By by) {
        return (FluentWebElements)super.abbrs(by);
    }

    @Override
    public FluentWebElement address() {
        return (FluentWebElement)super.address();
    }

    @Override
    public FluentWebElement address(By by) {
        return (FluentWebElement)super.address(by);
    }

    @Override
    public FluentWebElements addresses() {
        return (FluentWebElements)super.addresses();
    }

    @Override
    public FluentWebElements addresses(By by) {
        return (FluentWebElements)super.addresses(by);
    }

    @Override
    public FluentWebElement blockquote() {
        return (FluentWebElement)super.blockquote();
    }

    @Override
    public FluentWebElement blockquote(By by) {
        return (FluentWebElement)super.blockquote(by);
    }

    @Override
    public FluentWebElements blockquotes() {
        return (FluentWebElements)super.blockquotes();
    }

    @Override
    public FluentWebElements blockquotes(By by) {
        return (FluentWebElements)super.blockquotes(by);
    }

    @Override
    public FluentWebElement area() {
        return (FluentWebElement)super.area();
    }

    @Override
    public FluentWebElement area(By by) {
        return (FluentWebElement)super.area(by);
    }

    @Override
    public FluentWebElements areas() {
        return (FluentWebElements)super.areas();
    }

    @Override
    public FluentWebElements areas(By by) {
        return (FluentWebElements)super.areas(by);
    }

    @Override
    public FluentWebElement label() {
        return (FluentWebElement)super.label();
    }

    @Override
    public FluentWebElement label(By by) {
        return (FluentWebElement)super.label(by);
    }

    @Override
    public FluentWebElements labels() {
        return (FluentWebElements)super.labels();
    }

    @Override
    public FluentWebElements labels(By by) {
        return (FluentWebElements)super.labels(by);
    }

    @Override
    public FluentWebElement object() {
        return (FluentWebElement)super.object();
    }

    @Override
    public FluentWebElement object(By by) {
        return (FluentWebElement)super.object(by);
    }

    @Override
    public FluentWebElements objects() {
        return (FluentWebElements)super.objects();
    }

    @Override
    public FluentWebElements objects(By by) {
        return (FluentWebElements)super.objects(by);
    }

    @Override
    public FluentWebElement nav() {
        return (FluentWebElement)super.nav();
    }

    @Override
    public FluentWebElement nav(By by) {
        return (FluentWebElement)super.nav(by);
    }

    @Override
    public FluentWebElements navs() {
        return (FluentWebElements)super.navs();
    }

    @Override
    public FluentWebElements navs(By by) {
        return (FluentWebElements)super.navs(by);
    }

    @Override
    public FluentWebElement tbody() {
        return (FluentWebElement)super.tbody();
    }

    @Override
    public FluentWebElement tbody(By by) {
        return (FluentWebElement)super.tbody(by);
    }

    @Override
    public FluentWebElements tbodys() {
        return (FluentWebElements)super.tbodys();
    }

    @Override
    public FluentWebElements tbodys(By by) {
        return (FluentWebElements)super.tbodys(by);
    }

    public FluentWebDriver.BooleanResultsAdapter hasMissing() {
        return new FluentWebDriver.BooleanResultsAdapter(this.delegate, this.currentElement, this.monitor, this.context).invert(true);
    }

    public FluentWebDriver.BooleanResultsAdapter has() {
        return new FluentWebDriver.BooleanResultsAdapter(this.delegate, this.currentElement, this.monitor, this.context).invert(false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Submit
    extends StaleElementRecoveringExecution<Boolean> {
        private Submit() {
        }

        @Override
        public Boolean execute() {
            FluentWebElement.this.currentElement.getFound().submit();
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SendKeys
    extends StaleElementRecoveringExecution<Boolean> {
        private final CharSequence[] keysToSend;

        public SendKeys(CharSequence ... keysToSend) {
            this.keysToSend = keysToSend;
        }

        @Override
        public Boolean execute() {
            FluentWebElement.this.currentElement.getFound().sendKeys(this.keysToSend);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IsSelected
    extends StaleElementRecoveringExecution<Boolean> {
        private IsSelected() {
        }

        @Override
        public Boolean execute() {
            return FluentWebElement.this.currentElement.getFound().isSelected();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IsEnabled
    extends StaleElementRecoveringExecution<Boolean> {
        private IsEnabled() {
        }

        @Override
        public Boolean execute() {
            return FluentWebElement.this.currentElement.getFound().isEnabled();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IfInvisibleWait
    extends StaleElementRecoveringExecution<Boolean> {
        private Period period;

        IfInvisibleWait(Period period) {
            this.period = period;
        }

        @Override
        public Boolean execute() {
            boolean visible = false;
            long endMillis = this.period.getEndMillis(System.currentTimeMillis());
            while (!visible && System.currentTimeMillis() < endMillis) {
                visible = FluentWebElement.this.currentElement.getFound().isDisplayed();
                try {
                    Thread.sleep(25L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return visible;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IsDisplayed
    extends StaleElementRecoveringExecution<Boolean> {
        private IsDisplayed() {
        }

        @Override
        public Boolean execute() {
            return FluentWebElement.this.currentElement.getFound().isDisplayed();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetLocation
    extends StaleElementRecoveringExecution<Point> {
        private GetLocation() {
        }

        @Override
        public Point execute() {
            return FluentWebElement.this.currentElement.getFound().getLocation();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetSize
    extends StaleElementRecoveringExecution<Dimension> {
        private GetSize() {
        }

        @Override
        public Dimension execute() {
            return FluentWebElement.this.currentElement.getFound().getSize();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetText
    extends StaleElementRecoveringExecution<String> {
        private TestableString.StringChanger[] stringChangers;

        public GetText(TestableString.StringChanger ... stringChangers) {
            this.stringChangers = stringChangers;
        }

        @Override
        public String execute() {
            String text = FluentWebElement.this.currentElement.getFound().getText();
            for (TestableString.StringChanger stringChanger : this.stringChangers) {
                text = stringChanger.chg(text);
            }
            return text;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetCssValue
    extends StaleElementRecoveringExecution<String> {
        private final String cssName;

        public GetCssValue(String cssName) {
            this.cssName = cssName;
        }

        @Override
        public String execute() {
            return FluentWebElement.this.currentElement.getFound().getCssValue(this.cssName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetAttribute
    extends StaleElementRecoveringExecution<String> {
        private final String attr;

        public GetAttribute(String attr) {
            this.attr = attr;
        }

        @Override
        public String execute() {
            try {
                return FluentWebElement.this.currentElement.getFound().getAttribute(this.attr);
            }
            catch (StaleElementReferenceException orig) {
                try {
                    FluentWebElement.this.currentElement.reFindElement();
                    return FluentWebElement.this.currentElement.getFound().getAttribute(this.attr);
                }
                catch (StaleElementReferenceException e) {
                    throw orig;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class StaleElementRecoveringExecution<T>
    extends Execution<T> {
        private StaleElementRecoveringExecution() {
        }

        @Override
        public T doExecution() {
            try {
                return this.execute();
            }
            catch (StaleElementReferenceException orig) {
                try {
                    FluentWebElement.this.currentElement.reFindElement();
                    return this.execute();
                }
                catch (WebDriverException e) {
                    throw orig;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Click
    extends StaleElementRecoveringExecution<Boolean> {
        private Click() {
        }

        @Override
        public Boolean execute() {
            FluentWebElement.this.currentElement.getFound().click();
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetTagName
    extends StaleElementRecoveringExecution<String> {
        private GetTagName() {
        }

        @Override
        public String execute() {
            return FluentWebElement.this.currentElement.getFound().getTagName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Clear
    extends StaleElementRecoveringExecution<Boolean> {
        private Clear() {
        }

        @Override
        public Boolean execute() {
            FluentWebElement.this.currentElement.getFound().clear();
            return true;
        }
    }

    public static class NegatingFluentWebElement {
        private final Internal.BaseFluentWebElement delegate;
        private final Period duration;
        private final Long startedAt;

        protected NegatingFluentWebElement(WebDriver delegate, Internal.WebElementHolder currentElement, Period duration, Context context, Monitor monitor, boolean booleanInsteadOfNoSuchElement) {
            this.delegate = new FluentWebElement(delegate, currentElement, context, monitor, booleanInsteadOfNoSuchElement){

                @Override
                protected <T> T executeAndWrapReThrowIfNeeded(Execution<T> execution, Internal.WebElementHolder currentElement, Context ctx, boolean expectedToBeThere) {
                    T successfullyAbsent = null;
                    while (!NegatingFluentWebElement.this.durationHasElapsed(NegatingFluentWebElement.this.startedAt).booleanValue()) {
                        try {
                            super.executeAndWrapReThrowIfNeeded(execution, currentElement, ctx, false);
                        }
                        catch (FluentExecutionStopped executionStopped) {
                            boolean elementGone = executionStopped.getCause() instanceof NotFoundException;
                            if (!elementGone) continue;
                            return successfullyAbsent;
                        }
                    }
                    throw this.monitor.exceptionDuringExecution(1.wrapAssertionError(ctx, new AssertionError((Object)("Element never disappeared after: " + (System.currentTimeMillis() - NegatingFluentWebElement.this.startedAt)))), execution.getWebElement());
                }
            };
            this.duration = duration;
            this.startedAt = System.currentTimeMillis();
        }

        protected Boolean durationHasElapsed(Long startMillis) {
            return this.duration.getEndMillis(startMillis) <= System.currentTimeMillis();
        }

        public void element() {
            this.delegate.element();
        }

        public void element(By by) {
            this.delegate.element(by);
        }

        public void elements() {
            this.delegate.elements();
        }

        public void elements(By by) {
            this.delegate.elements(by);
        }

        public void span() {
            this.delegate.span();
        }

        public void span(By by) {
            this.delegate.span(by);
        }

        public void div() {
            this.delegate.div();
        }

        public void div(By by) {
            this.delegate.div(by);
        }

        public void button() {
            this.delegate.button();
        }

        public void button(By by) {
            this.delegate.button(by);
        }

        public void link() {
            this.delegate.link();
        }

        public void link(By by) {
            this.delegate.link(by);
        }

        public void input() {
            this.delegate.input();
        }

        public void input(By by) {
            this.delegate.input(by);
        }

        public void select() {
            this.delegate.select();
        }

        public void select(By by) {
            this.delegate.select(by);
        }

        public void h1() {
            this.delegate.h1();
        }

        public void h1(By by) {
            this.delegate.h1(by);
        }

        public void h2() {
            this.delegate.h2();
        }

        public void h2(By by) {
            this.delegate.h2(by);
        }

        public void h3() {
            this.delegate.h3();
        }

        public void h3(By by) {
            this.delegate.h3(by);
        }

        public void h4() {
            this.delegate.h4();
        }

        public void h4(By by) {
            this.delegate.h4(by);
        }

        public void p() {
            this.delegate.p();
        }

        public void p(By by) {
            this.delegate.p(by);
        }

        public void b() {
            this.delegate.b();
        }

        public void b(By by) {
            this.delegate.b(by);
        }

        public void pre() {
            this.delegate.pre();
        }

        public void pre(By by) {
            this.delegate.pre(by);
        }

        public void header() {
            this.delegate.header();
        }

        public void header(By by) {
            this.delegate.header(by);
        }

        public void footer() {
            this.delegate.footer();
        }

        public void footer(By by) {
            this.delegate.footer(by);
        }

        public void figure() {
            this.delegate.figure();
        }

        public void figure(By by) {
            this.delegate.figure(by);
        }

        public void acronym() {
            this.delegate.acronym();
        }

        public void acronym(By by) {
            this.delegate.acronym(by);
        }

        public void abbr() {
            this.delegate.abbr();
        }

        public void abbr(By by) {
            this.delegate.abbr(by);
        }

        public void address() {
            this.delegate.address();
        }

        public void address(By by) {
            this.delegate.address(by);
        }

        public void blockquote() {
            this.delegate.blockquote();
        }

        public void blockquote(By by) {
            this.delegate.blockquote(by);
        }

        public void area() {
            this.delegate.area();
        }

        public void area(By by) {
            this.delegate.area(by);
        }

        public void label() {
            this.delegate.label();
        }

        public void label(By by) {
            this.delegate.label(by);
        }

        public void object() {
            this.delegate.object();
        }

        public void object(By by) {
            this.delegate.object(by);
        }

        public void nav() {
            this.delegate.nav();
        }

        public void nav(By by) {
            this.delegate.nav(by);
        }

        public void tbody() {
            this.delegate.tbody();
        }

        public void tbody(By by) {
            this.delegate.tbody(by);
        }

        public void img() {
            this.delegate.img();
        }

        public void img(By by) {
            this.delegate.img(by);
        }

        public void table() {
            this.delegate.table();
        }

        public void table(By by) {
            this.delegate.table(by);
        }

        public void fieldset() {
            this.delegate.fieldset();
        }

        public void fieldset(By by) {
            this.delegate.fieldset(by);
        }

        public void legend() {
            this.delegate.legend();
        }

        public void legend(By by) {
            this.delegate.legend(by);
        }

        public void tr() {
            this.delegate.tr();
        }

        public void tr(By by) {
            this.delegate.tr(by);
        }

        public void td() {
            this.delegate.td();
        }

        public void td(By by) {
            this.delegate.td(by);
        }

        public void th() {
            this.delegate.th();
        }

        public void th(By by) {
            this.delegate.th(by);
        }

        public void ul() {
            this.delegate.ul();
        }

        public void ul(By by) {
            this.delegate.ul(by);
        }

        public void ol() {
            this.delegate.ol();
        }

        public void ol(By by) {
            this.delegate.ol(by);
        }

        public void form() {
            this.delegate.form();
        }

        public void form(By by) {
            this.delegate.form(by);
        }

        public void textarea() {
            this.delegate.textarea();
        }

        public void textarea(By by) {
            this.delegate.textarea(by);
        }

        public void option() {
            this.delegate.option();
        }

        public void option(By by) {
            this.delegate.option(by);
        }

        public void li() {
            this.delegate.li();
        }

        public void li(By by) {
            this.delegate.li(by);
        }

        public void map() {
            this.delegate.map();
        }

        public void map(By by) {
            this.delegate.map(by);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RetryingFluentWebElement
    extends FluentWebElement {
        private final Period period;

        public RetryingFluentWebElement(WebDriver webDriver, Internal.WebElementHolder currentElement, Context context, Period period, Monitor monitor, boolean booleanInsteadOfNoSuchElement) {
            super(webDriver, currentElement, context, monitor, booleanInsteadOfNoSuchElement);
            this.period = period;
        }

        @Override
        protected Period getPeriod() {
            return this.period;
        }

        @Override
        protected WebElement findElement(By by, Context ctx, SearchContext searchContext) {
            return this.retryingFindIt(by, searchContext);
        }

        @Override
        protected List<WebElement> findElements(By by, Context ctx) {
            return this.retryingFindThem(by);
        }

        @Override
        protected void changeTimeout() {
            this.delegate.manage().timeouts().implicitlyWait((long)this.period.howLong(), this.period.timeUnit());
        }

        @Override
        protected void resetTimeout() {
            this.delegate.manage().timeouts().implicitlyWait(0L, TimeUnit.SECONDS);
        }
    }
}

