/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent.monitors;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import org.seleniumhq.selenium.fluent.Monitor;

public class CodaHaleMetricsMonitor
extends Monitor.NULL {
    final MetricRegistry metrics = new MetricRegistry();
    private final String toStripFromClassName;
    private final String replaceWith;

    public CodaHaleMetricsMonitor(String toStripFromClassName, String replaceWith) {
        this.toStripFromClassName = toStripFromClassName;
        this.replaceWith = replaceWith;
    }

    public CodaHaleMetricsMonitor(String toStripFromClassName) {
        this(toStripFromClassName, "");
    }

    public Timer start(String item) {
        StackTraceElement[] elems = Thread.currentThread().getStackTrace();
        String prefix = "";
        for (StackTraceElement elem : elems) {
            if (!elem.getClassName().startsWith(this.toStripFromClassName)) continue;
            if (elem.getClassName().matches("(.*)\\$\\d+$")) {
                try {
                    Class<?> clazz = Class.forName(elem.getClassName());
                    if (!clazz.isAnonymousClass()) continue;
                    clazz = clazz.getSuperclass();
                    prefix = prefix + clazz.getName().replace(this.toStripFromClassName, "") + "." + elem.getMethodName() + ":";
                }
                catch (ClassNotFoundException classNotFoundException) {}
                continue;
            }
            prefix = elem.getClassName().replace(this.toStripFromClassName, this.replaceWith) + "." + elem.getMethodName() + ":" + prefix;
            break;
        }
        return new Timer(this.metrics.timer(prefix + item));
    }

    public MetricRegistry getMetrics() {
        return this.metrics;
    }

    public static class Timer
    implements Monitor.Timer {
        private final Timer.Context timing;

        public Timer(com.codahale.metrics.Timer timer) {
            this.timing = timer.time();
        }

        public void end(boolean success) {
            this.timing.stop();
        }
    }
}

