/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent.monitors;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.seleniumhq.selenium.fluent.FluentExecutionStopped;
import org.seleniumhq.selenium.fluent.Monitor;

public class ScreenShotOnError
extends Monitor.NULL {
    private final String path;
    private TakesScreenshot webDriver;
    private String context;

    public ScreenShotOnError(TakesScreenshot webDriver, Class classCloseToOutputPath, String pathFrom, String pathTo) {
        this.webDriver = webDriver;
        this.path = classCloseToOutputPath.getProtectionDomain().getCodeSource().getLocation().getPath().replace(pathFrom, pathTo);
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getContext() {
        return this.context;
    }

    public FluentExecutionStopped exceptionDuringExecution(FluentExecutionStopped ex, WebElement webElement) {
        String pathname = this.path + this.getContext() + "_screenshot.png";
        try {
            File scrFile = (File)this.webDriver.getScreenshotAs(OutputType.FILE);
            FileUtils.copyFile((File)scrFile, (File)new File(pathname));
        }
        catch (WebDriverException e) {
            System.err.println("ScreenShotOnError: Can't get ScreenShot from WebDriver.");
        }
        catch (IOException e) {
            System.err.println("ScreenShotOnError: Can't write screenshot to '" + pathname + "'");
        }
        return ex;
    }

    public static class WithUnitTestFrameWorkContext
    extends ScreenShotOnError {
        public WithUnitTestFrameWorkContext(TakesScreenshot webDriver, Class classCloseToOutputPath, String pathFrom, String pathTo) {
            super(webDriver, classCloseToOutputPath, pathFrom, pathTo);
        }

        public String getContext() {
            StackTraceElement[] elems = Thread.currentThread().getStackTrace();
            StackTraceElement lastNonReflectionElem = null;
            for (StackTraceElement elem : elems) {
                String elemClassName = elem.getClassName();
                if (elemClassName.startsWith("org.junit.runners") || elemClassName.startsWith("org.testng.internal")) {
                    return lastNonReflectionElem.getClassName() + "." + lastNonReflectionElem.getMethodName();
                }
                if (elemClassName.startsWith("sun.reflect.") || elemClassName.startsWith("java.lang.reflect")) continue;
                lastNonReflectionElem = elem;
            }
            return this.getClass().getName() + "_Cant_Extract_JUnit_ClassName";
        }
    }
}

