/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import org.openqa.selenium.Keys;

class KeyboardModifiersState {
    private boolean shiftPressed = false;
    private boolean ctrlPressed = false;
    private boolean altPressed = false;

    KeyboardModifiersState() {
    }

    public boolean isShiftPressed() {
        return this.shiftPressed;
    }

    public boolean isCtrlPressed() {
        return this.ctrlPressed;
    }

    public boolean isAltPressed() {
        return this.altPressed;
    }

    public void storeKeyDown(char key) {
        this.storeIfEqualsShift(key, true);
        this.storeIfEqualsCtrl(key, true);
        this.storeIfEqualsAlt(key, true);
    }

    public void storeKeyUp(char key) {
        this.storeIfEqualsShift(key, false);
        this.storeIfEqualsCtrl(key, false);
        this.storeIfEqualsAlt(key, false);
    }

    private void storeIfEqualsShift(char key, boolean keyState) {
        if (key == Keys.SHIFT.charAt(0)) {
            this.shiftPressed = keyState;
        }
    }

    private void storeIfEqualsCtrl(char key, boolean keyState) {
        if (key == Keys.CONTROL.charAt(0)) {
            this.ctrlPressed = keyState;
        }
    }

    private void storeIfEqualsAlt(char key, boolean keyState) {
        if (key == Keys.ALT.charAt(0)) {
            this.altPressed = keyState;
        }
    }
}

