/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.interactions;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.openqa.selenium.interactions.Encodable;
import org.openqa.selenium.interactions.InputSource;
import org.openqa.selenium.interactions.Interaction;
import org.openqa.selenium.interactions.SourceType;

public class KeyInput
implements InputSource,
Encodable {
    private final String name;

    public KeyInput(String name) {
        this.name = Optional.ofNullable(name).orElse(UUID.randomUUID().toString());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SourceType getInputType() {
        return SourceType.KEY;
    }

    public Interaction createKeyDown(int codePoint) {
        return new TypingInteraction(this, "keyDown", codePoint);
    }

    public Interaction createKeyUp(int codePoint) {
        return new TypingInteraction(this, "keyUp", codePoint);
    }

    @Override
    public Map<String, Object> encode() {
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        toReturn.put("type", this.getInputType().getType());
        toReturn.put("id", this.name);
        return toReturn;
    }

    private static class TypingInteraction
    extends Interaction
    implements Encodable {
        private final String type;
        private final String value;

        TypingInteraction(InputSource source, String type, int codePoint) {
            super(source);
            this.type = type;
            this.value = new StringBuilder().appendCodePoint(codePoint).toString();
        }

        @Override
        public Map<String, Object> encode() {
            HashMap<String, Object> toReturn = new HashMap<String, Object>();
            toReturn.put("type", this.type);
            toReturn.put("value", this.value);
            return toReturn;
        }
    }
}

