/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.logging;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class LogLevelMapping {
    private static final String DEBUG = "DEBUG";
    private static final Level DEFAULT_LEVEL = Level.INFO;
    private static final Map<Integer, Level> levelMap;

    public static Level normalize(Level level) {
        if (levelMap.containsKey(level.intValue())) {
            return levelMap.get(level.intValue());
        }
        if (level.intValue() >= Level.SEVERE.intValue()) {
            return Level.SEVERE;
        }
        if (level.intValue() >= Level.WARNING.intValue()) {
            return Level.WARNING;
        }
        if (level.intValue() >= Level.INFO.intValue()) {
            return Level.INFO;
        }
        return Level.FINE;
    }

    public static String getName(Level level) {
        Level normalized = LogLevelMapping.normalize(level);
        return normalized == Level.FINE ? DEBUG : normalized.getName();
    }

    public static Level toLevel(@Nullable String logLevelName) {
        if (logLevelName == null || logLevelName.isEmpty()) {
            return DEFAULT_LEVEL;
        }
        if (logLevelName.equals(DEBUG)) {
            return Level.FINE;
        }
        return Optional.ofNullable(levelMap.get(Level.parse(logLevelName).intValue())).orElse(DEFAULT_LEVEL);
    }

    static {
        Level[] supportedLevels = new Level[]{Level.ALL, Level.FINE, Level.INFO, Level.WARNING, Level.SEVERE, Level.OFF};
        HashMap<Integer, Level> builder = new HashMap<Integer, Level>();
        for (Level level : supportedLevels) {
            builder.put(level.intValue(), level);
        }
        levelMap = Collections.unmodifiableMap(builder);
    }
}

