/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import com.google.auto.service.AutoService;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriverLogLevel;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.service.DriverService;

public class ChromeDriverService
extends DriverService {
    public static final String CHROME_DRIVER_EXE_PROPERTY = "webdriver.chrome.driver";
    public static final String CHROME_DRIVER_LOG_PROPERTY = "webdriver.chrome.logfile";
    public static final String CHROME_DRIVER_APPEND_LOG_PROPERTY = "webdriver.chrome.appendLog";
    public static final String CHROME_DRIVER_VERBOSE_LOG_PROPERTY = "webdriver.chrome.verboseLogging";
    public static final String CHROME_DRIVER_SILENT_OUTPUT_PROPERTY = "webdriver.chrome.silentOutput";
    public static final String CHROME_DRIVER_WHITELISTED_IPS_PROPERTY = "webdriver.chrome.whitelistedIps";
    public static final String CHROME_DRIVER_DISABLE_BUILD_CHECK = "webdriver.chrome.disableBuildCheck";

    public ChromeDriverService(File executable, int port, List<String> args, Map<String, String> environment) throws IOException {
        super(executable, port, DEFAULT_TIMEOUT, args, environment);
    }

    public ChromeDriverService(File executable, int port, Duration timeout, List<String> args, Map<String, String> environment) throws IOException {
        super(executable, port, timeout, args, environment);
    }

    public static ChromeDriverService createDefaultService() {
        return (ChromeDriverService)new Builder().build();
    }

    public static ChromeDriverService createServiceWithConfig(ChromeOptions options) {
        return (ChromeDriverService)new Builder().withLogLevel(options.getLogLevel()).build();
    }

    @AutoService(value={DriverService.Builder.class})
    public static class Builder
    extends DriverService.Builder<ChromeDriverService, Builder> {
        private boolean appendLog = Boolean.getBoolean("webdriver.chrome.appendLog");
        private boolean verbose = Boolean.getBoolean("webdriver.chrome.verboseLogging");
        private boolean silent = Boolean.getBoolean("webdriver.chrome.silentOutput");
        private String whitelistedIps = System.getProperty("webdriver.chrome.whitelistedIps");
        private boolean disableBuildCheck = Boolean.getBoolean("webdriver.chrome.disableBuildCheck");
        private ChromeDriverLogLevel logLevel = null;

        public int score(Capabilities capabilities) {
            int score = 0;
            if (Browser.CHROME.is(capabilities.getBrowserName())) {
                ++score;
            }
            if (capabilities.getCapability("goog:chromeOptions") != null) {
                ++score;
            }
            return score;
        }

        public Builder withAppendLog(boolean appendLog) {
            this.appendLog = appendLog;
            return this;
        }

        public Builder withVerbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder withLogLevel(ChromeDriverLogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder withSilent(boolean silent) {
            this.silent = silent;
            return this;
        }

        public Builder withWhitelistedIps(String whitelistedIps) {
            this.whitelistedIps = whitelistedIps;
            return this;
        }

        protected File findDefaultExecutable() {
            return ChromeDriverService.findExecutable((String)"chromedriver", (String)ChromeDriverService.CHROME_DRIVER_EXE_PROPERTY, (String)"https://github.com/SeleniumHQ/selenium/wiki/ChromeDriver", (String)"https://chromedriver.storage.googleapis.com/index.html");
        }

        protected List<String> createArgs() {
            String logFilePath;
            if (this.getLogFile() == null && (logFilePath = System.getProperty(ChromeDriverService.CHROME_DRIVER_LOG_PROPERTY)) != null) {
                this.withLogFile(new File(logFilePath));
            }
            if (this.logLevel != null) {
                this.withLogLevel(this.logLevel);
                this.withVerbose(false);
            }
            if (this.verbose) {
                this.withLogLevel(ChromeDriverLogLevel.ALL);
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add(String.format("--port=%d", this.getPort()));
            if (this.getLogFile() != null) {
                args.add(String.format("--log-path=%s", this.getLogFile().getAbsolutePath()));
            }
            if (this.appendLog) {
                args.add("--append-log");
            }
            if (this.logLevel != null) {
                args.add(String.format("--log-level=%s", this.logLevel.toString().toUpperCase()));
            }
            if (this.silent) {
                args.add("--silent");
            }
            if (this.whitelistedIps != null) {
                args.add(String.format("--whitelisted-ips=%s", this.whitelistedIps));
            }
            if (this.disableBuildCheck) {
                args.add("--disable-build-check");
            }
            return Collections.unmodifiableList(args);
        }

        protected ChromeDriverService createDriverService(File exe, int port, Duration timeout, List<String> args, Map<String, String> environment) {
            try {
                return new ChromeDriverService(exe, port, timeout, args, environment);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
    }
}

