/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v103.media.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.devtools.v103.media.model.PlayerErrorSourceLocation;
import org.openqa.selenium.json.JsonInput;

public class PlayerError {
    private final String errorType;
    private final Integer code;
    private final List<PlayerErrorSourceLocation> stack;
    private final List<PlayerError> cause;
    private final Map<String, Object> data;

    public PlayerError(String errorType, Integer code, List<PlayerErrorSourceLocation> stack, List<PlayerError> cause, Map<String, Object> data) {
        this.errorType = Objects.requireNonNull(errorType, "errorType is required");
        this.code = Objects.requireNonNull(code, "code is required");
        this.stack = Objects.requireNonNull(stack, "stack is required");
        this.cause = Objects.requireNonNull(cause, "cause is required");
        this.data = Objects.requireNonNull(data, "data is required");
    }

    public String getErrorType() {
        return this.errorType;
    }

    public Integer getCode() {
        return this.code;
    }

    public List<PlayerErrorSourceLocation> getStack() {
        return this.stack;
    }

    public List<PlayerError> getCause() {
        return this.cause;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    private static PlayerError fromJson(JsonInput input) {
        String errorType = null;
        Integer code = 0;
        List stack = null;
        List cause = null;
        Map data = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "errorType": {
                    errorType = input.nextString();
                    continue block14;
                }
                case "code": {
                    code = input.nextNumber().intValue();
                    continue block14;
                }
                case "stack": {
                    stack = (List)input.read(new TypeToken<List<PlayerErrorSourceLocation>>(){}.getType());
                    continue block14;
                }
                case "cause": {
                    cause = (List)input.read(new TypeToken<List<PlayerError>>(){}.getType());
                    continue block14;
                }
                case "data": {
                    data = (Map)input.read(new TypeToken<Map<String, Object>>(){}.getType());
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PlayerError(errorType, code, stack, cause, data);
    }
}

