/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v112.page.model;

import java.util.Arrays;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public enum SecureContextType {
    SECURE("Secure"),
    SECURELOCALHOST("SecureLocalhost"),
    INSECURESCHEME("InsecureScheme"),
    INSECUREANCESTOR("InsecureAncestor");

    private String value;

    private SecureContextType(String value) {
        this.value = value;
    }

    public static SecureContextType fromString(String s) {
        return Arrays.stream(SecureContextType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within SecureContextType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static SecureContextType fromJson(JsonInput input) {
        return SecureContextType.fromString(input.nextString());
    }
}

