/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v112.accessibility;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v112.accessibility.model.AXNode;
import org.openqa.selenium.devtools.v112.accessibility.model.AXNodeId;
import org.openqa.selenium.devtools.v112.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v112.dom.model.NodeId;
import org.openqa.selenium.devtools.v112.page.model.FrameId;
import org.openqa.selenium.devtools.v112.runtime.model.RemoteObjectId;

@Beta
public class Accessibility {
    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Accessibility.disable", (Map)params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Accessibility.enable", (Map)params.build());
    }

    @Beta
    public static Command<List<AXNode>> getPartialAXTree(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId, Optional<Boolean> fetchRelatives) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put((Object)"nodeId", p));
        backendNodeId.ifPresent(p -> params.put((Object)"backendNodeId", p));
        objectId.ifPresent(p -> params.put((Object)"objectId", p));
        fetchRelatives.ifPresent(p -> params.put((Object)"fetchRelatives", p));
        return new Command("Accessibility.getPartialAXTree", (Map)params.build(), ConverterFunctions.map((String)"nodes", (Type)new TypeToken<List<AXNode>>(){}.getType()));
    }

    @Beta
    public static Command<List<AXNode>> getFullAXTree(Optional<Integer> depth, Optional<FrameId> frameId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        depth.ifPresent(p -> params.put((Object)"depth", p));
        frameId.ifPresent(p -> params.put((Object)"frameId", p));
        return new Command("Accessibility.getFullAXTree", (Map)params.build(), ConverterFunctions.map((String)"nodes", (Type)new TypeToken<List<AXNode>>(){}.getType()));
    }

    @Beta
    public static Command<AXNode> getRootAXNode(Optional<FrameId> frameId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        frameId.ifPresent(p -> params.put((Object)"frameId", p));
        return new Command("Accessibility.getRootAXNode", (Map)params.build(), ConverterFunctions.map((String)"node", AXNode.class));
    }

    @Beta
    public static Command<List<AXNode>> getAXNodeAndAncestors(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put((Object)"nodeId", p));
        backendNodeId.ifPresent(p -> params.put((Object)"backendNodeId", p));
        objectId.ifPresent(p -> params.put((Object)"objectId", p));
        return new Command("Accessibility.getAXNodeAndAncestors", (Map)params.build(), ConverterFunctions.map((String)"nodes", (Type)new TypeToken<List<AXNode>>(){}.getType()));
    }

    @Beta
    public static Command<List<AXNode>> getChildAXNodes(AXNodeId id, Optional<FrameId> frameId) {
        Objects.requireNonNull(id, "id is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"id", (Object)id);
        frameId.ifPresent(p -> params.put((Object)"frameId", p));
        return new Command("Accessibility.getChildAXNodes", (Map)params.build(), ConverterFunctions.map((String)"nodes", (Type)new TypeToken<List<AXNode>>(){}.getType()));
    }

    @Beta
    public static Command<List<AXNode>> queryAXTree(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId, Optional<String> accessibleName, Optional<String> role) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put((Object)"nodeId", p));
        backendNodeId.ifPresent(p -> params.put((Object)"backendNodeId", p));
        objectId.ifPresent(p -> params.put((Object)"objectId", p));
        accessibleName.ifPresent(p -> params.put((Object)"accessibleName", p));
        role.ifPresent(p -> params.put((Object)"role", p));
        return new Command("Accessibility.queryAXTree", (Map)params.build(), ConverterFunctions.map((String)"nodes", (Type)new TypeToken<List<AXNode>>(){}.getType()));
    }

    public static Event<AXNode> loadComplete() {
        return new Event("Accessibility.loadComplete", ConverterFunctions.map((String)"root", AXNode.class));
    }

    public static Event<List<AXNode>> nodesUpdated() {
        return new Event("Accessibility.nodesUpdated", ConverterFunctions.map((String)"nodes", (Type)new TypeToken<List<AXNode>>(){}.getType()));
    }
}

