/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v112.page.model;

import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v112.page.model.FrameId;
import org.openqa.selenium.devtools.v112.page.model.PreloadingStatus;
import org.openqa.selenium.json.JsonInput;

@Beta
public class PrerenderStatusUpdated {
    private final FrameId initiatingFrameId;
    private final String prerenderingUrl;
    private final PreloadingStatus status;

    public PrerenderStatusUpdated(FrameId initiatingFrameId, String prerenderingUrl, PreloadingStatus status) {
        this.initiatingFrameId = Objects.requireNonNull(initiatingFrameId, "initiatingFrameId is required");
        this.prerenderingUrl = Objects.requireNonNull(prerenderingUrl, "prerenderingUrl is required");
        this.status = Objects.requireNonNull(status, "status is required");
    }

    public FrameId getInitiatingFrameId() {
        return this.initiatingFrameId;
    }

    public String getPrerenderingUrl() {
        return this.prerenderingUrl;
    }

    public PreloadingStatus getStatus() {
        return this.status;
    }

    private static PrerenderStatusUpdated fromJson(JsonInput input) {
        FrameId initiatingFrameId = null;
        String prerenderingUrl = null;
        PreloadingStatus status = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "initiatingFrameId": {
                    initiatingFrameId = (FrameId)input.read(FrameId.class);
                    continue block10;
                }
                case "prerenderingUrl": {
                    prerenderingUrl = input.nextString();
                    continue block10;
                }
                case "status": {
                    status = (PreloadingStatus)((Object)input.read(PreloadingStatus.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PrerenderStatusUpdated(initiatingFrameId, prerenderingUrl, status);
    }
}

