/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v115.indexeddb;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.v115.indexeddb.model.DataEntry;
import org.openqa.selenium.devtools.v115.indexeddb.model.DatabaseWithObjectStores;
import org.openqa.selenium.devtools.v115.indexeddb.model.KeyRange;
import org.openqa.selenium.devtools.v115.storage.model.StorageBucket;
import org.openqa.selenium.json.JsonInput;

@Beta
public class IndexedDB {
    public static Command<Void> clearObjectStore(Optional<String> securityOrigin, Optional<String> storageKey, Optional<StorageBucket> storageBucket, String databaseName, String objectStoreName) {
        Objects.requireNonNull(databaseName, "databaseName is required");
        Objects.requireNonNull(objectStoreName, "objectStoreName is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        securityOrigin.ifPresent(p -> params.put((Object)"securityOrigin", p));
        storageKey.ifPresent(p -> params.put((Object)"storageKey", p));
        storageBucket.ifPresent(p -> params.put((Object)"storageBucket", p));
        params.put((Object)"databaseName", (Object)databaseName);
        params.put((Object)"objectStoreName", (Object)objectStoreName);
        return new Command("IndexedDB.clearObjectStore", (Map)params.build());
    }

    public static Command<Void> deleteDatabase(Optional<String> securityOrigin, Optional<String> storageKey, Optional<StorageBucket> storageBucket, String databaseName) {
        Objects.requireNonNull(databaseName, "databaseName is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        securityOrigin.ifPresent(p -> params.put((Object)"securityOrigin", p));
        storageKey.ifPresent(p -> params.put((Object)"storageKey", p));
        storageBucket.ifPresent(p -> params.put((Object)"storageBucket", p));
        params.put((Object)"databaseName", (Object)databaseName);
        return new Command("IndexedDB.deleteDatabase", (Map)params.build());
    }

    public static Command<Void> deleteObjectStoreEntries(Optional<String> securityOrigin, Optional<String> storageKey, Optional<StorageBucket> storageBucket, String databaseName, String objectStoreName, KeyRange keyRange) {
        Objects.requireNonNull(databaseName, "databaseName is required");
        Objects.requireNonNull(objectStoreName, "objectStoreName is required");
        Objects.requireNonNull(keyRange, "keyRange is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        securityOrigin.ifPresent(p -> params.put((Object)"securityOrigin", p));
        storageKey.ifPresent(p -> params.put((Object)"storageKey", p));
        storageBucket.ifPresent(p -> params.put((Object)"storageBucket", p));
        params.put((Object)"databaseName", (Object)databaseName);
        params.put((Object)"objectStoreName", (Object)objectStoreName);
        params.put((Object)"keyRange", (Object)keyRange);
        return new Command("IndexedDB.deleteObjectStoreEntries", (Map)params.build());
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("IndexedDB.disable", (Map)params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("IndexedDB.enable", (Map)params.build());
    }

    public static Command<RequestDataResponse> requestData(Optional<String> securityOrigin, Optional<String> storageKey, Optional<StorageBucket> storageBucket, String databaseName, String objectStoreName, String indexName, Integer skipCount, Integer pageSize, Optional<KeyRange> keyRange) {
        Objects.requireNonNull(databaseName, "databaseName is required");
        Objects.requireNonNull(objectStoreName, "objectStoreName is required");
        Objects.requireNonNull(indexName, "indexName is required");
        Objects.requireNonNull(skipCount, "skipCount is required");
        Objects.requireNonNull(pageSize, "pageSize is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        securityOrigin.ifPresent(p -> params.put((Object)"securityOrigin", p));
        storageKey.ifPresent(p -> params.put((Object)"storageKey", p));
        storageBucket.ifPresent(p -> params.put((Object)"storageBucket", p));
        params.put((Object)"databaseName", (Object)databaseName);
        params.put((Object)"objectStoreName", (Object)objectStoreName);
        params.put((Object)"indexName", (Object)indexName);
        params.put((Object)"skipCount", (Object)skipCount);
        params.put((Object)"pageSize", (Object)pageSize);
        keyRange.ifPresent(p -> params.put((Object)"keyRange", p));
        return new Command("IndexedDB.requestData", (Map)params.build(), input -> (RequestDataResponse)input.read(RequestDataResponse.class));
    }

    public static Command<GetMetadataResponse> getMetadata(Optional<String> securityOrigin, Optional<String> storageKey, Optional<StorageBucket> storageBucket, String databaseName, String objectStoreName) {
        Objects.requireNonNull(databaseName, "databaseName is required");
        Objects.requireNonNull(objectStoreName, "objectStoreName is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        securityOrigin.ifPresent(p -> params.put((Object)"securityOrigin", p));
        storageKey.ifPresent(p -> params.put((Object)"storageKey", p));
        storageBucket.ifPresent(p -> params.put((Object)"storageBucket", p));
        params.put((Object)"databaseName", (Object)databaseName);
        params.put((Object)"objectStoreName", (Object)objectStoreName);
        return new Command("IndexedDB.getMetadata", (Map)params.build(), input -> (GetMetadataResponse)input.read(GetMetadataResponse.class));
    }

    public static Command<DatabaseWithObjectStores> requestDatabase(Optional<String> securityOrigin, Optional<String> storageKey, Optional<StorageBucket> storageBucket, String databaseName) {
        Objects.requireNonNull(databaseName, "databaseName is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        securityOrigin.ifPresent(p -> params.put((Object)"securityOrigin", p));
        storageKey.ifPresent(p -> params.put((Object)"storageKey", p));
        storageBucket.ifPresent(p -> params.put((Object)"storageBucket", p));
        params.put((Object)"databaseName", (Object)databaseName);
        return new Command("IndexedDB.requestDatabase", (Map)params.build(), ConverterFunctions.map((String)"databaseWithObjectStores", DatabaseWithObjectStores.class));
    }

    public static Command<List<String>> requestDatabaseNames(Optional<String> securityOrigin, Optional<String> storageKey, Optional<StorageBucket> storageBucket) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        securityOrigin.ifPresent(p -> params.put((Object)"securityOrigin", p));
        storageKey.ifPresent(p -> params.put((Object)"storageKey", p));
        storageBucket.ifPresent(p -> params.put((Object)"storageBucket", p));
        return new Command("IndexedDB.requestDatabaseNames", (Map)params.build(), ConverterFunctions.map((String)"databaseNames", (Type)new TypeToken<List<String>>(){}.getType()));
    }

    public static class GetMetadataResponse {
        private final Number entriesCount;
        private final Number keyGeneratorValue;

        public GetMetadataResponse(Number entriesCount, Number keyGeneratorValue) {
            this.entriesCount = Objects.requireNonNull(entriesCount, "entriesCount is required");
            this.keyGeneratorValue = Objects.requireNonNull(keyGeneratorValue, "keyGeneratorValue is required");
        }

        public Number getEntriesCount() {
            return this.entriesCount;
        }

        public Number getKeyGeneratorValue() {
            return this.keyGeneratorValue;
        }

        private static GetMetadataResponse fromJson(JsonInput input) {
            Number entriesCount = 0;
            Number keyGeneratorValue = 0;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "entriesCount": {
                        entriesCount = input.nextNumber();
                        continue block8;
                    }
                    case "keyGeneratorValue": {
                        keyGeneratorValue = input.nextNumber();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetMetadataResponse(entriesCount, keyGeneratorValue);
        }
    }

    public static class RequestDataResponse {
        private final List<DataEntry> objectStoreDataEntries;
        private final Boolean hasMore;

        public RequestDataResponse(List<DataEntry> objectStoreDataEntries, Boolean hasMore) {
            this.objectStoreDataEntries = Objects.requireNonNull(objectStoreDataEntries, "objectStoreDataEntries is required");
            this.hasMore = Objects.requireNonNull(hasMore, "hasMore is required");
        }

        public List<DataEntry> getObjectStoreDataEntries() {
            return this.objectStoreDataEntries;
        }

        public Boolean getHasMore() {
            return this.hasMore;
        }

        private static RequestDataResponse fromJson(JsonInput input) {
            List objectStoreDataEntries = null;
            Boolean hasMore = false;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "objectStoreDataEntries": {
                        objectStoreDataEntries = (List)input.read(new TypeToken<List<DataEntry>>(){}.getType());
                        continue block8;
                    }
                    case "hasMore": {
                        hasMore = input.nextBoolean();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new RequestDataResponse(objectStoreDataEntries, hasMore);
        }
    }
}

