/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v118.dom.model;

import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v118.dom.model.NodeId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class PseudoElementRemoved {
    private final NodeId parentId;
    private final NodeId pseudoElementId;

    public PseudoElementRemoved(NodeId parentId, NodeId pseudoElementId) {
        this.parentId = Objects.requireNonNull(parentId, "parentId is required");
        this.pseudoElementId = Objects.requireNonNull(pseudoElementId, "pseudoElementId is required");
    }

    public NodeId getParentId() {
        return this.parentId;
    }

    public NodeId getPseudoElementId() {
        return this.pseudoElementId;
    }

    private static PseudoElementRemoved fromJson(JsonInput input) {
        NodeId parentId = null;
        NodeId pseudoElementId = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "parentId": {
                    parentId = (NodeId)input.read(NodeId.class);
                    continue block8;
                }
                case "pseudoElementId": {
                    pseudoElementId = (NodeId)input.read(NodeId.class);
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PseudoElementRemoved(parentId, pseudoElementId);
    }
}

