/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v119.headlessexperimental.model;

import java.util.Arrays;
import java.util.Optional;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public class ScreenshotParams {
    private final Optional<Format> format;
    private final Optional<Integer> quality;
    private final Optional<Boolean> optimizeForSpeed;

    public ScreenshotParams(Optional<Format> format, Optional<Integer> quality, Optional<Boolean> optimizeForSpeed) {
        this.format = format;
        this.quality = quality;
        this.optimizeForSpeed = optimizeForSpeed;
    }

    public Optional<Format> getFormat() {
        return this.format;
    }

    public Optional<Integer> getQuality() {
        return this.quality;
    }

    public Optional<Boolean> getOptimizeForSpeed() {
        return this.optimizeForSpeed;
    }

    private static ScreenshotParams fromJson(JsonInput input) {
        Optional<Format> format = Optional.empty();
        Optional<Integer> quality = Optional.empty();
        Optional<Boolean> optimizeForSpeed = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "format": {
                    format = Optional.ofNullable(Format.fromString(input.nextString()));
                    continue block10;
                }
                case "quality": {
                    quality = Optional.ofNullable(input.nextNumber().intValue());
                    continue block10;
                }
                case "optimizeForSpeed": {
                    optimizeForSpeed = Optional.ofNullable(input.nextBoolean());
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ScreenshotParams(format, quality, optimizeForSpeed);
    }

    public static enum Format {
        JPEG("jpeg"),
        PNG("png"),
        WEBP("webp");

        private String value;

        private Format(String value) {
            this.value = value;
        }

        public static Format fromString(String s) {
            return Arrays.stream(Format.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Format "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Format fromJson(JsonInput input) {
            return Format.fromString(input.nextString());
        }
    }
}

