/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v123.dom.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v123.dom.model.Node;
import org.openqa.selenium.devtools.v123.dom.model.NodeId;
import org.openqa.selenium.json.JsonInput;

public class ChildNodeInserted {
    private final NodeId parentNodeId;
    private final NodeId previousNodeId;
    private final Node node;

    public ChildNodeInserted(NodeId parentNodeId, NodeId previousNodeId, Node node) {
        this.parentNodeId = Objects.requireNonNull(parentNodeId, "parentNodeId is required");
        this.previousNodeId = Objects.requireNonNull(previousNodeId, "previousNodeId is required");
        this.node = Objects.requireNonNull(node, "node is required");
    }

    public NodeId getParentNodeId() {
        return this.parentNodeId;
    }

    public NodeId getPreviousNodeId() {
        return this.previousNodeId;
    }

    public Node getNode() {
        return this.node;
    }

    private static ChildNodeInserted fromJson(JsonInput input) {
        NodeId parentNodeId = null;
        NodeId previousNodeId = null;
        Node node = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "parentNodeId": {
                    parentNodeId = (NodeId)input.read(NodeId.class);
                    continue block10;
                }
                case "previousNodeId": {
                    previousNodeId = (NodeId)input.read(NodeId.class);
                    continue block10;
                }
                case "node": {
                    node = (Node)input.read(Node.class);
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ChildNodeInserted(parentNodeId, previousNodeId, node);
    }
}

