/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v123.layertree.model;

import java.util.Arrays;
import java.util.Objects;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.v123.dom.model.Rect;
import org.openqa.selenium.json.JsonInput;

public class ScrollRect {
    private final Rect rect;
    private final Type type;

    public ScrollRect(Rect rect, Type type) {
        this.rect = Objects.requireNonNull(rect, "rect is required");
        this.type = Objects.requireNonNull(type, "type is required");
    }

    public Rect getRect() {
        return this.rect;
    }

    public Type getType() {
        return this.type;
    }

    private static ScrollRect fromJson(JsonInput input) {
        Rect rect = null;
        Type type = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "rect": {
                    rect = (Rect)input.read(Rect.class);
                    continue block8;
                }
                case "type": {
                    type = Type.fromString(input.nextString());
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ScrollRect(rect, type);
    }

    public static enum Type {
        REPAINTSONSCROLL("RepaintsOnScroll"),
        TOUCHEVENTHANDLER("TouchEventHandler"),
        WHEELEVENTHANDLER("WheelEventHandler");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s) {
            return Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Type "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Type fromJson(JsonInput input) {
            return Type.fromString(input.nextString());
        }
    }
}

