/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v124.css.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@Beta
public class CSSLayerData {
    private final String name;
    private final Optional<List<CSSLayerData>> subLayers;
    private final Number order;

    public CSSLayerData(String name, Optional<List<CSSLayerData>> subLayers, Number order) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.subLayers = subLayers;
        this.order = Objects.requireNonNull(order, "order is required");
    }

    public String getName() {
        return this.name;
    }

    public Optional<List<CSSLayerData>> getSubLayers() {
        return this.subLayers;
    }

    public Number getOrder() {
        return this.order;
    }

    private static CSSLayerData fromJson(JsonInput input) {
        String name = null;
        Optional<List<CSSLayerData>> subLayers = Optional.empty();
        Number order = 0;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = input.nextString();
                    continue block10;
                }
                case "subLayers": {
                    subLayers = Optional.ofNullable(input.readArray(CSSLayerData.class));
                    continue block10;
                }
                case "order": {
                    order = input.nextNumber();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CSSLayerData(name, subLayers, order);
    }
}

