/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v124.css.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v124.css.model.SourceRange;
import org.openqa.selenium.json.JsonInput;

public class MediaQueryExpression {
    private final Number value;
    private final String unit;
    private final String feature;
    private final Optional<SourceRange> valueRange;
    private final Optional<Number> computedLength;

    public MediaQueryExpression(Number value, String unit, String feature, Optional<SourceRange> valueRange, Optional<Number> computedLength) {
        this.value = Objects.requireNonNull(value, "value is required");
        this.unit = Objects.requireNonNull(unit, "unit is required");
        this.feature = Objects.requireNonNull(feature, "feature is required");
        this.valueRange = valueRange;
        this.computedLength = computedLength;
    }

    public Number getValue() {
        return this.value;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getFeature() {
        return this.feature;
    }

    public Optional<SourceRange> getValueRange() {
        return this.valueRange;
    }

    public Optional<Number> getComputedLength() {
        return this.computedLength;
    }

    private static MediaQueryExpression fromJson(JsonInput input) {
        Number value = 0;
        String unit = null;
        String feature = null;
        Optional<SourceRange> valueRange = Optional.empty();
        Optional<Number> computedLength = Optional.empty();
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "value": {
                    value = input.nextNumber();
                    continue block14;
                }
                case "unit": {
                    unit = input.nextString();
                    continue block14;
                }
                case "feature": {
                    feature = input.nextString();
                    continue block14;
                }
                case "valueRange": {
                    valueRange = Optional.ofNullable((SourceRange)input.read(SourceRange.class));
                    continue block14;
                }
                case "computedLength": {
                    computedLength = Optional.ofNullable(input.nextNumber());
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new MediaQueryExpression(value, unit, feature, valueRange, computedLength);
    }
}

