/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v132.dom.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v132.dom.model.NodeId;
import org.openqa.selenium.json.JsonInput;

public class ChildNodeCountUpdated {
    private final NodeId nodeId;
    private final Integer childNodeCount;

    public ChildNodeCountUpdated(NodeId nodeId, Integer childNodeCount) {
        this.nodeId = Objects.requireNonNull(nodeId, "nodeId is required");
        this.childNodeCount = Objects.requireNonNull(childNodeCount, "childNodeCount is required");
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public Integer getChildNodeCount() {
        return this.childNodeCount;
    }

    private static ChildNodeCountUpdated fromJson(JsonInput input) {
        NodeId nodeId = null;
        Integer childNodeCount = 0;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "nodeId": {
                    nodeId = (NodeId)input.read(NodeId.class);
                    continue block8;
                }
                case "childNodeCount": {
                    childNodeCount = input.nextNumber().intValue();
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ChildNodeCountUpdated(nodeId, childNodeCount);
    }
}

