/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.applicationcache;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v85.applicationcache.model.ApplicationCacheStatusUpdated;
import org.openqa.selenium.devtools.v85.applicationcache.model.FrameWithManifest;
import org.openqa.selenium.devtools.v85.page.model.FrameId;

@Beta
public class ApplicationCache {
    public static Command<Void> enable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("ApplicationCache.enable", Map.copyOf(params));
    }

    public static Command<org.openqa.selenium.devtools.v85.applicationcache.model.ApplicationCache> getApplicationCacheForFrame(FrameId frameId) {
        Objects.requireNonNull(frameId, "frameId is required");
        LinkedHashMap<String, FrameId> params = new LinkedHashMap<String, FrameId>();
        params.put("frameId", frameId);
        return new Command("ApplicationCache.getApplicationCacheForFrame", Map.copyOf(params), ConverterFunctions.map((String)"applicationCache", org.openqa.selenium.devtools.v85.applicationcache.model.ApplicationCache.class));
    }

    public static Command<List<FrameWithManifest>> getFramesWithManifests() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("ApplicationCache.getFramesWithManifests", Map.copyOf(params), ConverterFunctions.map((String)"frameIds", List.class));
    }

    public static Command<String> getManifestForFrame(FrameId frameId) {
        Objects.requireNonNull(frameId, "frameId is required");
        LinkedHashMap<String, FrameId> params = new LinkedHashMap<String, FrameId>();
        params.put("frameId", frameId);
        return new Command("ApplicationCache.getManifestForFrame", Map.copyOf(params), ConverterFunctions.map((String)"manifestURL", String.class));
    }

    public static Event<ApplicationCacheStatusUpdated> applicationCacheStatusUpdated() {
        return new Event("ApplicationCache.applicationCacheStatusUpdated", input -> (ApplicationCacheStatusUpdated)input.read(ApplicationCacheStatusUpdated.class));
    }

    public static Event<Boolean> networkStateUpdated() {
        return new Event("ApplicationCache.networkStateUpdated", ConverterFunctions.map((String)"isNowOnline", Boolean.class));
    }
}

