/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.css;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v85.css.model.CSSComputedStyleProperty;
import org.openqa.selenium.devtools.v85.css.model.CSSKeyframesRule;
import org.openqa.selenium.devtools.v85.css.model.CSSMedia;
import org.openqa.selenium.devtools.v85.css.model.CSSRule;
import org.openqa.selenium.devtools.v85.css.model.CSSStyle;
import org.openqa.selenium.devtools.v85.css.model.CSSStyleSheetHeader;
import org.openqa.selenium.devtools.v85.css.model.FontFace;
import org.openqa.selenium.devtools.v85.css.model.InheritedStyleEntry;
import org.openqa.selenium.devtools.v85.css.model.PlatformFontUsage;
import org.openqa.selenium.devtools.v85.css.model.PseudoElementMatches;
import org.openqa.selenium.devtools.v85.css.model.RuleMatch;
import org.openqa.selenium.devtools.v85.css.model.RuleUsage;
import org.openqa.selenium.devtools.v85.css.model.SelectorList;
import org.openqa.selenium.devtools.v85.css.model.SourceRange;
import org.openqa.selenium.devtools.v85.css.model.StyleDeclarationEdit;
import org.openqa.selenium.devtools.v85.css.model.StyleSheetId;
import org.openqa.selenium.devtools.v85.css.model.Value;
import org.openqa.selenium.devtools.v85.dom.model.NodeId;
import org.openqa.selenium.devtools.v85.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class CSS {
    public static Command<CSSRule> addRule(StyleSheetId styleSheetId, String ruleText, SourceRange location) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        Objects.requireNonNull(ruleText, "ruleText is required");
        Objects.requireNonNull(location, "location is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"styleSheetId", (Object)styleSheetId);
        params.put((Object)"ruleText", (Object)ruleText);
        params.put((Object)"location", (Object)location);
        return new Command("CSS.addRule", (Map)params.build(), ConverterFunctions.map((String)"rule", CSSRule.class));
    }

    public static Command<List<String>> collectClassNames(StyleSheetId styleSheetId) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"styleSheetId", (Object)styleSheetId);
        return new Command("CSS.collectClassNames", (Map)params.build(), ConverterFunctions.map((String)"classNames", (Type)new TypeToken<List<String>>(){}.getType()));
    }

    public static Command<StyleSheetId> createStyleSheet(FrameId frameId) {
        Objects.requireNonNull(frameId, "frameId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"frameId", (Object)frameId);
        return new Command("CSS.createStyleSheet", (Map)params.build(), ConverterFunctions.map((String)"styleSheetId", StyleSheetId.class));
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("CSS.disable", (Map)params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("CSS.enable", (Map)params.build());
    }

    public static Command<Void> forcePseudoState(NodeId nodeId, List<String> forcedPseudoClasses) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(forcedPseudoClasses, "forcedPseudoClasses is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"forcedPseudoClasses", forcedPseudoClasses);
        return new Command("CSS.forcePseudoState", (Map)params.build());
    }

    public static Command<GetBackgroundColorsResponse> getBackgroundColors(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        return new Command("CSS.getBackgroundColors", (Map)params.build(), input -> (GetBackgroundColorsResponse)input.read(GetBackgroundColorsResponse.class));
    }

    public static Command<List<CSSComputedStyleProperty>> getComputedStyleForNode(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        return new Command("CSS.getComputedStyleForNode", (Map)params.build(), ConverterFunctions.map((String)"computedStyle", (Type)new TypeToken<List<CSSComputedStyleProperty>>(){}.getType()));
    }

    public static Command<GetInlineStylesForNodeResponse> getInlineStylesForNode(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        return new Command("CSS.getInlineStylesForNode", (Map)params.build(), input -> (GetInlineStylesForNodeResponse)input.read(GetInlineStylesForNodeResponse.class));
    }

    public static Command<GetMatchedStylesForNodeResponse> getMatchedStylesForNode(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        return new Command("CSS.getMatchedStylesForNode", (Map)params.build(), input -> (GetMatchedStylesForNodeResponse)input.read(GetMatchedStylesForNodeResponse.class));
    }

    public static Command<List<CSSMedia>> getMediaQueries() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("CSS.getMediaQueries", (Map)params.build(), ConverterFunctions.map((String)"medias", (Type)new TypeToken<List<CSSMedia>>(){}.getType()));
    }

    public static Command<List<PlatformFontUsage>> getPlatformFontsForNode(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        return new Command("CSS.getPlatformFontsForNode", (Map)params.build(), ConverterFunctions.map((String)"fonts", (Type)new TypeToken<List<PlatformFontUsage>>(){}.getType()));
    }

    public static Command<String> getStyleSheetText(StyleSheetId styleSheetId) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"styleSheetId", (Object)styleSheetId);
        return new Command("CSS.getStyleSheetText", (Map)params.build(), ConverterFunctions.map((String)"text", String.class));
    }

    public static Command<Void> setEffectivePropertyValueForNode(NodeId nodeId, String propertyName, String value) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(propertyName, "propertyName is required");
        Objects.requireNonNull(value, "value is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"propertyName", (Object)propertyName);
        params.put((Object)"value", (Object)value);
        return new Command("CSS.setEffectivePropertyValueForNode", (Map)params.build());
    }

    public static Command<Value> setKeyframeKey(StyleSheetId styleSheetId, SourceRange range, String keyText) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        Objects.requireNonNull(range, "range is required");
        Objects.requireNonNull(keyText, "keyText is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"styleSheetId", (Object)styleSheetId);
        params.put((Object)"range", (Object)range);
        params.put((Object)"keyText", (Object)keyText);
        return new Command("CSS.setKeyframeKey", (Map)params.build(), ConverterFunctions.map((String)"keyText", Value.class));
    }

    public static Command<CSSMedia> setMediaText(StyleSheetId styleSheetId, SourceRange range, String text) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        Objects.requireNonNull(range, "range is required");
        Objects.requireNonNull(text, "text is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"styleSheetId", (Object)styleSheetId);
        params.put((Object)"range", (Object)range);
        params.put((Object)"text", (Object)text);
        return new Command("CSS.setMediaText", (Map)params.build(), ConverterFunctions.map((String)"media", CSSMedia.class));
    }

    public static Command<SelectorList> setRuleSelector(StyleSheetId styleSheetId, SourceRange range, String selector) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        Objects.requireNonNull(range, "range is required");
        Objects.requireNonNull(selector, "selector is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"styleSheetId", (Object)styleSheetId);
        params.put((Object)"range", (Object)range);
        params.put((Object)"selector", (Object)selector);
        return new Command("CSS.setRuleSelector", (Map)params.build(), ConverterFunctions.map((String)"selectorList", SelectorList.class));
    }

    public static Command<String> setStyleSheetText(StyleSheetId styleSheetId, String text) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        Objects.requireNonNull(text, "text is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"styleSheetId", (Object)styleSheetId);
        params.put((Object)"text", (Object)text);
        return new Command("CSS.setStyleSheetText", (Map)params.build(), ConverterFunctions.map((String)"sourceMapURL", String.class));
    }

    public static Command<List<CSSStyle>> setStyleTexts(List<StyleDeclarationEdit> edits) {
        Objects.requireNonNull(edits, "edits is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"edits", edits);
        return new Command("CSS.setStyleTexts", (Map)params.build(), ConverterFunctions.map((String)"styles", (Type)new TypeToken<List<CSSStyle>>(){}.getType()));
    }

    public static Command<Void> startRuleUsageTracking() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("CSS.startRuleUsageTracking", (Map)params.build());
    }

    public static Command<List<RuleUsage>> stopRuleUsageTracking() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("CSS.stopRuleUsageTracking", (Map)params.build(), ConverterFunctions.map((String)"ruleUsage", (Type)new TypeToken<List<RuleUsage>>(){}.getType()));
    }

    public static Command<TakeCoverageDeltaResponse> takeCoverageDelta() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("CSS.takeCoverageDelta", (Map)params.build(), input -> (TakeCoverageDeltaResponse)input.read(TakeCoverageDeltaResponse.class));
    }

    public static Event<FontFace> fontsUpdated() {
        return new Event("CSS.fontsUpdated", ConverterFunctions.map((String)"font", FontFace.class));
    }

    public static Event<Void> mediaQueryResultChanged() {
        return new Event("CSS.mediaQueryResultChanged", input -> null);
    }

    public static Event<CSSStyleSheetHeader> styleSheetAdded() {
        return new Event("CSS.styleSheetAdded", ConverterFunctions.map((String)"header", CSSStyleSheetHeader.class));
    }

    public static Event<StyleSheetId> styleSheetChanged() {
        return new Event("CSS.styleSheetChanged", ConverterFunctions.map((String)"styleSheetId", StyleSheetId.class));
    }

    public static Event<StyleSheetId> styleSheetRemoved() {
        return new Event("CSS.styleSheetRemoved", ConverterFunctions.map((String)"styleSheetId", StyleSheetId.class));
    }

    public static class TakeCoverageDeltaResponse {
        private final List<RuleUsage> coverage;
        private final Number timestamp;

        public TakeCoverageDeltaResponse(List<RuleUsage> coverage, Number timestamp) {
            this.coverage = Objects.requireNonNull(coverage, "coverage is required");
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        }

        public List<RuleUsage> getCoverage() {
            return this.coverage;
        }

        public Number getTimestamp() {
            return this.timestamp;
        }

        private static TakeCoverageDeltaResponse fromJson(JsonInput input) {
            List coverage = null;
            Number timestamp = 0;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "coverage": {
                        coverage = (List)input.read(new TypeToken<List<RuleUsage>>(){}.getType());
                        continue block8;
                    }
                    case "timestamp": {
                        timestamp = input.nextNumber();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new TakeCoverageDeltaResponse(coverage, timestamp);
        }
    }

    public static class GetMatchedStylesForNodeResponse {
        private final Optional<CSSStyle> inlineStyle;
        private final Optional<CSSStyle> attributesStyle;
        private final Optional<List<RuleMatch>> matchedCSSRules;
        private final Optional<List<PseudoElementMatches>> pseudoElements;
        private final Optional<List<InheritedStyleEntry>> inherited;
        private final Optional<List<CSSKeyframesRule>> cssKeyframesRules;

        public GetMatchedStylesForNodeResponse(Optional<CSSStyle> inlineStyle, Optional<CSSStyle> attributesStyle, Optional<List<RuleMatch>> matchedCSSRules, Optional<List<PseudoElementMatches>> pseudoElements, Optional<List<InheritedStyleEntry>> inherited, Optional<List<CSSKeyframesRule>> cssKeyframesRules) {
            this.inlineStyle = inlineStyle;
            this.attributesStyle = attributesStyle;
            this.matchedCSSRules = matchedCSSRules;
            this.pseudoElements = pseudoElements;
            this.inherited = inherited;
            this.cssKeyframesRules = cssKeyframesRules;
        }

        public Optional<CSSStyle> getInlineStyle() {
            return this.inlineStyle;
        }

        public Optional<CSSStyle> getAttributesStyle() {
            return this.attributesStyle;
        }

        public Optional<List<RuleMatch>> getMatchedCSSRules() {
            return this.matchedCSSRules;
        }

        public Optional<List<PseudoElementMatches>> getPseudoElements() {
            return this.pseudoElements;
        }

        public Optional<List<InheritedStyleEntry>> getInherited() {
            return this.inherited;
        }

        public Optional<List<CSSKeyframesRule>> getCssKeyframesRules() {
            return this.cssKeyframesRules;
        }

        private static GetMatchedStylesForNodeResponse fromJson(JsonInput input) {
            Optional<CSSStyle> inlineStyle = Optional.empty();
            Optional<CSSStyle> attributesStyle = Optional.empty();
            Optional<List<RuleMatch>> matchedCSSRules = Optional.empty();
            Optional<List<PseudoElementMatches>> pseudoElements = Optional.empty();
            Optional<List<InheritedStyleEntry>> inherited = Optional.empty();
            Optional<List<CSSKeyframesRule>> cssKeyframesRules = Optional.empty();
            input.beginObject();
            block16: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "inlineStyle": {
                        inlineStyle = Optional.ofNullable((CSSStyle)input.read(CSSStyle.class));
                        continue block16;
                    }
                    case "attributesStyle": {
                        attributesStyle = Optional.ofNullable((CSSStyle)input.read(CSSStyle.class));
                        continue block16;
                    }
                    case "matchedCSSRules": {
                        matchedCSSRules = Optional.ofNullable((List)input.read(new TypeToken<List<RuleMatch>>(){}.getType()));
                        continue block16;
                    }
                    case "pseudoElements": {
                        pseudoElements = Optional.ofNullable((List)input.read(new TypeToken<List<PseudoElementMatches>>(){}.getType()));
                        continue block16;
                    }
                    case "inherited": {
                        inherited = Optional.ofNullable((List)input.read(new TypeToken<List<InheritedStyleEntry>>(){}.getType()));
                        continue block16;
                    }
                    case "cssKeyframesRules": {
                        cssKeyframesRules = Optional.ofNullable((List)input.read(new TypeToken<List<CSSKeyframesRule>>(){}.getType()));
                        continue block16;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetMatchedStylesForNodeResponse(inlineStyle, attributesStyle, matchedCSSRules, pseudoElements, inherited, cssKeyframesRules);
        }
    }

    public static class GetInlineStylesForNodeResponse {
        private final Optional<CSSStyle> inlineStyle;
        private final Optional<CSSStyle> attributesStyle;

        public GetInlineStylesForNodeResponse(Optional<CSSStyle> inlineStyle, Optional<CSSStyle> attributesStyle) {
            this.inlineStyle = inlineStyle;
            this.attributesStyle = attributesStyle;
        }

        public Optional<CSSStyle> getInlineStyle() {
            return this.inlineStyle;
        }

        public Optional<CSSStyle> getAttributesStyle() {
            return this.attributesStyle;
        }

        private static GetInlineStylesForNodeResponse fromJson(JsonInput input) {
            Optional<CSSStyle> inlineStyle = Optional.empty();
            Optional<CSSStyle> attributesStyle = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "inlineStyle": {
                        inlineStyle = Optional.ofNullable((CSSStyle)input.read(CSSStyle.class));
                        continue block8;
                    }
                    case "attributesStyle": {
                        attributesStyle = Optional.ofNullable((CSSStyle)input.read(CSSStyle.class));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetInlineStylesForNodeResponse(inlineStyle, attributesStyle);
        }
    }

    public static class GetBackgroundColorsResponse {
        private final Optional<List<String>> backgroundColors;
        private final Optional<String> computedFontSize;
        private final Optional<String> computedFontWeight;

        public GetBackgroundColorsResponse(Optional<List<String>> backgroundColors, Optional<String> computedFontSize, Optional<String> computedFontWeight) {
            this.backgroundColors = backgroundColors;
            this.computedFontSize = computedFontSize;
            this.computedFontWeight = computedFontWeight;
        }

        public Optional<List<String>> getBackgroundColors() {
            return this.backgroundColors;
        }

        public Optional<String> getComputedFontSize() {
            return this.computedFontSize;
        }

        public Optional<String> getComputedFontWeight() {
            return this.computedFontWeight;
        }

        private static GetBackgroundColorsResponse fromJson(JsonInput input) {
            Optional<List<String>> backgroundColors = Optional.empty();
            Optional<String> computedFontSize = Optional.empty();
            Optional<String> computedFontWeight = Optional.empty();
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "backgroundColors": {
                        backgroundColors = Optional.ofNullable((List)input.read(new TypeToken<List<String>>(){}.getType()));
                        continue block10;
                    }
                    case "computedFontSize": {
                        computedFontSize = Optional.ofNullable(input.nextString());
                        continue block10;
                    }
                    case "computedFontWeight": {
                        computedFontWeight = Optional.ofNullable(input.nextString());
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetBackgroundColorsResponse(backgroundColors, computedFontSize, computedFontWeight);
        }
    }
}

