/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v99.target.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v99.browser.model.BrowserContextID;
import org.openqa.selenium.devtools.v99.page.model.FrameId;
import org.openqa.selenium.devtools.v99.target.model.TargetID;
import org.openqa.selenium.json.JsonInput;

public class TargetInfo {
    private final TargetID targetId;
    private final String type;
    private final String title;
    private final String url;
    private final Boolean attached;
    private final Optional<TargetID> openerId;
    private final Boolean canAccessOpener;
    private final Optional<FrameId> openerFrameId;
    private final Optional<BrowserContextID> browserContextId;

    public TargetInfo(TargetID targetId, String type, String title, String url, Boolean attached, Optional<TargetID> openerId, Boolean canAccessOpener, Optional<FrameId> openerFrameId, Optional<BrowserContextID> browserContextId) {
        this.targetId = Objects.requireNonNull(targetId, "targetId is required");
        this.type = Objects.requireNonNull(type, "type is required");
        this.title = Objects.requireNonNull(title, "title is required");
        this.url = Objects.requireNonNull(url, "url is required");
        this.attached = Objects.requireNonNull(attached, "attached is required");
        this.openerId = openerId;
        this.canAccessOpener = Objects.requireNonNull(canAccessOpener, "canAccessOpener is required");
        this.openerFrameId = openerFrameId;
        this.browserContextId = browserContextId;
    }

    public TargetID getTargetId() {
        return this.targetId;
    }

    public String getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public Boolean getAttached() {
        return this.attached;
    }

    public Optional<TargetID> getOpenerId() {
        return this.openerId;
    }

    @Beta
    public Boolean getCanAccessOpener() {
        return this.canAccessOpener;
    }

    @Beta
    public Optional<FrameId> getOpenerFrameId() {
        return this.openerFrameId;
    }

    @Beta
    public Optional<BrowserContextID> getBrowserContextId() {
        return this.browserContextId;
    }

    private static TargetInfo fromJson(JsonInput input) {
        TargetID targetId = null;
        String type = null;
        String title = null;
        String url = null;
        Boolean attached = false;
        Optional<TargetID> openerId = Optional.empty();
        Boolean canAccessOpener = false;
        Optional<FrameId> openerFrameId = Optional.empty();
        Optional<BrowserContextID> browserContextId = Optional.empty();
        input.beginObject();
        block22: while (input.hasNext()) {
            switch (input.nextName()) {
                case "targetId": {
                    targetId = (TargetID)input.read(TargetID.class);
                    continue block22;
                }
                case "type": {
                    type = input.nextString();
                    continue block22;
                }
                case "title": {
                    title = input.nextString();
                    continue block22;
                }
                case "url": {
                    url = input.nextString();
                    continue block22;
                }
                case "attached": {
                    attached = input.nextBoolean();
                    continue block22;
                }
                case "openerId": {
                    openerId = Optional.ofNullable((TargetID)input.read(TargetID.class));
                    continue block22;
                }
                case "canAccessOpener": {
                    canAccessOpener = input.nextBoolean();
                    continue block22;
                }
                case "openerFrameId": {
                    openerFrameId = Optional.ofNullable((FrameId)input.read(FrameId.class));
                    continue block22;
                }
                case "browserContextId": {
                    browserContextId = Optional.ofNullable((BrowserContextID)input.read(BrowserContextID.class));
                    continue block22;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new TargetInfo(targetId, type, title, url, attached, openerId, canAccessOpener, openerFrameId, browserContextId);
    }
}

