/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.internal;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.RemoteWebElement;

public class WebElementToJsonConverter
implements Function<Object, Object> {
    @Override
    public Object apply(Object arg) {
        if (arg == null || arg instanceof String || arg instanceof Boolean || arg instanceof Number) {
            return arg;
        }
        while (arg instanceof WrapsElement) {
            arg = ((WrapsElement)arg).getWrappedElement();
        }
        if (arg instanceof RemoteWebElement) {
            return ImmutableMap.of((Object)Dialect.W3C.getEncodedElementKey(), (Object)((RemoteWebElement)((Object)arg)).getId());
        }
        if (arg.getClass().isArray()) {
            arg = WebElementToJsonConverter.arrayToList(arg);
        }
        if (arg instanceof Collection) {
            Collection args = arg;
            return args.stream().map(this).collect(Collectors.toList());
        }
        if (arg instanceof Map) {
            Map args = (Map)((Object)arg);
            HashMap<String, Object> converted = new HashMap<String, Object>(args.size());
            for (Map.Entry entry : args.entrySet()) {
                Object key = entry.getKey();
                if (!(key instanceof String)) {
                    throw new IllegalArgumentException("All keys in Map script arguments must be strings: " + key.getClass().getName());
                }
                converted.put((String)key, this.apply(entry.getValue()));
            }
            return converted;
        }
        throw new IllegalArgumentException("Argument is of an illegal type: " + arg.getClass().getName());
    }

    private static List<Object> arrayToList(Object array) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < Array.getLength(array); ++i) {
            list.add(Array.get(array, i));
        }
        return list;
    }
}

