/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.browsingcontext;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openqa.selenium.bidi.browsingcontext.Locator;
import org.openqa.selenium.bidi.script.RemoteReference;
import org.openqa.selenium.bidi.script.SerializationOptions;

public class LocateNodeParameters {
    private final Locator locator;
    private Optional<Long> maxNodeCount = Optional.empty();
    private Optional<String> sandbox = Optional.empty();
    private Optional<SerializationOptions> serializationOptions = Optional.empty();
    private Optional<List<RemoteReference>> startNodes = Optional.empty();

    public LocateNodeParameters(Locator locator) {
        this.locator = locator;
    }

    public LocateNodeParameters setMaxNodeCount(long maxNodeCount) {
        this.maxNodeCount = Optional.of(maxNodeCount);
        return this;
    }

    public LocateNodeParameters setSandbox(String sandbox) {
        this.sandbox = Optional.of(sandbox);
        return this;
    }

    public LocateNodeParameters setSerializationOptions(SerializationOptions options) {
        this.serializationOptions = Optional.of(options);
        return this;
    }

    public LocateNodeParameters setStartNodes(List<RemoteReference> startNodes) {
        this.startNodes = Optional.of(startNodes);
        return this;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("locator", this.locator.toMap());
        this.maxNodeCount.ifPresent(value -> map.put("maxNodeCount", value));
        this.sandbox.ifPresent(value -> map.put("sandbox", value));
        this.serializationOptions.ifPresent(value -> map.put("serializationOptions", value.toJson()));
        this.startNodes.ifPresent(value -> {
            ArrayList startNodesJson = new ArrayList();
            value.forEach(remoteNode -> startNodesJson.add(remoteNode.toJson()));
            map.put("startNodes", startNodesJson);
        });
        return map;
    }
}

