/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.auto.service.AutoService;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebDriverInfo;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.service.DriverFinder;
import org.openqa.selenium.remote.service.DriverService;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.safari.SafariDriverService;
import org.openqa.selenium.safari.SafariOptions;

@AutoService(value={WebDriverInfo.class})
public class SafariDriverInfo
implements WebDriverInfo {
    public String getDisplayName() {
        return "Safari";
    }

    public Capabilities getCanonicalCapabilities() {
        return new ImmutableCapabilities("browserName", (Object)Browser.SAFARI.browserName());
    }

    public boolean isSupporting(Capabilities capabilities) {
        if (Browser.SAFARI.is(capabilities)) {
            return true;
        }
        return capabilities.asMap().keySet().stream().anyMatch(key -> key.startsWith("safari:"));
    }

    public boolean isSupportingCdp() {
        return false;
    }

    public boolean isSupportingBiDi() {
        return false;
    }

    public boolean isAvailable() {
        try {
            if (Platform.getCurrent().is(Platform.MAC)) {
                DriverFinder.getPath((DriverService)SafariDriverService.createDefaultService(), (Capabilities)this.getCanonicalCapabilities());
                return true;
            }
            return false;
        }
        catch (IllegalStateException | WebDriverException e) {
            return false;
        }
    }

    public boolean isPresent() {
        try {
            if (Platform.getCurrent().is(Platform.MAC)) {
                DriverFinder.getPath((DriverService)SafariDriverService.createDefaultService(), (Capabilities)this.getCanonicalCapabilities(), (boolean)true);
                return true;
            }
            return false;
        }
        catch (IllegalStateException | WebDriverException e) {
            return false;
        }
    }

    public int getMaximumSimultaneousSessions() {
        return 1;
    }

    public Optional<WebDriver> createDriver(Capabilities capabilities) throws SessionNotCreatedException {
        if (!this.isAvailable()) {
            return Optional.empty();
        }
        return Optional.of(new SafariDriver(new SafariOptions().merge(capabilities)));
    }
}

