/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils.configuration;

import com.beust.jcommander.Parameter;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.annotations.Expose;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class StandaloneConfiguration {
    @Expose(serialize=false)
    @Parameter(names={"-avoidProxy"}, description="DO NOT USE: Hack to allow selenium 3.0 server run in SauceLabs", hidden=true)
    private boolean avoidProxy;
    @Expose(serialize=false)
    @Parameter(names={"-browserSideLog"}, description="DO NOT USE: Provided for compatibility with 2.0", hidden=true)
    private boolean browserSideLog;
    @Expose(serialize=false)
    @Parameter(names={"-captureLogsOnQuit"}, description="DO NOT USE: Provided for compatibility with 2.0", hidden=true)
    private boolean captureLogsOnQuit;
    @Expose(serialize=false)
    @Parameter(names={"--help", "-help", "-h"}, help=true, hidden=true, description="Displays this help")
    public boolean help;
    @Expose
    @Parameter(names={"-browserTimeout"}, description="<Integer> in seconds : number of seconds a browser session is allowed to hang (0 means indefinite) while a WebDriver command is running (example: driver.get(url)). If the timeout is reached while a WebDriver command is still processing, the session will quit. Minimum value is 60. Default is 0")
    public Integer browserTimeout;
    @Expose
    @Parameter(names={"-debug"}, description="<Boolean> : enables LogLevel.FINE. Default is false (if omitted)")
    public boolean debug;
    @Expose
    @Parameter(names={"-jettyThreads", "-jettyMaxThreads"}, description="<Integer> : max number of threads for Jetty. Default is 200")
    public Integer jettyMaxThreads;
    @Expose
    @Parameter(names={"-log"}, description="<String> filename : the filename to use for logging. If omitted, will log to STDOUT")
    public String log;
    @Expose
    @Parameter(names={"-port"}, description="<Integer> : the port number the server will use. Defaults to [4444]. When \"role\" is a set to [node], default is [5555]")
    public Integer port;
    @Expose
    @Parameter(names={"-role"}, description="<String> options are [hub], [node], or [standalone] : Default is [standalone]")
    public String role = "standalone";
    @Expose
    @Parameter(names={"-timeout", "-sessionTimeout"}, description="<Integer> in seconds : Specifies the timeout before the server automatically kills a session that hasn't had any activity in the last X seconds. The test slot will then be released for another test to use. This is typically used to take care of client crashes. For grid hub/node roles, cleanUpCycle must also be set. Default is 1800 (30 minutes)")
    public Integer timeout = 1800;

    public void merge(StandaloneConfiguration other) {
        if (this.isMergeAble(other.browserTimeout, this.browserTimeout)) {
            this.browserTimeout = other.browserTimeout;
        }
        if (this.isMergeAble(other.jettyMaxThreads, this.jettyMaxThreads)) {
            this.jettyMaxThreads = other.jettyMaxThreads;
        }
        if (this.isMergeAble(other.timeout, this.timeout)) {
            this.timeout = other.timeout;
        }
    }

    protected boolean isMergeAble(Object other, Object target) {
        if (other == null) {
            return false;
        }
        if (target == null) {
            return true;
        }
        if (!target.getClass().getSuperclass().getTypeName().equals(other.getClass().getSuperclass().getTypeName())) {
            return false;
        }
        if (target instanceof Collection) {
            return !((Collection)other).isEmpty();
        }
        if (target instanceof Map) {
            return !((Map)other).isEmpty();
        }
        return true;
    }

    public String toString(String format) {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.toString(format, "browserTimeout", this.browserTimeout));
        sb.append((CharSequence)this.toString(format, "debug", this.debug));
        sb.append((CharSequence)this.toString(format, "help", this.help));
        sb.append((CharSequence)this.toString(format, "jettyMaxThreads", this.jettyMaxThreads));
        sb.append((CharSequence)this.toString(format, "log", this.log));
        sb.append((CharSequence)this.toString(format, "port", this.port));
        sb.append((CharSequence)this.toString(format, "role", this.role));
        sb.append((CharSequence)this.toString(format, "timeout", this.timeout));
        return sb.toString();
    }

    public String toString() {
        return this.toString(" -%1$s %2$s");
    }

    public StringBuilder toString(String format, String name, Object value) {
        StringBuilder sb = new StringBuilder();
        List<Object> iterator = value instanceof List ? (List<Object>)value : Arrays.asList(value);
        for (Object e : iterator) {
            if (e == null || e instanceof Map && ((Map)e).isEmpty() || e instanceof Collection && ((Collection)e).isEmpty()) continue;
            sb.append(String.format(format, name, e));
        }
        return sb;
    }

    public JsonElement toJson() {
        GsonBuilder builder = new GsonBuilder();
        this.addJsonTypeAdapter(builder);
        return builder.excludeFieldsWithoutExposeAnnotation().create().toJsonTree((Object)this);
    }

    protected void addJsonTypeAdapter(GsonBuilder builder) {
    }
}

