/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.surefire;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.BatchSide;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.test.MutableTestPlan;
import org.sonar.api.test.TestCase;
import org.sonar.api.utils.ParsingUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.java.api.JavaResourceLocator;
import org.sonar.plugins.surefire.StaxParser;
import org.sonar.plugins.surefire.data.UnitTestClassReport;
import org.sonar.plugins.surefire.data.UnitTestIndex;
import org.sonar.plugins.surefire.data.UnitTestResult;
import org.sonar.squidbridge.api.AnalysisException;

@BatchSide
public class SurefireJavaParser {
    private static final Logger LOGGER = Loggers.get(SurefireJavaParser.class);
    private final ResourcePerspectives perspectives;
    private final JavaResourceLocator javaResourceLocator;

    public SurefireJavaParser(ResourcePerspectives perspectives, JavaResourceLocator javaResourceLocator) {
        this.perspectives = perspectives;
        this.javaResourceLocator = javaResourceLocator;
    }

    public void collect(SensorContext context, File reportsDir, boolean reportDirSetByUser) {
        File[] xmlFiles = SurefireJavaParser.getReports(reportsDir, reportDirSetByUser);
        if (xmlFiles.length > 0) {
            this.parseFiles(context, xmlFiles);
        }
    }

    private static File[] getReports(File dir, boolean reportDirSetByUser) {
        if (dir == null) {
            return new File[0];
        }
        if (!dir.isDirectory()) {
            if (reportDirSetByUser) {
                LOGGER.error("Reports path not found or is not a directory: " + dir.getAbsolutePath());
            }
            return new File[0];
        }
        File[] unitTestResultFiles = SurefireJavaParser.findXMLFilesStartingWith(dir, "TEST-");
        if (unitTestResultFiles.length == 0) {
            unitTestResultFiles = SurefireJavaParser.findXMLFilesStartingWith(dir, "TESTS-");
        }
        if (unitTestResultFiles.length == 0) {
            LOGGER.warn("Reports path contains no files matching TEST-.*.xml : " + dir.getAbsolutePath());
        }
        return unitTestResultFiles;
    }

    private static File[] findXMLFilesStartingWith(File dir, String fileNameStart) {
        return dir.listFiles((parentDir, name) -> name.startsWith(fileNameStart) && name.endsWith(".xml"));
    }

    private void parseFiles(SensorContext context, File[] reports) {
        UnitTestIndex index = new UnitTestIndex();
        SurefireJavaParser.parseFiles(reports, index);
        SurefireJavaParser.sanitize(index);
        this.save(index, context);
    }

    private static void parseFiles(File[] reports, UnitTestIndex index) {
        StaxParser parser = new StaxParser(index);
        for (File report : reports) {
            try {
                parser.parse(report);
            }
            catch (XMLStreamException e) {
                throw new AnalysisException("Fail to parse the Surefire report: " + report, (Throwable)e);
            }
        }
    }

    private static void sanitize(UnitTestIndex index) {
        for (String classname : index.getClassnames()) {
            if (!StringUtils.contains((String)classname, (String)"$")) continue;
            String parentClassName = StringUtils.substringBefore((String)classname, (String)"$");
            index.merge(classname, parentClassName);
        }
    }

    private void save(UnitTestIndex index, SensorContext context) {
        long negativeTimeTestNumber = 0L;
        for (Map.Entry<String, UnitTestClassReport> entry : index.getIndexByClassname().entrySet()) {
            UnitTestClassReport report = entry.getValue();
            if (report.getTests() <= 0) continue;
            negativeTimeTestNumber += report.getNegativeTimeTestNumber();
            InputFile resource = this.getUnitTestResource(entry.getKey());
            if (resource != null) {
                this.save(report, resource, context);
                continue;
            }
            LOGGER.warn("Resource not found: {}", (Object)entry.getKey());
        }
        if (negativeTimeTestNumber > 0L) {
            LOGGER.warn("There is {} test(s) reported with negative time by surefire, total duration may not be accurate.", (Object)negativeTimeTestNumber);
        }
    }

    private void save(UnitTestClassReport report, InputFile inputFile, SensorContext context) {
        double percentage;
        int testsCount = report.getTests() - report.getSkipped();
        SurefireJavaParser.saveMeasure(context, inputFile, CoreMetrics.SKIPPED_TESTS, report.getSkipped());
        SurefireJavaParser.saveMeasure(context, inputFile, CoreMetrics.TESTS, testsCount);
        SurefireJavaParser.saveMeasure(context, inputFile, CoreMetrics.TEST_ERRORS, report.getErrors());
        SurefireJavaParser.saveMeasure(context, inputFile, CoreMetrics.TEST_FAILURES, report.getFailures());
        SurefireJavaParser.saveMeasure(context, inputFile, CoreMetrics.TEST_EXECUTION_TIME, report.getDurationMilliseconds());
        double passedTests = (double)testsCount - (double)report.getErrors() - (double)report.getFailures();
        if (testsCount > 0 && !Double.isNaN(percentage = ParsingUtils.scaleValue((double)(passedTests * 100.0 / (double)testsCount)))) {
            context.newMeasure().forMetric((Metric)CoreMetrics.TEST_SUCCESS_DENSITY).on((InputComponent)inputFile).withValue((Serializable)Double.valueOf(percentage)).save();
        }
        this.saveResults(inputFile, report);
    }

    protected void saveResults(InputFile testFile, UnitTestClassReport report) {
        for (UnitTestResult unitTestResult : report.getResults()) {
            MutableTestPlan testPlan = (MutableTestPlan)this.perspectives.as(MutableTestPlan.class, (InputPath)testFile);
            if (testPlan == null) continue;
            testPlan.addTestCase(unitTestResult.getName()).setDurationInMs(Long.valueOf(Math.max(unitTestResult.getDurationMilliseconds(), 0L))).setStatus(TestCase.Status.of((String)unitTestResult.getStatus())).setMessage(unitTestResult.getMessage()).setStackTrace(unitTestResult.getStackTrace());
        }
    }

    protected InputFile getUnitTestResource(String classKey) {
        return this.javaResourceLocator.findResourceByClassName(classKey);
    }

    private static <T extends Serializable> void saveMeasure(SensorContext context, InputFile inputFile, org.sonar.api.measures.Metric<T> metric, T value) {
        context.newMeasure().forMetric(metric).on((InputComponent)inputFile).withValue(value).save();
    }
}

