/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.log;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.ConsoleFormatter;
import org.sonar.api.utils.log.LogAndArguments;
import org.sonar.api.utils.log.LogInterceptor;
import org.sonar.api.utils.log.LoggerLevel;

public class ListInterceptor
implements LogInterceptor {
    private final List<LogAndArguments> logs = new CopyOnWriteArrayList<LogAndArguments>();
    private final Map<LoggerLevel, List<LogAndArguments>> logsByLevel = new ConcurrentHashMap<LoggerLevel, List<LogAndArguments>>();

    @Override
    public void log(LoggerLevel level, String msg) {
        LogAndArguments l = new LogAndArguments(msg, msg);
        this.add(level, l);
    }

    @Override
    public void log(LoggerLevel level, String msg, @Nullable Object arg) {
        String s = ConsoleFormatter.format(msg, arg);
        LogAndArguments l = new LogAndArguments(s, msg, arg);
        this.add(level, l);
    }

    @Override
    public void log(LoggerLevel level, String msg, @Nullable Object arg1, @Nullable Object arg2) {
        String s = ConsoleFormatter.format(msg, arg1, arg2);
        LogAndArguments l = new LogAndArguments(s, msg, arg1, arg2);
        this.add(level, l);
    }

    @Override
    public void log(LoggerLevel level, String msg, Object ... args) {
        String s = ConsoleFormatter.format(msg, args);
        LogAndArguments l = new LogAndArguments(s, msg, args);
        this.add(level, l);
    }

    @Override
    public void log(LoggerLevel level, String msg, Throwable thrown) {
        LogAndArguments l = new LogAndArguments(msg, msg, (Object)thrown);
        this.add(level, l);
    }

    private void add(LoggerLevel level, LogAndArguments l) {
        this.logs.add(l);
        this.logsByLevel.compute(level, (key, existingList) -> {
            if (existingList == null) {
                return new CopyOnWriteArrayList<LogAndArguments>(new LogAndArguments[]{l});
            }
            existingList.add(l);
            return existingList;
        });
    }

    public List<String> logs() {
        return this.logs.stream().map(LogAndArguments::getFormattedMsg).collect(Collectors.toList());
    }

    public List<String> logs(LoggerLevel level) {
        List<LogAndArguments> res = this.logsByLevel.get((Object)level);
        if (res == null) {
            return Collections.emptyList();
        }
        return res.stream().map(LogAndArguments::getFormattedMsg).collect(Collectors.toList());
    }

    public List<LogAndArguments> getLogs() {
        return this.logs;
    }

    public List<LogAndArguments> getLogs(LoggerLevel level) {
        return this.logsByLevel.get((Object)level);
    }

    public void clear() {
        this.logs.clear();
        this.logsByLevel.clear();
    }
}

