/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import org.sonar.api.ExtensionPoint;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.Preconditions;

@ServerSide
@ExtensionPoint
public abstract class ServletFilter
implements Filter {
    public UrlPattern doGetPattern() {
        return UrlPattern.builder().build();
    }

    public static final class UrlPattern {
        private static final String MATCH_ALL = "/*";
        private final List<String> inclusions;
        private final List<String> exclusions;
        private final Predicate<String>[] inclusionPredicates;
        private final Predicate<String>[] exclusionPredicates;

        private UrlPattern(Builder builder) {
            this.inclusions = Collections.unmodifiableList(new ArrayList(builder.inclusions));
            this.exclusions = Collections.unmodifiableList(new ArrayList(builder.exclusions));
            this.inclusionPredicates = builder.inclusionPredicates.isEmpty() ? new Predicate[]{s -> true} : (Predicate[])builder.inclusionPredicates.stream().toArray(Predicate[]::new);
            this.exclusionPredicates = (Predicate[])builder.exclusionPredicates.stream().toArray(Predicate[]::new);
        }

        public boolean matches(String path) {
            return !Arrays.stream(this.exclusionPredicates).anyMatch(pattern -> pattern.test(path)) && Arrays.stream(this.inclusionPredicates).anyMatch(pattern -> pattern.test(path));
        }

        public Collection<String> getInclusions() {
            return this.inclusions;
        }

        public Collection<String> getExclusions() {
            return this.exclusions;
        }

        public String label() {
            return "UrlPattern{inclusions=[" + UrlPattern.convertPatternsToString(this.inclusions) + "], exclusions=[" + UrlPattern.convertPatternsToString(this.exclusions) + "]" + '}';
        }

        private static String convertPatternsToString(List<String> input) {
            StringBuilder output = new StringBuilder();
            if (input.isEmpty()) {
                return "";
            }
            if (input.size() == 1) {
                return output.append(input.get(0)).toString();
            }
            return output.append(input.get(0)).append(", ...").toString();
        }

        public static UrlPattern create(String inclusionPattern) {
            return UrlPattern.builder().includes(inclusionPattern).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private static final String WILDCARD_CHAR = "*";
            private static final Collection<String> STATIC_RESOURCES = Collections.unmodifiableList(Arrays.asList("*.css", "*.css.map", "*.ico", "*.png", "*.jpg", "*.jpeg", "*.gif", "*.svg", "*.js", "*.js.map", "*.pdf", "/json/*", "/static/*", "/robots.txt", "/favicon.ico", "/apple-touch-icon*", "/mstile*"));
            private final Set<String> inclusions = new LinkedHashSet<String>();
            private final Set<String> exclusions = new LinkedHashSet<String>();
            private final Set<Predicate<String>> inclusionPredicates = new HashSet<Predicate<String>>();
            private final Set<Predicate<String>> exclusionPredicates = new HashSet<Predicate<String>>();

            private Builder() {
            }

            public static Collection<String> staticResourcePatterns() {
                return STATIC_RESOURCES;
            }

            public Builder includes(String ... includePatterns) {
                return this.includes(Arrays.asList(includePatterns));
            }

            public Builder includes(Collection<String> includePatterns) {
                this.inclusions.addAll(includePatterns);
                this.inclusionPredicates.addAll(includePatterns.stream().filter(pattern -> !UrlPattern.MATCH_ALL.equals(pattern)).map(Builder::compile).collect(Collectors.toList()));
                return this;
            }

            public Builder excludes(String ... excludePatterns) {
                return this.excludes(Arrays.asList(excludePatterns));
            }

            public Builder excludes(Collection<String> excludePatterns) {
                this.exclusions.addAll(excludePatterns);
                this.exclusionPredicates.addAll(excludePatterns.stream().map(Builder::compile).collect(Collectors.toList()));
                return this;
            }

            public UrlPattern build() {
                return new UrlPattern(this);
            }

            private static Predicate<String> compile(String pattern) {
                int countStars = pattern.length() - pattern.replace(WILDCARD_CHAR, "").length();
                if (countStars == 0) {
                    Preconditions.checkArgument(pattern.startsWith("/"), "URL pattern must start with slash '/': %s", pattern);
                    return url -> url.equals(pattern);
                }
                Preconditions.checkArgument(countStars == 1, "URL pattern accepts only zero or one wildcard character '*': %s", pattern);
                if (pattern.charAt(0) == '/') {
                    Preconditions.checkArgument(pattern.endsWith(WILDCARD_CHAR), "URL pattern must end with wildcard character '*': %s", pattern);
                    if (pattern.endsWith(UrlPattern.MATCH_ALL)) {
                        String path = pattern.substring(0, pattern.length() - UrlPattern.MATCH_ALL.length());
                        return url -> url.startsWith(path);
                    }
                    if (pattern.endsWith(".*")) {
                        String path = pattern.substring(0, pattern.length() - ".*".length());
                        return url -> StringUtils.substringBeforeLast(url, ".").equals(path);
                    }
                    String path = pattern.substring(0, pattern.length() - WILDCARD_CHAR.length());
                    return url -> url.startsWith(path);
                }
                Preconditions.checkArgument(pattern.startsWith(WILDCARD_CHAR), "URL pattern must start with wildcard character '*': %s", pattern);
                String path = pattern.substring(1);
                return url -> url.endsWith(path);
            }
        }
    }
}

