/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.headers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.restdocs.headers.HeaderDescriptor;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.snippet.SnippetException;
import org.springframework.restdocs.snippet.TemplatedSnippet;
import org.springframework.util.Assert;

public abstract class AbstractHeadersSnippet
extends TemplatedSnippet {
    private List<HeaderDescriptor> headerDescriptors;
    private String type;

    protected AbstractHeadersSnippet(String type, List<HeaderDescriptor> descriptors, Map<String, Object> attributes) {
        super(type + "-headers", attributes);
        for (HeaderDescriptor descriptor : descriptors) {
            Assert.notNull((Object)descriptor.getName());
            Assert.notNull((Object)descriptor.getDescription());
        }
        this.headerDescriptors = descriptors;
        this.type = type;
    }

    @Override
    protected Map<String, Object> createModel(Operation operation) {
        this.validateHeaderDocumentation(operation);
        HashMap<String, Object> model = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> headers = new ArrayList<Map<String, Object>>();
        model.put("headers", headers);
        for (HeaderDescriptor descriptor : this.headerDescriptors) {
            headers.add(this.createModelForDescriptor(descriptor));
        }
        return model;
    }

    private void validateHeaderDocumentation(Operation operation) {
        List<HeaderDescriptor> missingHeaders = this.findMissingHeaders(operation);
        if (!missingHeaders.isEmpty()) {
            ArrayList<String> names = new ArrayList<String>();
            for (HeaderDescriptor headerDescriptor : missingHeaders) {
                names.add(headerDescriptor.getName());
            }
            throw new SnippetException("Headers with the following names were not found in the " + this.type + ": " + names);
        }
    }

    protected List<HeaderDescriptor> findMissingHeaders(Operation operation) {
        ArrayList<HeaderDescriptor> missingHeaders = new ArrayList<HeaderDescriptor>();
        Set<String> actualHeaders = this.extractActualHeaders(operation);
        for (HeaderDescriptor headerDescriptor : this.headerDescriptors) {
            if (headerDescriptor.isOptional() || actualHeaders.contains(headerDescriptor.getName())) continue;
            missingHeaders.add(headerDescriptor);
        }
        return missingHeaders;
    }

    protected abstract Set<String> extractActualHeaders(Operation var1);

    protected final List<HeaderDescriptor> getHeaderDescriptors() {
        return this.headerDescriptors;
    }

    protected Map<String, Object> createModelForDescriptor(HeaderDescriptor descriptor) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("name", descriptor.getName());
        model.put("description", descriptor.getDescription());
        model.put("optional", descriptor.isOptional());
        model.putAll(descriptor.getAttributes());
        return model;
    }
}

