/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.hypermedia;

import org.springframework.core.style.ToStringCreator;

public class Link {
    private final String rel;
    private final String href;
    private final String title;

    public Link(String rel, String href) {
        this(rel, href, null);
    }

    public Link(String rel, String href, String title) {
        this.rel = rel;
        this.href = href;
        this.title = title;
    }

    public String getRel() {
        return this.rel;
    }

    public String getHref() {
        return this.href;
    }

    public String getTitle() {
        return this.title;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.href.hashCode();
        result = 31 * result + this.rel.hashCode();
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Link other = (Link)obj;
        if (!this.href.equals(other.href)) {
            return false;
        }
        if (!this.rel.equals(other.rel)) {
            return false;
        }
        return !(this.title == null ? other.title != null : !this.title.equals(other.title));
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("rel", (Object)this.rel).append("href", (Object)this.href).append("title", (Object)this.title).toString();
    }
}

