/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.hypermedia;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.restdocs.hypermedia.Link;
import org.springframework.restdocs.hypermedia.LinkDescriptor;
import org.springframework.restdocs.hypermedia.LinkExtractor;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.operation.OperationResponse;
import org.springframework.restdocs.snippet.ModelCreationException;
import org.springframework.restdocs.snippet.SnippetException;
import org.springframework.restdocs.snippet.TemplatedSnippet;
import org.springframework.util.Assert;

public class LinksSnippet
extends TemplatedSnippet {
    private final Map<String, LinkDescriptor> descriptorsByRel = new LinkedHashMap<String, LinkDescriptor>();
    private final LinkExtractor linkExtractor;
    private final boolean ignoreUndocumentedLinks;

    protected LinksSnippet(LinkExtractor linkExtractor, List<LinkDescriptor> descriptors) {
        this(linkExtractor, descriptors, null, false);
    }

    protected LinksSnippet(LinkExtractor linkExtractor, List<LinkDescriptor> descriptors, boolean ignoreUndocumentedLinks) {
        this(linkExtractor, descriptors, null, ignoreUndocumentedLinks);
    }

    protected LinksSnippet(LinkExtractor linkExtractor, List<LinkDescriptor> descriptors, Map<String, Object> attributes) {
        this(linkExtractor, descriptors, attributes, false);
    }

    protected LinksSnippet(LinkExtractor linkExtractor, List<LinkDescriptor> descriptors, Map<String, Object> attributes, boolean ignoreUndocumentedLinks) {
        super("links", attributes);
        this.linkExtractor = linkExtractor;
        for (LinkDescriptor descriptor : descriptors) {
            Assert.notNull((Object)descriptor.getRel(), (String)"Link descriptors must have a rel");
            this.descriptorsByRel.put(descriptor.getRel(), descriptor);
        }
        this.ignoreUndocumentedLinks = ignoreUndocumentedLinks;
    }

    @Override
    protected Map<String, Object> createModel(Operation operation) {
        Map<String, List<Link>> links;
        OperationResponse response = operation.getResponse();
        try {
            links = this.linkExtractor.extractLinks(response);
            this.validate(links);
        }
        catch (IOException ex) {
            throw new ModelCreationException(ex);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("links", this.createLinksModel(links));
        return model;
    }

    private void validate(Map<String, List<Link>> links) {
        Set undocumentedRels;
        Set<String> actualRels = links.keySet();
        if (this.ignoreUndocumentedLinks) {
            undocumentedRels = Collections.emptySet();
        } else {
            undocumentedRels = new HashSet<String>(actualRels);
            undocumentedRels.removeAll(this.descriptorsByRel.keySet());
        }
        HashSet<String> requiredRels = new HashSet<String>();
        for (Map.Entry<String, LinkDescriptor> relAndDescriptor : this.descriptorsByRel.entrySet()) {
            if (relAndDescriptor.getValue().isOptional()) continue;
            requiredRels.add(relAndDescriptor.getKey());
        }
        HashSet missingRels = new HashSet(requiredRels);
        missingRels.removeAll(actualRels);
        if (!undocumentedRels.isEmpty() || !missingRels.isEmpty()) {
            String message = "";
            if (!undocumentedRels.isEmpty()) {
                message = message + "Links with the following relations were not documented: " + undocumentedRels;
            }
            if (!missingRels.isEmpty()) {
                if (message.length() > 0) {
                    message = message + ". ";
                }
                message = message + "Links with the following relations were not found in the response: " + missingRels;
            }
            throw new SnippetException(message);
        }
    }

    private List<Map<String, Object>> createLinksModel(Map<String, List<Link>> links) {
        ArrayList<Map<String, Object>> model = new ArrayList<Map<String, Object>>();
        for (Map.Entry<String, LinkDescriptor> entry : this.descriptorsByRel.entrySet()) {
            LinkDescriptor descriptor = entry.getValue();
            if (descriptor.isIgnored()) continue;
            if (descriptor.getDescription() == null) {
                descriptor = this.createDescriptor(this.getDescriptionFromLinkTitle(links, descriptor.getRel()), descriptor);
            }
            model.add(this.createModelForDescriptor(descriptor));
        }
        return model;
    }

    private String getDescriptionFromLinkTitle(Map<String, List<Link>> links, String rel) {
        List<Link> linksForRel = links.get(rel);
        if (linksForRel != null) {
            for (Link link : linksForRel) {
                if (link.getTitle() == null) continue;
                return link.getTitle();
            }
        }
        throw new SnippetException("No description was provided for the link with rel '" + rel + "' and no title was available from the link in the payload");
    }

    private LinkDescriptor createDescriptor(String description, LinkDescriptor source) {
        LinkDescriptor newDescriptor = (LinkDescriptor)new LinkDescriptor(source.getRel()).description(description);
        if (source.isOptional()) {
            newDescriptor.optional();
        }
        if (source.isIgnored()) {
            newDescriptor.ignored();
        }
        return newDescriptor;
    }

    protected final Map<String, LinkDescriptor> getDescriptorsByRel() {
        return this.descriptorsByRel;
    }

    protected Map<String, Object> createModelForDescriptor(LinkDescriptor descriptor) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("rel", descriptor.getRel());
        model.put("description", descriptor.getDescription());
        model.put("optional", descriptor.isOptional());
        model.putAll(descriptor.getAttributes());
        return model;
    }

    public final LinksSnippet and(LinkDescriptor ... additionalDescriptors) {
        return this.and(Arrays.asList(additionalDescriptors));
    }

    public final LinksSnippet and(List<LinkDescriptor> additionalDescriptors) {
        ArrayList<LinkDescriptor> combinedDescriptors = new ArrayList<LinkDescriptor>(this.descriptorsByRel.values());
        combinedDescriptors.addAll(additionalDescriptors);
        return new LinksSnippet(this.linkExtractor, combinedDescriptors, this.getAttributes());
    }
}

