/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.operation.preprocess;

import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.OperationRequestFactory;
import org.springframework.restdocs.operation.OperationResponse;
import org.springframework.restdocs.operation.OperationResponseFactory;
import org.springframework.restdocs.operation.preprocess.ContentModifier;
import org.springframework.restdocs.operation.preprocess.OperationPreprocessor;

public class ContentModifyingOperationPreprocessor
implements OperationPreprocessor {
    private final OperationRequestFactory requestFactory = new OperationRequestFactory();
    private final OperationResponseFactory responseFactory = new OperationResponseFactory();
    private final ContentModifier contentModifier;

    public ContentModifyingOperationPreprocessor(ContentModifier contentModifier) {
        this.contentModifier = contentModifier;
    }

    @Override
    public OperationRequest preprocess(OperationRequest request) {
        byte[] modifiedContent = this.contentModifier.modifyContent(request.getContent(), request.getHeaders().getContentType());
        return this.requestFactory.createFrom(request, modifiedContent);
    }

    @Override
    public OperationResponse preprocess(OperationResponse response) {
        byte[] modifiedContent = this.contentModifier.modifyContent(response.getContent(), response.getHeaders().getContentType());
        return this.responseFactory.createFrom(response, modifiedContent);
    }
}

