/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.operation.preprocess;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.OperationRequestFactory;
import org.springframework.restdocs.operation.Parameters;
import org.springframework.restdocs.operation.preprocess.OperationPreprocessorAdapter;
import org.springframework.util.Assert;

public final class ParametersModifyingOperationPreprocessor
extends OperationPreprocessorAdapter {
    private final OperationRequestFactory requestFactory = new OperationRequestFactory();
    private final List<Modification> modifications = new ArrayList<Modification>();

    @Override
    public OperationRequest preprocess(OperationRequest request) {
        Parameters parameters = new Parameters();
        parameters.putAll((Map)((Object)request.getParameters()));
        for (Modification modification : this.modifications) {
            modification.apply(parameters);
        }
        return this.requestFactory.createFrom(request, parameters);
    }

    public ParametersModifyingOperationPreprocessor add(String name, String value) {
        this.modifications.add(new AddParameterModification(name, value));
        return this;
    }

    public ParametersModifyingOperationPreprocessor set(String name, String ... values) {
        Assert.notEmpty((Object[])values, (String)"At least one value must be provided");
        this.modifications.add(new SetParameterModification(name, Arrays.asList(values)));
        return this;
    }

    public ParametersModifyingOperationPreprocessor remove(String name) {
        this.modifications.add(new RemoveParameterModification(name));
        return this;
    }

    public ParametersModifyingOperationPreprocessor remove(String name, String value) {
        this.modifications.add(new RemoveValueParameterModification(name, value));
        return this;
    }

    private static final class RemoveValueParameterModification
    implements Modification {
        private final String name;
        private final String value;

        private RemoveValueParameterModification(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public void apply(Parameters parameters) {
            List values = parameters.get(this.name);
            if (values != null) {
                values.remove(this.value);
                if (values.isEmpty()) {
                    parameters.remove(this.name);
                }
            }
        }
    }

    private static final class RemoveParameterModification
    implements Modification {
        private final String name;

        private RemoveParameterModification(String name) {
            this.name = name;
        }

        @Override
        public void apply(Parameters parameters) {
            parameters.remove(this.name);
        }
    }

    private static final class SetParameterModification
    implements Modification {
        private final String name;
        private final List<String> values;

        private SetParameterModification(String name, List<String> values) {
            this.name = name;
            this.values = values;
        }

        @Override
        public void apply(Parameters parameters) {
            parameters.put(this.name, this.values);
        }
    }

    private static final class AddParameterModification
    implements Modification {
        private final String name;
        private final String value;

        private AddParameterModification(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public void apply(Parameters parameters) {
            parameters.add(this.name, this.value);
        }
    }

    private static interface Modification {
        public void apply(Parameters var1);
    }
}

