/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.request;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.request.AbstractParametersSnippet;
import org.springframework.restdocs.request.ParameterDescriptor;
import org.springframework.restdocs.snippet.SnippetException;
import org.springframework.util.Assert;

public class PathParametersSnippet
extends AbstractParametersSnippet {
    private static final Pattern NAMES_PATTERN = Pattern.compile("\\{([^/]+?)\\}");

    protected PathParametersSnippet(List<ParameterDescriptor> descriptors) {
        this(descriptors, null, false);
    }

    protected PathParametersSnippet(List<ParameterDescriptor> descriptors, boolean ignoreUndocumentedParameters) {
        this(descriptors, null, ignoreUndocumentedParameters);
    }

    protected PathParametersSnippet(List<ParameterDescriptor> descriptors, Map<String, Object> attributes) {
        this(descriptors, attributes, false);
    }

    protected PathParametersSnippet(List<ParameterDescriptor> descriptors, Map<String, Object> attributes, boolean ignoreUndocumentedParameters) {
        super("path-parameters", descriptors, attributes, ignoreUndocumentedParameters);
    }

    @Override
    protected Map<String, Object> createModel(Operation operation) {
        Map<String, Object> model = super.createModel(operation);
        model.put("path", this.removeQueryStringIfPresent(this.extractUrlTemplate(operation)));
        return model;
    }

    private String removeQueryStringIfPresent(String urlTemplate) {
        int index = urlTemplate.indexOf(63);
        if (index == -1) {
            return urlTemplate;
        }
        return urlTemplate.substring(0, index);
    }

    @Override
    protected Set<String> extractActualParameters(Operation operation) {
        String urlTemplate = this.removeQueryStringIfPresent(this.extractUrlTemplate(operation));
        Matcher matcher = NAMES_PATTERN.matcher(urlTemplate);
        HashSet<String> actualParameters = new HashSet<String>();
        while (matcher.find()) {
            String match = matcher.group(1);
            actualParameters.add(PathParametersSnippet.getParameterName(match));
        }
        return actualParameters;
    }

    private String extractUrlTemplate(Operation operation) {
        String urlTemplate = (String)operation.getAttributes().get("org.springframework.restdocs.urlTemplate");
        Assert.notNull((Object)urlTemplate, (String)"urlTemplate not found. If you are using MockMvc did you use RestDocumentationRequestBuilders to build the request?");
        return urlTemplate;
    }

    private static String getParameterName(String match) {
        int colonIndex = match.indexOf(58);
        return colonIndex != -1 ? match.substring(0, colonIndex) : match;
    }

    @Override
    protected void verificationFailed(Set<String> undocumentedParameters, Set<String> missingParameters) {
        String message = "";
        if (!undocumentedParameters.isEmpty()) {
            message = message + "Path parameters with the following names were not documented: " + undocumentedParameters;
        }
        if (!missingParameters.isEmpty()) {
            if (message.length() > 0) {
                message = message + ". ";
            }
            message = message + "Path parameters with the following names were not found in the request: " + missingParameters;
        }
        throw new SnippetException(message);
    }

    public final PathParametersSnippet and(ParameterDescriptor ... additionalDescriptors) {
        return this.and(Arrays.asList(additionalDescriptors));
    }

    public final PathParametersSnippet and(List<ParameterDescriptor> additionalDescriptors) {
        ArrayList<ParameterDescriptor> combinedDescriptors = new ArrayList<ParameterDescriptor>(this.getParameterDescriptors().values());
        combinedDescriptors.addAll(additionalDescriptors);
        return new PathParametersSnippet(combinedDescriptors, this.getAttributes());
    }
}

