/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.snippet;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.springframework.restdocs.RestDocumentationContext;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.snippet.Snippet;
import org.springframework.restdocs.snippet.WriterResolver;
import org.springframework.restdocs.templates.TemplateEngine;

public abstract class TemplatedSnippet
implements Snippet {
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final String snippetName;

    protected TemplatedSnippet(String snippetName, Map<String, Object> attributes) {
        this.snippetName = snippetName;
        if (attributes != null) {
            this.attributes.putAll(attributes);
        }
    }

    @Override
    public void document(Operation operation) throws IOException {
        RestDocumentationContext context = (RestDocumentationContext)operation.getAttributes().get(RestDocumentationContext.class.getName());
        WriterResolver writerResolver = (WriterResolver)operation.getAttributes().get(WriterResolver.class.getName());
        try (Writer writer = writerResolver.resolve(operation.getName(), this.snippetName, context);){
            Map<String, Object> model = this.createModel(operation);
            model.putAll(this.attributes);
            TemplateEngine templateEngine = (TemplateEngine)operation.getAttributes().get(TemplateEngine.class.getName());
            writer.append(templateEngine.compileTemplate(this.snippetName).render(model));
        }
    }

    protected abstract Map<String, Object> createModel(Operation var1);

    protected final Map<String, Object> getAttributes() {
        return this.attributes;
    }

    protected final String getSnippetName() {
        return this.snippetName;
    }
}

