/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs;

import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.springframework.restdocs.ManualRestDocumentation;
import org.springframework.restdocs.RestDocumentationContext;
import org.springframework.restdocs.RestDocumentationContextProvider;

public class JUnitRestDocumentation
implements RestDocumentationContextProvider,
TestRule {
    private final ManualRestDocumentation delegate;

    public JUnitRestDocumentation() {
        this.delegate = new ManualRestDocumentation();
    }

    public JUnitRestDocumentation(String outputDirectory) {
        this.delegate = new ManualRestDocumentation(outputDirectory);
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Class testClass = description.getTestClass();
                String methodName = description.getMethodName();
                JUnitRestDocumentation.this.delegate.beforeTest(testClass, methodName);
                try {
                    base.evaluate();
                }
                finally {
                    JUnitRestDocumentation.this.delegate.afterTest();
                }
            }
        };
    }

    @Override
    public RestDocumentationContext beforeOperation() {
        return this.delegate.beforeOperation();
    }
}

